/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbankkern.impl.migration;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQuery;
import de.planetensuche.datamodel.api.ObjektKategorie;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.impl.migration.DatabaseUpdater;
import de.planetensuche.datenbankkern.impl.migration.MigrationHelper;
import de.planetensuche.datenbankkern.querydsl5.QDaten;
import de.planetensuche.datenbankkern.querydsl5.QEntdecker;
import de.planetensuche.datenbankkern.querydsl5.QKategorie;
import de.planetensuche.datenbankkern.querydsl5.QObjekttypen;
import de.planetensuche.datenbankkern.querydsl5.QZtentdecker;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.sql.SQLException;
import java.util.List;

public final class Version100Migrator
implements DatabaseUpdater {
    private static final ILogging LOGGER = LoggingFactory.getLoggerForClass(Version100Migrator.class);
    private final IDatenbankverbinder datenbankverbinder;
    private final MigrationHelper helper;

    public Version100Migrator(IDatenbankverbinder iDatenbankverbinder) {
        this.datenbankverbinder = iDatenbankverbinder;
        this.helper = new MigrationHelper(iDatenbankverbinder);
    }

    @Override
    public void update() throws SQLException {
        LOGGER.debug("starting DB migration to Version " + this.updateToVersion());
        QDaten qDaten = QDaten.daten;
        QEntdecker qEntdecker = QEntdecker.entdecker;
        QZtentdecker qZtentdecker = QZtentdecker.ztentdecker;
        QObjekttypen qObjekttypen = QObjekttypen.objekttypen;
        QKategorie qKategorie = QKategorie.kategorie;
        List list = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qObjekttypen.id).from((Expression<?>)qObjekttypen)).where(qObjekttypen.kategorieid.eq((Expression)((SQLQuery)SQLExpressions.select(qKategorie.id).from((Expression<?>)qKategorie)).where(qKategorie.name.eq(ObjektKategorie.PLANETEN.getKategorienName()))))).fetch();
        List list2 = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().selectDistinct((Expression)qDaten.id).from((Expression<?>)qDaten)).leftJoin((EntityPath)qZtentdecker)).on((Predicate)qZtentdecker.datenid.eq(qDaten.id))).leftJoin((EntityPath)qEntdecker)).on((Predicate)qEntdecker.id.eq(qZtentdecker.entdeckerid))).where(qDaten.objektid.in(list).and(qEntdecker.nachname.eq("gsun")).and(qDaten.entdeckungbestaetigt.isFalse()))).fetch();
        for (Integer n : list2) {
            this.helper.deletePlanetensucheObject(n);
        }
    }

    @Override
    public int updateToVersion() {
        return 100;
    }
}

