/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbankkern.impl.migration;

import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.impl.migration.DatabaseUpdater;
import de.planetensuche.datenbankkern.impl.migration.MigrationHelper;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.sql.SQLException;
import java.util.List;

public final class Version101Migrator
implements DatabaseUpdater {
    private static final ILogging LOGGER = LoggingFactory.getLoggerForClass(Version101Migrator.class);
    private final IDatenbankverbinder datenbankverbinder;
    private final MigrationHelper helper;

    public Version101Migrator(IDatenbankverbinder iDatenbankverbinder) {
        this.datenbankverbinder = iDatenbankverbinder;
        this.helper = new MigrationHelper(iDatenbankverbinder);
    }

    @Override
    public void update() throws SQLException {
        LOGGER.debug("starting DB migration to Version " + this.updateToVersion());
        this.helper.renameName("HIP 398", "HIP 398 A");
        this.helper.renameName("CCDM J00049+5832AB", "CCDM J00049+5832A");
        this.helper.addNamen("HIP 398 A", "TIC 347116612");
        this.helper.createPlanetensucheObjekt(List.of("HIP 398 B", "TIC 347108900", "Gaia DR2 423079709165439488"), "Doppelstern physisch");
        this.helper.deletePlanetensucheObject("ADS 48 A");
        this.helper.addNamen("HIP 473 A", "ADS 48 A");
        this.helper.addNamen("HIP 473 A", "CABS 2");
        this.helper.addNamen("HIP 473 A", "GC 71");
        this.helper.addNamen("HIP 473 A", "GCRV 39");
        this.helper.addNamen("HIP 473 A", "GJ 4 A");
        this.helper.addNamen("HIP 473 A", "LFT 8");
        this.helper.addNamen("HIP 473 A", "LHS 1016");
        this.helper.addNamen("HIP 473 A", "LTT 10014");
        this.helper.addNamen("HIP 473 A", "NLTT 172");
        this.helper.addNamen("HIP 473 A", "SAO 36046");
        this.helper.addNamen("HIP 473 A", "WDS J00057+4549A");
        this.helper.deleteName("HD 38");
        this.helper.deleteName("HIP 473");
        this.helper.renameName("BD+45 4408", "BD+45 4408A");
        this.helper.addNamen("HIP 473 A", "TIC 439949946");
        this.helper.deleteName("2MASS J00322970+6714080");
        this.helper.deleteName("TIC 420470817");
        this.helper.deleteName("Gaia DR2 5000371045363928960");
        this.helper.addNamen("HIP 3531", "WDS J00450-0754A");
        this.helper.addNamen("HIP 3531", "TIC 3894631");
        this.helper.addNamen("HIP 3588", "WDS J00458-4155A");
        this.helper.addNamen("HIP 3588", "TIC 183564258");
        this.helper.addNamen("HIP 3588", "GJ 32 A");
        this.helper.addNamen("HIP 3588", "NLTT 2530");
        this.helper.deleteName("Gaia DR2 4925785124337178496");
        if (this.helper.existsName("TIC 51912829")) {
            this.helper.deletePlanetensucheObjects(List.of("HIP 4460"));
            this.helper.addNamen("TIC 51912829", "HIP 4460");
            this.helper.addNamen("TIC 51912829", "HD 5687");
        }
        this.helper.addNamen("HIP 4974", "HD 6307");
        this.helper.addNamen("HIP 5604", "HD 7072");
        this.helper.addNamen("HIP 5604", "WDS J01119+4748A");
        this.helper.addNamen("HIP 5604", "SAO 37007");
        this.helper.deleteName("Gaia DR2 525001653914371456");
        if (this.helper.existsName("TIC 54464870")) {
            this.helper.deletePlanetensucheObjects(List.of("HIP 6105"));
            this.helper.addNamen("TIC 54464870", "HIP 6105");
            this.helper.addNamen("TIC 54464870", "HD 7709");
        }
        if (this.helper.existsName("TIC 207084429")) {
            this.helper.deletePlanetensucheObjects(List.of("HIP 7060"));
            this.helper.addNamen("TIC 207084429", "HIP 7060");
            this.helper.addNamen("TIC 207084429", "HD 9351");
        }
        this.helper.deleteName("Gaia DR2 5022945084234631552");
        if (this.helper.existsName("TIC 29919341")) {
            this.helper.deletePlanetensucheObjects(List.of("HIP 7730"));
            this.helper.addNamen("TIC 29919341", "HIP 7730");
            this.helper.addNamen("TIC 29919341", "CCDM J01395-0724AB");
            this.helper.addNamen("TIC 29919341", "BD-08 288");
            this.helper.addNamen("TIC 29919341", "SAO 129430");
            this.helper.addNamen("TIC 29919341", "PPM 183687");
        }
        this.helper.addNamen("HIP 8166", "HD 236857");
        this.helper.deleteName("Gaia DR2 90193046200814464");
        this.helper.addNamen("HIP 8810", "HD 11487");
        this.helper.addNamen("HIP 9102", "CD-27 674");
        this.helper.addNamen("HIP 9102", "WDS J01572-2715A");
        this.helper.addNamen("HIP 9102", "TIC 33626295");
        this.helper.deleteName("TIC 632528291");
        this.helper.addNamen("HIP 10037", "TIC 290172418");
        if (this.helper.existsName("TIC 259863352")) {
            this.helper.deletePlanetensucheObjects(List.of("HIP 12548"));
            this.helper.addNamen("TIC 259863352", "HIP 12548");
            this.helper.addNamen("TIC 259863352", "HD 17215");
        }
        this.helper.addNamen("HIP 12677", "WDS J02429-0629A");
        this.helper.addNamen("HIP 13408", "WDS J02527+0628A");
        this.helper.addNamen("HIP 13408", "HD 17907");
        this.helper.addNamen("HIP 13408", "TIC 387515198");
        this.helper.deleteName("Gaia DR2 4721166525805028480");
        this.helper.renameName("SAO 75723A", "SAO 75723");
        this.helper.renameName("Gaia DR2 60787428056747520", "Gaia DR2 60787432349571456");
        if (this.helper.existsName("TIC 9858404")) {
            this.helper.deletePlanetensucheObjects(List.of("HIP 15053"));
            this.helper.addNamen("TIC 9858404", "HIP 15053");
            this.helper.addNamen("TIC 9858404", "HD 20152");
        }
        if (this.helper.existsName("TIC 153077619")) {
            this.helper.deletePlanetensucheObjects(List.of("HIP 15407"));
            this.helper.addNamen("TIC 153077619", "HIP 15407");
            this.helper.addNamen("TIC 153077619", "HD 20723");
        }
        this.helper.addNamen("HIP 15407", "WDS J03186-4239A");
        if (this.helper.existsName("TIC 153077621")) {
            this.helper.addNamen("TIC 153077621", "WDS J03186-4239B");
        } else {
            this.helper.createPlanetensucheObjekt(List.of("TIC 153077621", "WDS J03186-4239B", "TOI-454"), "Doppelstern physisch");
        }
        this.helper.addNamen("HIP 15418", "ADS 2466 AB");
        this.helper.renameName("Gaia DR2 59263096917741568", "Gaia DR2 59263092622581248");
        this.helper.addNamen("HIP 15566", "HD 20698");
        if (this.helper.existsName("TIC 138017750")) {
            this.helper.deletePlanetensucheObjects(List.of("HIP 15767"));
            this.helper.addNamen("TIC 138017750", "HIP 15767");
            this.helper.addNamen("TIC 138017750", "HD 20891");
            this.helper.addNamen("TIC 138017750", "V687 Persei");
            this.helper.addNamen("TIC 138017750", "SAO 56399");
            this.helper.addNamen("TIC 138017750", "Gaia DR2 125548289270234880");
        }
        if (this.helper.existsName("TIC 92359850")) {
            this.helper.deletePlanetensucheObjects(List.of("HIP 16212"));
            this.helper.addNamen("TIC 92359850", "HIP 16212");
            this.helper.addNamen("TIC 92359850", "BD-20 646");
            this.helper.addNamen("TIC 92359850", "SAO 168572");
            this.helper.addNamen("TIC 92359850", "WDS J03289-1959A");
        }
        if (this.helper.existsName("TIC 200807066")) {
            this.helper.deletePlanetensucheObjects(List.of("HIP 16521"));
            this.helper.addNamen("TIC 200807066", "HIP 16521");
            this.helper.addNamen("TIC 200807066", "HD 22250");
            this.helper.addNamen("TIC 200807066", "SAO 233153");
            this.helper.addNamen("TIC 200807066", "CPD-52 416");
        }
        this.helper.renameName("Gaia DR2 247893765591317504", "Gaia DR2 247893765594015744");
        this.helper.addNamen("HIP 17228", "WDS J03414+4630AB");
        this.helper.renameName("Gaia DR2 494727666398022016", "Gaia DR2 494727662100689152");
        this.helper.addNamen("HIP 17347", "WDS J03427+6950A");
        this.helper.addNamen("HIP 18429", "HD 24989");
        this.helper.addNamen("HIP 18429", "WDS J03565-4238A");
        if (this.helper.existsName("TIC 459942762")) {
            this.helper.deletePlanetensucheObjects(List.of("HIP 18761"));
            this.helper.addNamen("TIC 459942762", "HIP 18761");
            this.helper.addNamen("TIC 459942762", "HD 25275");
            this.helper.addNamen("TIC 459942762", "BD+04 620");
            this.helper.addNamen("TIC 459942762", "SAO 111562");
        }
        this.helper.addNamen("HIP 19112", "WDS J04059+1058A");
        this.helper.addNamen("HIP 19305", "WDS J04083-3251A");
        this.helper.deleteName("HD 25008");
        this.helper.addNamen("HD 25007", "WDS J04100+8042AB");
        this.helper.createPlanetensucheObjekt(List.of("HD 25008", "TYC 4522-1564-2", "WDS J04100+8042B"), "Doppelstern physisch");
        this.helper.renameName("Gaia DR2 150031183405510272", "Gaia DR2 150031179113325056");
        this.helper.addNamen("HIP 19464", "HD 283432");
        this.helper.renameName("Gaia DR2 228895991374065152", "Gaia DR2 228895991368697856");
        this.helper.addNamen("HIP 19564", "HD 26310");
        if (this.helper.existsName("TIC 7624182")) {
            this.helper.deletePlanetensucheObjects(List.of("HIP 19989"));
            this.helper.addNamen("TIC 7624182", "HIP 19989");
            this.helper.addNamen("TIC 7624182", "HD 27342");
            this.helper.addNamen("TIC 7624182", "SAO 194895");
            this.helper.addNamen("TIC 7624182", "CD-39 1416");
            this.helper.addNamen("TIC 7624182", "GC 5192");
        }
        if (this.helper.existsName("TIC 449050248")) {
            this.helper.deletePlanetensucheObjects(List.of("HIP 21000"));
            this.helper.addNamen("TIC 449050248", "HIP 21000");
            this.helper.addNamen("TIC 449050248", "ADS 3266 A");
            this.helper.addNamen("TIC 449050248", "BD+04 701A");
            this.helper.addNamen("TIC 449050248", "CCDM J04302+0518A");
            this.helper.addNamen("TIC 449050248", "GSC 00090-00207");
            this.helper.addNamen("TIC 449050248", "PPM 147612");
            this.helper.addNamen("TIC 449050248", "TYC 90-207-1");
            this.helper.addNamen("TIC 449050248", "WDS J04302+0518A");
        }
        this.helper.renameName("Gaia DR2 3185759697950315008", "Gaia DR2 3185759697949251456");
        this.helper.addNamen("HIP 21765", "WDS J04406-0912AB");
        this.helper.renameName("Gaia DR2 175511021056842624", "Gaia DR2 175511025349992960");
        if (this.helper.existsName("TIC 259511357")) {
            this.helper.deletePlanetensucheObjects(List.of("HIP 21952"));
            this.helper.addNamen("TIC 259511357", "HIP 21952");
            this.helper.addNamen("TIC 259511357", "HD 30219");
            this.helper.addNamen("TIC 259511357", "CD-50 1472");
        }
        this.helper.addNamen("HIP 21980", "HD 286990");
        this.helper.addNamen("HIP 21980", "WDS J04435+1220A");
        this.helper.addNamen("HIP 21980", "BD+12 636");
        if (this.helper.existsName("TIC 459952217")) {
            this.helper.deletePlanetensucheObjects(List.of("HIP 22084"));
            this.helper.addNamen("TIC 459952217", "HIP 22084");
            this.helper.addNamen("TIC 459952217", "HD 30124");
            this.helper.addNamen("TIC 459952217", "SAO 112040");
            this.helper.addNamen("TIC 459952217", "BD+05 721");
        }
        this.helper.addNamen("HIP 22684", "WDS J04527+2000A");
        this.helper.addNamen("HIP 22684", "Mel 25 145");
        this.helper.addNamen("HIP 22684", "TIC 18801705");
        this.helper.renameName("Gaia DR2 3188515623845496832", "Gaia DR2 3188515623844131072");
        this.helper.renameName("Gaia DR2 3226736469093460736", "Gaia DR2 3226736469093461120");
        this.helper.addNamen("HIP 22856", "WDS J04551-0033AB");
        this.helper.addNamen("HIP 22856", "GC 5997");
        this.helper.renameName("Gaia DR2 2980171639399498240", "Gaia DR2 2980171639403283328");
        this.helper.renameName("Gaia DR2 3238145723296665472", "Gaia DR2 3238145719002877696");
        this.helper.renameName("Gaia DR2 267337872813141888", "Gaia DR2 267337872817052032");
        this.helper.addNamen("HIP 23877", "HD 32652");
        this.helper.addNamen("HIP 23877", "WDS J05079+5459AB");
        if (this.helper.existsName("TIC 69672493")) {
            this.helper.deletePlanetensucheObjects(List.of("HIP 24007"));
            this.helper.addNamen("TIC 69672493", "HIP 24007");
            this.helper.addNamen("TIC 69672493", "LP 360-4");
            this.helper.addNamen("TIC 69672493", "WDS J05096+2420AB");
        }
        if (this.helper.existsName("TIC 381976956")) {
            this.helper.deletePlanetensucheObjects(List.of("HIP 24061"));
            this.helper.addNamen("TIC 381976956", "HIP 24061");
            this.helper.addNamen("TIC 381976956", "CPD-57 752");
            this.helper.addNamen("TIC 381976956", "WDS J05102-5736A");
        }
        this.helper.renameName("Gaia DR2 187282289467977984", "Gaia DR2 187282293759356032");
        this.helper.addNamen("HIP 24477", "TIC 345584999");
        this.helper.addNamen("HIP 24477", "WDS J05152+0826A");
        if (this.helper.existsName("TIC 249067445")) {
            this.helper.deletePlanetensucheObjects(List.of("HIP 24689"));
            this.helper.addNamen("TIC 249067445", "HIP 24689");
            this.helper.addNamen("TIC 249067445", "HD 34480");
            this.helper.addNamen("TIC 249067445", "BD-00 911");
            this.helper.addNamen("TIC 249067445", "SAO 131951");
        }
        this.helper.deletePlanetensucheObjects(List.of("HIP 24710"));
        this.helper.addNamen("HIP 25174", "TIC 264594193");
        this.helper.addNamen("HIP 25174", "WDS J05231+0103A");
        this.helper.addNamen("HIP 25174", "V1804 Orionis");
        this.helper.addNamen("HIP 25559", "TIC 31194599");
        this.helper.addNamen("HIP 25559", "TYC 6488-1063-1");
        this.helper.addNamen("HIP 25559", "2MASS J05274582-2848000");
        if (this.helper.existsName("TIC 143350972")) {
            this.helper.deletePlanetensucheObjects(List.of("HIP 25670"));
            this.helper.addNamen("TIC 143350972", "HIP 25670");
            this.helper.addNamen("TIC 143350972", "HD 36152");
            this.helper.addNamen("TIC 143350972", "BD-17 1147");
            this.helper.addNamen("TIC 143350972", "SAO 150490");
            this.helper.addNamen("TIC 143350972", "PPM 215830");
        }
        this.helper.renameName("HIP 26218", "HIP 26218 B");
        this.helper.addNamen("HIP 26218 B", "WDS J05353-6941B");
        this.helper.addNamen("HIP 26218 B", "TIC 277022959");
        this.helper.renameName("Gaia DR2 3441298191795447936", "Gaia DR2 3441298187500037632");
        this.helper.addNamen("HIP 26401", "WDS J05372-4243A");
        this.helper.addNamen("HIP 26401", "WX Columbae");
        this.helper.addNamen("HIP 26401", "TIC 354571604");
        this.helper.deleteName("HIP 27111 A");
        this.helper.deleteName("2MASS J05445680+0914323 A");
        this.helper.addNamen("HIP 27111", "WDS J05449+0915AB");
        this.helper.addNamen("HIP 27111", "LFT 430");
        this.helper.renameName("Gaia DR2 3400075714161042048", "Gaia DR2 3400075714163481856");
        this.helper.addNamen("HIP 27205", "HD 38363");
        this.helper.addNamen("HIP 27205", "WDS J05460+2119A");
        this.helper.renameName("Gaia DR2 4803975552564909568", "Gaia DR2 4803975556857297152");
        if (this.helper.existsName("TIC 354006740")) {
            this.helper.deletePlanetensucheObjects(List.of("HIP 27844"));
            this.helper.addNamen("TIC 354006740", "HIP 27844");
            this.helper.addNamen("TIC 354006740", "WDS J05535+3720AB");
            this.helper.addNamen("TIC 354006740", "HD 39315");
            this.helper.addNamen("TIC 354006740", "BD+37 1347");
        }
        if (this.helper.existsName("TIC 102283403")) {
            this.helper.deletePlanetensucheObjects(List.of("HIP 28122"));
            this.helper.addNamen("TIC 102283403", "HIP 28122");
            this.helper.addNamen("TIC 102283403", "HD 40007");
            this.helper.addNamen("TIC 102283403", "BD+10 936");
            this.helper.addNamen("TIC 102283403", "SAO 95019");
            this.helper.addNamen("TIC 102283403", "WDS J05566+1033A");
            this.helper.addNamen("TIC 102283403", "PPM 121622");
        }
        this.helper.addNamen("HIP 29769", "HD 43956");
        this.helper.addNamen("HIP 29769", "CD-52 1506");
        this.helper.addNamen("HIP 29769", "WDS J06161-5234AB");
        this.helper.renameName("Gaia DR2 5549006834861464448", "Gaia DR2 5549006830564411648");
        this.helper.renameName("Gaia DR2 3331440036533364096", "Gaia DR2 3331440040831767424");
        this.helper.addNamen("HIP 31156", "WDS J06323+1747B");
        this.helper.addNamen("HIP 31156", "HD 46136B");
        this.helper.addNamen("HIP 31156", "GC 8481");
        this.helper.renameName("HD 46136", "HD 46136A");
        this.helper.renameName("2MASS J06321780+1746465", "2MASS J06321851+1747036");
        this.helper.renameName("Gaia DR2 3386123083405937664", "Gaia DR2 3386123083403623168");
        if (this.helper.existsName("TIC 120269103")) {
            this.helper.deletePlanetensucheObjects(List.of("HIP 32483"));
            this.helper.addNamen("TIC 120269103", "HIP 32483");
            this.helper.addNamen("TIC 120269103", "HD 49145");
            this.helper.addNamen("TIC 120269103", "BD-05 1797");
            this.helper.addNamen("TIC 120269103", "WDS J06468-0609A");
            this.helper.addNamen("TIC 120269103", "Gaia DR2 3100379149723096704");
        }
        if (this.helper.existsName("TIC 96246348")) {
            this.helper.deletePlanetensucheObjects(List.of("HIP 33170"));
            this.helper.addNamen("TIC 96246348", "HIP 33170");
            this.helper.addNamen("TIC 96246348", "CCDM J06542-3413AB");
            this.helper.addNamen("TIC 96246348", "WDS J06542-3413AB");
            this.helper.addNamen("TIC 96246348", "CD-34 3182");
            this.helper.addNamen("TIC 96246348", "HD 51042");
            this.helper.addNamen("TIC 96246348", "GC 9068");
            this.helper.addNamen("TIC 96246348", "SAO 197334");
        }
        if (this.helper.existsName("TIC 279251651")) {
            this.helper.deletePlanetensucheObjects(List.of("HIP 33390"));
            this.helper.addNamen("TIC 279251651", "HIP 33390");
            this.helper.addNamen("TIC 279251651", "L 183-37");
            this.helper.addNamen("TIC 279251651", "NLTT 17232");
            this.helper.addNamen("TIC 279251651", "Gaia DR2 5480636002093933312");
            this.helper.addNamen("TIC 279251651", "TYC 8549-1819-1");
        }
        if (this.helper.existsName("TIC 167754523")) {
            this.helper.deletePlanetensucheObjects(List.of("HIP 33392"));
            this.helper.addNamen("TIC 167754523", "HIP 33392");
            this.helper.addNamen("TIC 167754523", "CD-60 1611");
            this.helper.addNamen("TIC 167754523", "Gaia DR2 5479504437127465088");
            this.helper.addNamen("TIC 167754523", "WDS J06567-6041Aa");
            this.helper.addNamen("TIC 167754523", "LTT 2697");
        }
        if (this.helper.existsName("TIC 130415266")) {
            this.helper.deletePlanetensucheObjects(List.of("HIP 33609"));
            this.helper.addNamen("TIC 130415266", "HIP 33609");
            this.helper.addNamen("TIC 130415266", "Gaia DR2 5557593814516968960");
            this.helper.addNamen("TIC 130415266", "HD 52470");
            this.helper.addNamen("TIC 130415266", "CD-46 2811");
            this.helper.addNamen("TIC 130415266", "GC 9208");
        }
        if (this.helper.existsName("TIC 238086647")) {
            this.helper.deletePlanetensucheObjects(List.of("HIP 33681"));
            this.helper.addNamen("TIC 238086647", "HIP 33681");
            this.helper.addNamen("TIC 238086647", "Gaia DR2 5508330367833229824");
            this.helper.addNamen("TIC 238086647", "HD 52758");
            this.helper.addNamen("TIC 238086647", "CD-49 2554");
            this.helper.addNamen("TIC 238086647", "WDS J06598-4930A");
            this.helper.addNamen("TIC 238086647", "SAO 218377");
        }
        this.helper.addNamen("HIP 34154", "WDS J07049+7240A");
        this.helper.addNamen("HIP 34154", "TIC 154343070");
        this.helper.addNamen("HIP 34217", "TIC 252939881");
        this.helper.addNamen("HIP 34217", "WDS J07057+5245A");
        this.helper.renameName("Gaia DR2 3044785161760358400", "Gaia DR2 3044785161766215680");
        if (this.helper.existsName("TIC 97700520")) {
            this.helper.deletePlanetensucheObjects(List.of("HIP 34519"));
            this.helper.addNamen("TIC 97700520", "HIP 34519");
            this.helper.addNamen("TIC 97700520", "HD 54839");
            this.helper.addNamen("TIC 97700520", "CD-31 4099");
            this.helper.addNamen("TIC 97700520", "SAO 197637");
            this.helper.addNamen("TIC 97700520", "Gaia DR2 5604231696156773760");
        }
        if (this.helper.existsName("TIC 271900960")) {
            this.helper.deletePlanetensucheObjects(List.of("HIP 36612"));
            this.helper.addNamen("TIC 271900960", "HIP 36612");
            this.helper.addNamen("TIC 271900960", "Gaia DR2 5214259282834615296");
            this.helper.addNamen("TIC 271900960", "HD 61520");
            this.helper.addNamen("TIC 271900960", "SAO 256421");
            this.helper.addNamen("TIC 271900960", "CD-75 319");
        }
        this.helper.renameName("Gaia DR2 898506097466756352", "Gaia DR2 898506093171335424");
        this.helper.addNamen("HIP 36626", "BD+36 1638A");
        this.helper.addNamen("HIP 36626", "VV Lyncis");
        this.helper.addNamen("HIP 36626", "WDS J07319+3613A");
        this.helper.addNamen("HIP 36626", "GJ 277");
        this.helper.addNamen("HIP 39060", "WDS J07595-6909AB");
        this.helper.renameName("Gaia DR2 933367522374867840", "Gaia DR2 933367522374867968");
        this.helper.addNamen("HIP 39097", "WDS J07599+4931AB");
        this.helper.addNamen("HIP 39607", "WDS J08056+2732A");
        this.helper.addNamen("HIP 39607", "TIC 95572273");
        this.helper.renameName("Gaia DR2 3090884763737944960", "Gaia DR2 3090884763735434240");
        this.helper.addNamen("HIP 39653", "WDS J08062+0201AB");
        this.helper.addNamen("HIP 39820", "WDS J08082-2208A");
        this.helper.addNamen("HIP 39820", "TIC 176355865");
        this.helper.addNamen("HIP 40167", "TIC 27550294");
        this.helper.addNamen("HIP 40167", "WDS J08122+1739A");
        this.helper.addNamen("HIP 40167", "Tegmine");
        this.helper.renameName("2MASS J08121278+1738522 A", "2MASS J08121278+1738522");
        this.helper.renameName("Gaia DR2 5726415887862017408", "Gaia DR2 5726415887862017536");
        this.helper.addNamen("HIP 40239", "WDS J08132-1354A");
        this.helper.addNamen("HIP 40239", "GJ 301 A");
        if (this.helper.existsName("TIC 309254930")) {
            this.helper.deletePlanetensucheObjects(List.of("HIP 40585"));
            this.helper.addNamen("TIC 309254930", "HIP 40585");
            this.helper.addNamen("TIC 309254930", "CCDM J08172-6540AB");
            this.helper.addNamen("TIC 309254930", "Gaia DR2 5276025997794611968");
            this.helper.addNamen("TIC 309254930", "HD 70334");
            this.helper.addNamen("TIC 309254930", "SAO 250177");
            this.helper.addNamen("TIC 309254930", "WDS J08172-6539AB");
        }
        if (this.helper.existsName("TIC 412961700")) {
            this.helper.deletePlanetensucheObjects(List.of("HIP 41603"));
            this.helper.addNamen("TIC 412961700", "HIP 41603");
            this.helper.addNamen("TIC 412961700", "HD 71833");
            this.helper.addNamen("TIC 412961700", "BD-20 2549");
            this.helper.addNamen("TIC 412961700", "GC 11602");
            this.helper.addNamen("TIC 412961700", "HR 3345");
            this.helper.addNamen("TIC 412961700", "SAO 175912");
            this.helper.addNamen("TIC 412961700", "WDS J08289-2057A");
            this.helper.addNamen("TIC 412961700", "Gaia DR2 5706229472852227840");
        }
        if (this.helper.existsName("TIC 386435344")) {
            this.helper.deletePlanetensucheObjects(List.of("HIP 41849"));
            this.helper.addNamen("TIC 386435344", "HIP 41849");
            this.helper.addNamen("TIC 386435344", "HD 72377");
            this.helper.addNamen("TIC 386435344", "Gaia DR2 5709861464697757824");
            this.helper.addNamen("TIC 386435344", "BD-16 2493");
            this.helper.addNamen("TIC 386435344", "SAO 154362");
        }
        if (this.helper.existsName("TIC 310483807")) {
            this.helper.deletePlanetensucheObjects(List.of("HIP 42067"));
            this.helper.addNamen("TIC 310483807", "HIP 42067");
            this.helper.addNamen("TIC 310483807", "HD 73289");
            this.helper.addNamen("TIC 310483807", "Gaia DR2 5301898674629223424");
            this.helper.addNamen("TIC 310483807", "WDS J08345-6129A");
            this.helper.addNamen("TIC 310483807", "SAO 250272");
            this.helper.addNamen("TIC 310483807", "CD-61 1977");
        }
        this.helper.addNamen("HIP 42647", "WDS J08415+0649A");
        this.helper.addNamen("HIP 42647", "TIC 396732488");
        this.helper.renameName("Gaia DR2 610060010878338304", "Gaia DR2 610060006586749824");
        this.helper.addNamen("HIP 43753", "WDS J08548+4335A");
        this.helper.addNamen("HIP 43753", "TIC 21532736");
        this.helper.addNamen("HIP 43753", "GC 12298");
        this.helper.addNamen("HIP 43891", "TIC 341592702");
        this.helper.addNamen("HIP 43891", "NLTT 20490");
        if (this.helper.existsName("TIC 190990336")) {
            this.helper.deletePlanetensucheObjects(List.of("HIP 43991"));
            this.helper.addNamen("TIC 190990336", "HIP 43991");
            this.helper.addNamen("TIC 190990336", "HD 76859");
            this.helper.addNamen("TIC 190990336", "Gaia DR2 5620894588719423616");
            this.helper.addNamen("TIC 190990336", "CD-39 5000");
            this.helper.addNamen("TIC 190990336", "PPM 285885");
        }
        if (this.helper.existsName("TIC 30828562")) {
            this.helper.deletePlanetensucheObject("HIP 44094");
            this.helper.addNamen("TIC 30828562", "HIP 44094");
            this.helper.addNamen("TIC 30828562", "HD 77113");
            this.helper.addNamen("TIC 30828562", "Gaia DR2 5332029175877608576");
            this.helper.addNamen("TIC 30828562", "CD-42 4844");
            this.helper.addNamen("TIC 30828562", "SAO 220712");
        }
        this.helper.renameName("Gaia DR2 576970105360152192", "Gaia DR2 576970105361183616");
        if (this.helper.existsName("TIC 37575651")) {
            this.helper.deletePlanetensucheObject("HIP 44302");
            this.helper.addNamen("TIC 37575651", "HIP 44302");
            this.helper.addNamen("TIC 37575651", "Gaia DR2 5647759987108393984");
            this.helper.addNamen("TIC 37575651", "WDS J09014-2819AB");
            this.helper.addNamen("TIC 37575651", "SAO 176839");
            this.helper.addNamen("TIC 37575651", "CD-27 6163");
            this.helper.addNamen("TIC 37575651", "HD 77397");
        }
        if (this.helper.existsName("TIC 384549882")) {
            this.helper.deletePlanetensucheObject("HIP 44664");
            this.helper.addNamen("TIC 384549882", "HIP 44664");
            this.helper.addNamen("TIC 384549882", "HD 78444");
            this.helper.addNamen("TIC 384549882", "Gaia DR2 5310970160975211008");
            this.helper.addNamen("TIC 384549882", "WDS J09061-5454AB");
            this.helper.addNamen("TIC 384549882", "SAO 236602");
            this.helper.addNamen("TIC 384549882", "CD-54 2563");
        }
        if (this.helper.existsName("TIC 170889511")) {
            this.helper.deletePlanetensucheObject("HIP 45621");
            this.helper.addNamen("TIC 170889511", "HIP 45621");
            this.helper.addNamen("TIC 170889511", "HD 80133");
            this.helper.addNamen("TIC 170889511", "Gaia DR2 3837451574150437120");
            this.helper.addNamen("TIC 170889511", "BD-02 2838");
            this.helper.addNamen("TIC 170889511", "SAO 136740");
            this.helper.addNamen("TIC 170889511", "GC 12829");
        }
        if (this.helper.existsName("TIC 297967252")) {
            this.helper.deletePlanetensucheObject("HIP 46594");
            this.helper.addNamen("TIC 297967252", "HIP 46594");
            this.helper.addNamen("TIC 297967252", "CD-50 4204");
            this.helper.addNamen("TIC 297967252", "Gaia DR2 5312912791851427840");
            this.helper.addNamen("TIC 297967252", "HD 82419");
            this.helper.addNamen("TIC 297967252", "HR 3784");
            this.helper.addNamen("TIC 297967252", "SAO 237042");
            this.helper.addNamen("TIC 297967252", "GC 13129");
        }
        this.helper.renameName("2MASS J09304200-4028004 A", "2MASS J09304200-4028004");
        this.helper.renameName("Gaia DR2 5426587107149861120", "Gaia DR2 5426587107145955712");
        this.helper.deleteName("HIP 46651 A");
        this.helper.addNamen("HIP 46651", "GJ 351 A");
        this.helper.addNamen("HIP 46651", "WDS J09307-4028A");
        if (this.helper.existsName("TIC 468997317")) {
            this.helper.deletePlanetensucheObject("HIP 47116");
            this.helper.addNamen("TIC 468997317", "HIP 47116");
            this.helper.addNamen("TIC 468997317", "HD 83358");
            this.helper.addNamen("TIC 468997317", "Gaia DR2 5312673922948554880");
            this.helper.addNamen("TIC 468997317", "CD-51 3977");
            this.helper.addNamen("TIC 468997317", "SAO 237133");
            this.helper.addNamen("TIC 468997317", "WDS J09361-5145A");
        }
        this.helper.addNamen("HIP 47228", "TIC 330795078");
        this.helper.addNamen("HIP 47228", "WDS J09375+2838AB");
        if (this.helper.existsName("TIC 33153766")) {
            this.helper.deletePlanetensucheObject("HIP 47371");
            this.helper.addNamen("TIC 33153766", "HIP 47371");
            this.helper.addNamen("TIC 33153766", "Gaia DR2 5412502363202167296");
            this.helper.addNamen("TIC 33153766", "HD 83718");
            this.helper.addNamen("TIC 33153766", "CD-44 5681");
            this.helper.addNamen("TIC 33153766", "SAO 221371");
        }
        this.helper.addNamen("HIP 47696", "HD 84196");
        this.helper.addNamen("HIP 47696", "WDS J09435+0612AB");
        this.helper.addNamen("HIP 47696", "BD+06 2206");
        if (this.helper.existsName("TIC 286132427")) {
            this.helper.deletePlanetensucheObject("HIP 47990");
            this.helper.addNamen("TIC 286132427", "HIP 47990");
            this.helper.addNamen("TIC 286132427", "SAO 137123");
            this.helper.addNamen("TIC 286132427", "BD-03 2771");
            this.helper.addNamen("TIC 286132427", "HD 84705");
        }
        this.helper.renameName("Gaia DR2 1050672528157395328", "Gaia DR2 1050672523861896960");
        this.helper.addNamen("HIP 48343", "HD 84998");
        this.helper.addNamen("HIP 48343", "GC 13542");
        this.helper.addNamen("HIP 48343", "WDS J09513+6037AB");
        this.helper.renameName("Gaia DR2 623447595737759104", "Gaia DR2 623447591447026176");
        this.helper.addNamen("HIP 49869", "WDS J10110+1834A");
        this.helper.renameName("Gaia DR2 629253773046868736", "Gaia DR2 629253768751865088");
        this.helper.renameName("Gaia DR2 5446435628488825600", "Gaia DR3 5446435628488825728");
        this.helper.addNamen("HIP 50168", "HD 88886");
        this.helper.renameName("Gaia DR2 3751547697040710016", "Gaia DR2 3751547692745683328");
        this.helper.addNamen("HIP 50645", "HD 89675");
        this.helper.addNamen("HIP 50694", "TIC 294022890");
        this.helper.addNamen("HIP 50694", "NLTT 24126");
        this.helper.addNamen("HIP 50788", "WDS J10222-6541A");
        this.helper.addNamen("HIP 50902", "WDS J10237+0021A");
        this.helper.addNamen("HIP 50902", "TIC 277798675");
        if (this.helper.existsName("TIC 447283466")) {
            this.helper.deletePlanetensucheObject("HIP 51271");
            this.helper.addNamen("TIC 447283466", "HIP 51271");
            this.helper.addNamen("TIC 447283466", "HD 90884");
            this.helper.addNamen("TIC 447283466", "CD-51 4784");
            this.helper.addNamen("TIC 447283466", "SAO 238091");
            this.helper.addNamen("TIC 447283466", "PPM 339072");
        }
        this.helper.renameName("Gaia DR2 3776849727338587008", "Gaia DR2 3776849727337984384");
        this.helper.addNamen("HIP 52671", "HD 93294");
        this.helper.addNamen("HIP 52671", "WDS J10462-0546A");
        this.helper.addNamen("HIP 52774", "TIC 281700712");
        this.helper.addNamen("HIP 52774", "WDS J10474+0236AB");
        this.helper.addNamen("HIP 53960", "TIC 156102834");
        this.helper.addNamen("HIP 53960", "WDS J11024+8313A");
        this.helper.addNamen("HIP 54485", "WDS J11088+4815A");
        this.helper.addNamen("HIP 54485", "TIC 371546489");
        this.helper.renameName("Gaia DR2 763808879317756160", "Gaia DR2 763808875022579456");
        this.helper.addNamen("HIP 54941", "HD 97731");
        this.helper.addNamen("HIP 54941", "WDS J11151+3735AB");
        this.helper.renameName("Gaia DR2 5395425092190193792", "Gaia DR2 5395425092187016960");
        this.helper.addNamen("HIP 54953", "WDS J11152-4044AB");
        this.helper.addNamen("HIP 54967", "HD 97799");
        this.helper.addNamen("HR 4444", "WDS J11323-2916A");
        this.helper.deleteName("17 Crateris");
        this.helper.renameName("Gaia DR2 3482326708703712896", "Gaia DR2 3482326708703712640");
        this.helper.deleteName("HIP 56280");
        this.helper.addNamen("HR 4444", "HIP 56280");
        this.helper.addNamen("HR 4443", "WDS J11323-2916B");
        this.helper.addNamen("HIP 56330", "TIC 416537915");
        this.helper.addNamen("HIP 56330", "HD 100284");
        this.helper.addNamen("HIP 56330", "WDS J11329+5525A");
        this.helper.renameName("Gaia DR2 4018973595207763456", "Gaia DR2 4018973590912984192");
        this.helper.addNamen("HIP 57342", "WDS J11454-5542A");
        this.helper.addNamen("HIP 57342", "TIC 267712833");
        this.helper.addNamen("HIP 58197", "WDS J11561-0409A");
        this.helper.addNamen("HIP 58197", "GJ 9383 A");
        this.helper.addNamen("HIP 58197", "TIC 96194213");
        if (this.helper.existsName("TIC 335499997")) {
            this.helper.deletePlanetensucheObject("HIP 58234");
            this.helper.addNamen("TIC 335499997", "HIP 58234");
            this.helper.addNamen("TIC 335499997", "BD-11 3209");
            this.helper.addNamen("TIC 335499997", "SAO 156999");
        }
        this.helper.addNamen("HIP 59413", "WDS J12112-5213A");
        this.helper.addNamen("HIP 59413", "TIC 334124479");
        this.helper.deleteName("HIP 59743");
        this.helper.deleteName("HD 106515");
        this.helper.addNamen("HD 106515B", "HIP 59743 B");
        this.helper.addNamen("HIP 59781", "WDS J12155-6232A");
        this.helper.addNamen("HIP 59781", "TIC 383337212");
        if (this.helper.existsName("TIC 327663613")) {
            this.helper.deletePlanetensucheObject("HIP 61737");
            this.helper.addNamen("TIC 327663613", "HIP 61737");
            this.helper.addNamen("TIC 327663613", "HD 109892");
            this.helper.addNamen("TIC 327663613", "CD-68 1111");
            this.helper.addNamen("TIC 327663613", "SAO 251983");
            this.helper.addNamen("TIC 327663613", "PPM 359536");
        }
        this.helper.renameName("Gaia DR2 5855802671032914944", "Gaia DR2 5855802671045627648");
        this.helper.addNamen("HIP 62416", "WDS J12475-5726A");
        this.helper.addNamen("HIP 62653", "GC 17432");
        this.helper.addNamen("HIP 62653", "GCRV 7686");
        this.helper.renameName("Gaia DR2 3929706445172671232", "Gaia DR2 3929706445171586816");
        this.helper.addNamen("HIP 62888", "HD 112016");
        this.helper.addNamen("HIP 63143", "TIC 150388948");
        this.helper.addNamen("HIP 63143", "WDS J12563+5406A");
        this.helper.renameName("Gaia DR2 5861903208210777984", "Gaia DR2 5861903208251705600");
        this.helper.addNamen("HIP 63470", "HD 112795");
        this.helper.deleteName("TIC 393894049");
        this.helper.deleteName("2MASS J13194569+4746409");
        this.helper.deleteName("2MASS J13194569+4746409 A");
        this.helper.deleteName("CCDM J13198+4747AB");
        this.helper.deleteName("BD+48 2108");
        this.helper.deleteName("HD 115953");
        this.helper.deleteName("HIC 65026");
        this.helper.deleteName("WDS J13198+4747AB");
        this.helper.deleteName("WEB 11489");
        this.helper.deleteName("MCC 142");
        this.helper.deleteName("GCRV 7920");
        this.helper.deleteName("DO 34346");
        this.helper.deleteName("StKM 2-930");
        this.helper.deleteName("AG+48 1060");
        this.helper.deleteName("PPM 53498");
        this.helper.deleteName("SAO 44566");
        this.helper.deleteName("CSI+48 2108 1");
        this.helper.deleteName("UCAC4 689-053939");
        this.helper.addNamen("HIP 65026", "UCAC4 689-053939");
        this.helper.addNamen("HIP 65026", "CSI+48 2108 1");
        this.helper.addNamen("HIP 65026", "StKM 2-930");
        this.helper.addNamen("HIP 65026", "AG+48 1060");
        this.helper.addNamen("HIP 65026", "PPM 53498");
        this.helper.addNamen("HIP 65026", "SAO 44566");
        this.helper.addNamen("HIP 65026", "DO 34346");
        this.helper.addNamen("HIP 65026", "GCRV 7920");
        this.helper.addNamen("HIP 65026", "MCC 142");
        this.helper.addNamen("HIP 65026", "WEB 11489");
        this.helper.addNamen("HIP 65026", "HD 115953");
        this.helper.addNamen("HIP 65026", "BD+48 2108");
        this.helper.addNamen("HIP 65026", "CCDM J13198+4747AB");
        this.helper.addNamen("HIP 65026", "TIC 393894049");
        this.helper.addNamen("HIP 65026", "WDS J13198+4747AB");
        this.helper.addNamen("HIP 65026", "2MASS J13194569+4746409");
        this.helper.addNamen("HIP 65026", "ADS 8862 AB");
        this.helper.addNamen("Zkh 198", "CCDM J13198+4747A");
        this.helper.addNamen("Zkh 198", "WDS J13198+4747A");
        this.helper.addNamen("Zkh 199", "CCDM J13198+4747B");
        this.helper.addNamen("Zkh 199", "WDS J13198+4747B");
        this.helper.renameName("Gaia DR2 3715515292249335424", "Gaia DR2 3715515292248780288");
        if (this.helper.existsName("TIC 27194429")) {
            this.helper.deletePlanetensucheObject("HIP 65205");
            this.helper.addNamen("TIC 27194429", "HIP 65205");
            this.helper.addNamen("TIC 27194429", "HD 116206");
            this.helper.addNamen("TIC 27194429", "BD+18 2722");
            this.helper.addNamen("TIC 27194429", "WDS J13218+1746A");
        }
        this.helper.addNamen("HIP 65371", "TIC 404468599");
        this.helper.addNamen("HIP 65371", "NLTT 33970");
        if (this.helper.existsName("TIC 298073824")) {
            this.helper.deletePlanetensucheObject("HIP 65489");
            this.helper.addNamen("TIC 298073824", "HIP 65489");
            this.helper.addNamen("TIC 298073824", "HD 117173");
            this.helper.addNamen("TIC 298073824", "WDS J13253+7559AB");
        }
        if (this.helper.existsName("TIC 144441148")) {
            this.helper.deletePlanetensucheObject("HIP 67650");
            this.helper.addNamen("TIC 144441148", "HIP 67650");
            this.helper.addNamen("TIC 144441148", "HD 120894");
            this.helper.addNamen("TIC 144441148", "SAO 63789");
            this.helper.addNamen("TIC 144441148", "AGKR 12385");
        }
        this.helper.deleteName("GJ 5361");
        this.helper.addNamen("HIP 68551", "GJ 536.1");
        this.helper.addNamen("HIP 68551", "WDS J14019+1530AB");
        this.helper.addNamen("HIP 68561", "WDS J14021-6711AB");
        this.helper.addNamen("HIP 69117", "TIC 393961387");
        this.helper.addNamen("HIP 69117", "WDS J14089+4608A");
        this.helper.addNamen("HIP 69201", "GJ 9468");
        this.helper.addNamen("HIP 69201", "TIC 331502493");
        if (this.helper.existsName("TIC 329888006")) {
            this.helper.deletePlanetensucheObject("HIP 69332");
            this.helper.addNamen("TIC 329888006", "HIP 69332");
            this.helper.addNamen("TIC 329888006", "CD-49 8529");
            this.helper.addNamen("TIC 329888006", "WDS J14114-5004AB");
            this.helper.addNamen("TIC 329888006", "PPM 771196");
        }
        this.helper.addNamen("HIP 70011", "TIC 347828508");
        this.helper.addNamen("HIP 70011", "WDS J14195-1343A");
        this.helper.addNamen("HIP 70111", "WDS J14208-4225C");
        if (this.helper.existsName("TIC 127315102")) {
            this.helper.deletePlanetensucheObject("HIP 70833");
            this.helper.addNamen("TIC 127315102", "HIP 70833");
            this.helper.addNamen("TIC 127315102", "HD 126838");
            this.helper.addNamen("TIC 127315102", "SAO 224958");
            this.helper.addNamen("TIC 127315102", "WDS J14291-4322A");
        }
        this.helper.deleteName("TIC 1056530200");
        this.helper.addNamen("HIP 71481", "TIC 16855");
        this.helper.addNamen("HIP 71488", "HD 128284A");
        this.helper.addNamen("HIP 71488", "WDS J14372-3732A");
        this.helper.addNamen("HIP 71488", "TIC 159194853");
        this.helper.addNamen("HIP 71621", "HD 128687");
        this.helper.renameName("Gaia DR2 6278932678525205248", "Gaia DR2 6278932678523813248");
        this.helper.addNamen("HIP 72191", "WDS J14460+4723A");
        this.helper.renameName("Gaia DR2 1590278028654853760", "Gaia DR2 1590278024362525568");
        this.helper.addNamen("HIP 72298", "WDS J14471+0058A");
        this.helper.addNamen("HIP 72298", "TIC 368805185");
        this.helper.addNamen("HIP 72411", "HD 130327");
        this.helper.addNamen("HIP 72411", "WDS J14484-3124AB");
        if (this.helper.existsName("TIC 293708935")) {
            this.helper.deletePlanetensucheObject("HIP 72490");
            this.helper.addNamen("TIC 293708935", "HIP 72490");
            this.helper.addNamen("HIP 72490", "HD 130207");
        }
        this.helper.addNamen("HIP 72490", "CD-59 5407");
        this.helper.addNamen("HIP 72490", "SAO 242028");
        if (this.helper.existsName("TIC 295354126")) {
            this.helper.deletePlanetensucheObject("HIP 72777");
            this.helper.addNamen("TIC 295354126", "HIP 72777");
            this.helper.addNamen("TIC 295354126", "HD 130737");
        }
        this.helper.addNamen("HIP 72777", "SAO 252929");
        this.helper.renameName("Gaia DR2 1186325496788069632", "Gaia DR2 1186325492493205376");
        this.helper.deleteName("TIC 284680749");
        this.helper.deleteName("Gaia DR2 1585765117538284800");
        this.helper.addNamen("WDS J14584+4403A", "Gaia DR2 1585765117538284800");
        this.helper.addNamen("WDS J14584+4403B", "Gaia DR2 1585765117538284928");
        this.helper.addNamen("WDS J14584+4403A", "TIC 284680749");
        this.helper.addNamen("WDS J14584+4403B", "TIC 284680750");
        this.helper.addNamen("WDS J14584+4403B", "2MASS J14582117+4402358");
        this.helper.deleteName("HIP 73261 A");
        this.helper.deleteName("HIP 73261");
        this.helper.addNamen("WDS J14584+4403A", "HIP 73261");
        this.helper.addNamen("HIP 73261", "GC 20166");
        if (this.helper.existsName("TIC 20182165")) {
            this.helper.deletePlanetensucheObject("HIP 73765");
            this.helper.addNamen("TIC 20182165", "HIP 73765");
            this.helper.addNamen("TIC 20182165", "HD 133725");
        }
        this.helper.addNamen("HIP 73765", "SAO 64491");
        this.helper.renameName("Gaia DR2 5903642967392021504", "Gaia DR2 5903642971705779712");
        this.helper.addNamen("HIP 73849", "HD 133708");
        this.helper.addNamen("HIP 73849", "WDS J15056+1138AB");
        this.helper.renameName("Gaia DR2 1180619439461685376", "Gaia DR2 1180619443756986112");
        this.helper.addNamen("HIP 73892", "WDS J15061-6523AB");
        this.helper.addNamen("HIP 74245", "IM Librae");
        this.helper.addNamen("HIP 74245", "WDS J15104-2827A");
        this.helper.addNamen("HIP 74245", "TIC 61221462");
        this.helper.addNamen("HIP 74345", "WDS J15116+1007A");
        if (this.helper.existsName("TIC 357416482")) {
            this.helper.deletePlanetensucheObject("HIP 74685");
            this.helper.addNamen("TIC 357416482", "HIP 74685");
            this.helper.addNamen("TIC 357416482", "HD 135723");
        }
        this.helper.addNamen("HIP 74919", "WDS J15186-4612AB");
        this.helper.addNamen("HIP 74919", "HD 135768");
        this.helper.renameName("Gaia DR2 5999934970231479936", "Gaia DR2 5999934970251895680");
        this.helper.addNamen("HIP 74961", "Nikawiy");
        this.helper.addNamen("HIP 74961", "ASCC 412979");
        this.helper.addNamen("HIP 74984", "WDS J15194-3642AB");
        this.helper.addNamen("HIP 75454", "HD 137094");
        this.helper.addNamen("HIP 75454", "WDS J15249-2322AB");
        this.helper.renameName("Gaia DR2 6251218697677174656", "Gaia DR2 6251218693378178304");
        this.helper.addNamen("HIP 76536", "TIC 16962647");
        this.helper.addNamen("HIP 76536", "WDS J15379+3006A");
        this.helper.addNamen("HIP 76690", "HD 139519");
        this.helper.addNamen("HIP 76690", "WDS J15396-2739AB");
        this.helper.addNamen("HIP 76862", "HD 139899");
        this.helper.addNamen("HIP 76862", "WDS J15417-3151AB");
        this.helper.addNamen("HIP 77002", "TIC 159345460");
        this.helper.addNamen("HIP 77002", "TYC 4566-614-1");
        this.helper.addNamen("HIP 77002", "WDS J15434+8119A");
        this.helper.addNamen("HIP 77051", "HD 140242");
        this.helper.addNamen("HIP 77051", "CD-38 10617");
        this.helper.addNamen("HIP 77051", "WDS J15440-3906AB");
        this.helper.addNamen("HIP 77135", "WDS J15450-3412A");
        this.helper.addNamen("HIP 77135", "TIC 99039745");
        this.helper.addNamen("HIP 77135", "TYC 7335-156-1");
        this.helper.renameName("Gaia DR2 6233447046421213056", "Gaia DR2 6233447050718360960");
        if (this.helper.existsName("TIC 426077080")) {
            this.helper.deletePlanetensucheObject("HIP 77717");
            this.helper.addNamen("TIC 426077080", "HIP 77717");
            this.helper.addNamen("TIC 426077080", "HD 140589");
        }
        this.helper.addNamen("HIP 77744", "HD 141959");
        this.helper.addNamen("HIP 77744", "WDS J15524-1714A");
        this.helper.renameName("Gaia DR2 6260730916366526720", "Gaia DR2 6260730916366526848");
        this.helper.renameName("Gaia DR2 5987792857206654464", "Gaia DR2 5987792852877523072");
        this.helper.addNamen("HIP 77837", "HD 142017");
        this.helper.addNamen("HIP 77837", "WDS J15536-3759AB");
        this.helper.renameName("Gaia DR2 6008645163919882880", "Gaia DR2 6008645163927339776");
        this.helper.addNamen("HIP 77921", "WDS J15548-6554AB");
        this.helper.addNamen("HIP 77994", "WDS J15557-5439AB");
        this.helper.addNamen("HIP 78401", "WDS J16003-2237AB");
        this.helper.deleteName("CD-22 4068");
        this.helper.addNamen("HIP 78401", "Dschubba");
        this.helper.renameName("TIC 1259690584", "TIC 9676357");
        if (this.helper.existsName("TIC 17416749")) {
            this.helper.deletePlanetensucheObject("HIP 79105");
            this.helper.addNamen("TIC 17416749", "HIP 79105");
            this.helper.addNamen("TIC 17416749", "HIP 79105");
        }
        this.helper.addNamen("HIP 79333", "WDS J16115+1507A");
        this.helper.deleteName("HIP 79607");
        this.helper.deleteName("Sigma Coronae Borealis");
        this.helper.deleteName("GJ 9550");
        this.helper.addNamen("GJ 615.2 A", "TIC 17542164");
        this.helper.addNamen("GJ 615.2 B", "TIC 17542166");
        this.helper.addNamen("ADS 9979 D", "TIC 17542161");
        this.helper.renameName("Gaia DR2 1200237583054036864", "Gaia DR2 1200237583054036736");
        this.helper.addNamen("HIP 80002", "WDS J16199-7127A");
        this.helper.addNamen("HIP 80616", "TIC 72198299");
        this.helper.addNamen("HIP 80616", "WDS J16276-0334A");
        this.helper.deleteName("HIP 80925");
        this.helper.addNamen("HIP 80925 A", "TIC 29646757");
        this.helper.addNamen("HIP 80925 A", "WDS J16315-3901A");
        this.helper.addNamen("HIP 81554", "WDS J16394-7010A");
        this.helper.addNamen("HIP 81554", "HD 149250A");
        this.helper.addNamen("HIP 81606", "WDS J16399-4747A");
        this.helper.addNamen("HIP 81933", "WDS J16442+2331A");
        this.helper.addNamen("HIP 81955", "WDS J16445-5054A");
        if (this.helper.existsName("TIC 364107753")) {
            this.helper.deletePlanetensucheObject("HIP 82032");
            this.helper.addNamen("TIC 364107753", "HIP 82032");
            this.helper.addNamen("TIC 364107753", "HD 150139");
        }
        this.helper.addNamen("HIP 82032", "WDS J16454-7150A");
        this.helper.addNamen("HIP 82627", "WDS J16535-2310AB");
        this.helper.addNamen("HIP 82627", "CD-22 11694");
        this.helper.renameName("Gaia DR2 4125540392495504128", "Gaia DR2 4125540388185452928");
        this.helper.deleteName("GJ 643 C");
        this.helper.deleteName("HIP 83101 A");
        this.helper.addNamen("HIP 83101", "GJ 646");
        this.helper.addNamen("HIP 83101", "WDS J16589-3934A");
        this.helper.addNamen("HIP 83101", "TIC 343110556");
        this.helper.addNamen("HIP 83101", "TYC 7872-336-1");
        if (this.helper.existsName("TIC 224600500")) {
            this.helper.deletePlanetensucheObject("HIP 83168");
            this.helper.addNamen("TIC 224600500", "HIP 83168");
            this.helper.addNamen("TIC 224600500", "HD 154081");
        }
        this.helper.addNamen("HIP 83168", "GC 22953");
        this.helper.addNamen("HIP 83350", "WDS J17020-5011A");
        if (this.helper.existsName("TIC 459978312")) {
            this.helper.deletePlanetensucheObject("HIP 83359");
            this.helper.addNamen("TIC 459978312", "HIP 83359");
            this.helper.addNamen("TIC 459978312", "BD+64 1170");
            this.helper.addNamen("TIC 459978312", "HD 154633");
            this.helper.addNamen("TIC 459978312", "HR 6360");
            this.helper.addNamen("TIC 459978312", "SAO 17324");
        }
        this.helper.renameName("Gaia DR2 5978413061014964608", "Gaia DR2 5978413061014964352");
        this.helper.addNamen("HIP 83409", "WDS J17029-3348AB");
        this.helper.addNamen("HIP 83429", "WDS J17031-5833A");
        this.helper.addNamen("HIP 83716", "WDS J17066+0039A");
        this.helper.addNamen("HIP 83964", "WDS J17098-5240A");
        this.helper.renameName("Gaia DR2 5924159274560176512", "Gaia DR2 5924159274577801856");
        if (this.helper.existsName("TIC 356235833")) {
            this.helper.deletePlanetensucheObject("HIP 84840");
            this.helper.addNamen("TIC 356235833", "HIP 84840");
            this.helper.addNamen("TIC 356235833", "BD+20 3449");
        }
        this.helper.addNamen("HIP 84840", "NLTT 44628");
        this.helper.addNamen("HIP 84840", "ASCC 789036");
        if (this.helper.existsName("TIC 198457103")) {
            this.helper.deletePlanetensucheObject("HIP 85444");
            this.helper.addNamen("TIC 198457103", "HIP 85444");
            this.helper.addNamen("TIC 198457103", "HD 158788");
        }
        if (this.helper.existsName("TIC 389070884")) {
            this.helper.deletePlanetensucheObject("HIP 85583");
            this.helper.addNamen("TIC 389070884", "HIP 85583");
            this.helper.addNamen("TIC 389070884", "HD 158142");
        }
        this.helper.addNamen("HIP 85667", "NLTT 44914");
        this.helper.addNamen("HIP 86278", "HD 159843");
        this.helper.addNamen("HIP 86278", "WDS J17378-2323A");
        this.helper.renameName("HIP 86278", "HIP 86278 A");
        this.helper.addNamen("HIP 86615", "WDS J17420-4401A");
        this.helper.renameName("Gaia DR2 5955732468218114432", "Gaia DR2 5955732472535713408");
        this.helper.addNamen("HIP 86921", "WDS J17456-5047A");
        this.helper.addNamen("HIP 87535", "WDS J17530-5057AB");
        this.helper.addNamen("HIP 87800", "TIC 275266594");
        this.helper.addNamen("HIP 87800", "WDS J17561+2130A");
        this.helper.addNamen("HIP 87800", "TYC 1565-4314-1");
        this.helper.renameName("HD 163609", "HD 163609 A");
        this.helper.addNamen("HIP 87823", "WDS J17564+1820AB");
        this.helper.renameName("Gaia DR2 4503405877106880768", "Gaia DR2 4503405877106880896");
        if (this.helper.existsName("TIC 233059608")) {
            this.helper.deletePlanetensucheObject("HIP 88071");
            this.helper.addNamen("TIC 233059608", "HIP 88071");
            this.helper.addNamen("TIC 233059608", "HD 164984");
        }
        this.helper.addNamen("HIP 88071", "WDS J17592+6409A");
        this.helper.addNamen("Zkh 271", "Gaia DR2 4468557611977678336");
        this.helper.deleteName("2MASS J18052735+0229585 A");
        this.helper.renameName("ADS 11046 AB", "ADS 11046 A");
        this.helper.deleteName("BD+02 3482");
        this.helper.renameName("CCDM J18055+0230AB", "CCDM J18055+0230A");
        this.helper.deleteName("HIP 88601 A");
        this.helper.deleteName("HD 165341");
        this.helper.deleteName("IDS 18004+0232");
        this.helper.renameName("STF 2272AB", "STF 2272A");
        this.helper.renameName("WDS J18054+0232AB", "WDS J18054+0232A");
        this.helper.addNamen("HIP 88713", "WDS J18066+5001A");
        this.helper.addNamen("HIP 88713", "HD 234561");
        this.helper.addNamen("HIP 88713", "TIC 262970987");
        this.helper.renameName("Gaia DR2 4499054727339303552", "Gaia DR2 4499054731639035520");
        this.helper.addNamen("HIP 89044", "WDS J18104-5019AB");
        this.helper.addNamen("HIP 89044", "CD-50 11754");
        this.helper.renameName("Gaia DR2 6703014725675220096", "Gaia DR2 6703014725683177728");
        this.helper.addNamen("HIP 90153", "WDS J18238-1930AB");
        this.helper.addNamen("HIP 90284", "WDS J18253+4846AB");
        this.helper.renameName("Gaia DR2 2123486226905640960", "Gaia DR2 2123486226903432448");
        this.helper.renameName("Gaia DR2 4052054876562140544", "Gaia DR2 4052054872135709824");
        this.helper.addNamen("HIP 91352", "WDS J18379-0023A");
        this.helper.addNamen("HIP 91399", "TIC 157689809");
        this.helper.addNamen("HIP 91399", "WDS J18384+3603A");
        this.helper.addNamen("HIP 91399", "BD+35 3319A");
        this.helper.addNamen("HIP 91436", "WDS J18389+5221A");
        this.helper.renameName("Gaia DR2 2145517622427994624", "Gaia DR2 2145517618131590784");
        this.helper.addNamen("HIP 91436", "HD 172712");
        this.helper.createPlanetensucheObjekt(List.of("HD 172713", "BD+52 2258B", "GCRV 11118", "TYC 3539-897-2", "WDS J18389+5221B", "Gaia DR2 2145517622427994624"), "Doppelstern physisch");
        this.helper.addNamen("HIP 91928", "TIC 181798899");
        this.helper.addNamen("HIP 91928", "HD 172779");
        this.helper.addNamen("HIP 91928", "WDS J18444-4657A");
        this.helper.addNamen("HIP 92062", "WDS J18459-1030A");
        this.helper.addNamen("HIP 92062", "TYC 5696-925-1");
        this.helper.addNamen("HIP 92475", "WDS J18508+1059A");
        this.helper.renameName("Gaia DR2 4504166361225172736", "Gaia DR2 4504166361225172864");
        this.helper.addNamen("HIP 93069", "WDS J18575-5600A");
        this.helper.addNamen("HIP 93069", "GJ 737 A");
        this.helper.addNamen("HIP 93069", "LTT 7509");
        this.helper.addNamen("HIP 93072", "WDS J18575-1903A");
        this.helper.addNamen("HIP 93490", "HD 178303");
        this.helper.addNamen("HIP 93490", "WDS J19024+6927AB");
        this.helper.addNamen("HIP 93490", "GC 26247");
        this.helper.addNamen("HIP 93876", "WDS J19071+7204A");
        this.helper.renameName("Gaia DR2 2264491480701172992", "Gaia DR2 2264491480699717632");
        this.helper.addNamen("HIP 93970", "HD 177770");
        this.helper.addNamen("HIP 93970", "WDS J19080-4316A");
        this.helper.addNamen("HIP 94252", "TIC 121394563");
        this.helper.addNamen("HIP 94252", "WDS J19111+3847A");
        this.helper.addNamen("HIP 94252", "TYC 3121-729-1");
        this.helper.addNamen("HIP 94252", "LTT 15617");
        this.helper.addNamen("HIP 94252", "NLTT 47507");
        this.helper.addNamen("HIP 94252", "2MASS J19110793+3846485");
        this.helper.renameName("HIP 94336 A", "HIP 94336 B");
        this.helper.renameName("HIP 94336", "HIP 94336 A");
        this.helper.deleteName("HR 7294");
        this.helper.deleteName("HR 7293");
        this.helper.addNamen("HIP 94336 A", "HR 7294");
        this.helper.addNamen("HIP 94336 B", "HR 7293");
        this.helper.deleteName("HD 179958");
        this.helper.deleteName("HD 179957");
        this.helper.addNamen("HIP 94336 A", "HD 179958");
        this.helper.addNamen("HIP 94336 B", "HD 179957");
        this.helper.deleteName("SAO 48193");
        this.helper.deleteName("SAO 48192");
        this.helper.addNamen("HIP 94336 A", "SAO 48193");
        this.helper.addNamen("HIP 94336 B", "SAO 48192");
        this.helper.deleteName("Gaia DR2 2132788541955849984");
        this.helper.addNamen("HIP 94336 A", "Gaia DR2 2132788541955849984");
        this.helper.addNamen("HIP 94336 B", "Gaia DR2 2132788541955849216");
        this.helper.addNamen("HIP 94336 A", "TIC 298896144");
        this.helper.addNamen("HIP 94336 B", "TIC 298896136");
        this.helper.addNamen("HIP 94336 A", "WDS J19121+4951A");
        this.helper.addNamen("HIP 94336 B", "WDS J19121+4951B");
        this.helper.deleteName("BD+49 2959");
        this.helper.deleteName("2MASS J19120500+4951207");
        this.helper.addNamen("HIP 94336 A", "GJ 9648 A");
        this.helper.addNamen("HIP 94336 B", "GJ 9648 B");
        this.helper.addNamen("HIP 94336 A", "LHS 3441");
        this.helper.addNamen("HIP 94336 B", "LHS 3440");
        this.helper.deleteName("GCRV 26175");
        this.helper.deleteName("JP11 5193");
        this.helper.addNamen("HIP 94367", "HD 179058");
        this.helper.addNamen("HIP 94367", "WDS J19124-3304A");
        this.helper.renameName("Gaia DR2 6756093786945560576", "Gaia DR2 6756093782648704896");
        this.helper.addNamen("HIP 94368", "TIC 421911620");
        this.helper.addNamen("HIP 94368", "TYC 8764-2607-1");
        this.helper.addNamen("HIP 94368", "GJ 747.4");
        this.helper.addNamen("HIP 94454", "WDS J19134-1427A");
        this.helper.addNamen("HIP 94892", "HD 180310");
        this.helper.addNamen("HIP 94892", "WDS J19186-5037A");
        this.helper.renameName("Gaia DR2 6657358604846190464", "Gaia DR2 6657358604843400448");
        this.helper.addNamen("HIP 95079", "WDS J19206+0256A");
        if (this.helper.existsName("TIC 112395568")) {
            this.helper.deletePlanetensucheObject("HIP 95348");
            this.helper.addNamen("TIC 112395568", "HIP 95348");
            this.helper.addNamen("TIC 112395568", "HD 181974");
            this.helper.addNamen("TIC 112395568", "Gaia DR2 6745377431229335168");
        }
        this.helper.addNamen("HIP 95348", "WDS J19239-3321A");
        if (this.helper.existsName("TIC 412014494")) {
            this.helper.deletePlanetensucheObject("HIP 95502");
            this.helper.addNamen("TIC 412014494", "HIP 95502");
            this.helper.addNamen("TIC 412014494", "HD 181793");
            this.helper.addNamen("TIC 412014494", "Gaia DR2 6445176465824182272");
        }
        this.helper.addNamen("HIP 95502", "SAO 254567");
        if (this.helper.existsName("TIC 110428269")) {
            this.helper.deletePlanetensucheObject("HIP 95526");
            this.helper.addNamen("TIC 110428269", "HIP 95526");
            this.helper.addNamen("TIC 110428269", "HD 338313");
            this.helper.addNamen("TIC 110428269", "Gaia DR2 2023144005524070528");
        }
        this.helper.addNamen("HIP 95526", "SAO 87197");
        this.helper.addNamen("HIP 95625", "HD 184292");
        this.helper.addNamen("HIP 95625", "WDS J19270+7322A");
        this.helper.addNamen("HIP 95646", "WDS J19273+2040A");
        if (this.helper.existsName("TIC 269450900")) {
            this.helper.deletePlanetensucheObject("HIP 95774");
            this.helper.addNamen("TIC 269450900", "HIP 95774");
            this.helper.addNamen("TIC 269450900", "HD 182985");
            this.helper.addNamen("TIC 269450900", "Gaia DR2 6742628068041470208");
        }
        this.helper.addNamen("HIP 95774", "SAO 211295");
        this.helper.addNamen("HIP 96354", "WDS J19355-6906A");
        this.helper.addNamen("HIP 96354", "TYC 9305-1474-1");
        this.helper.addNamen("HIP 96354", "2MASS J19352804-6905413");
        this.helper.addNamen("HIP 96354", "TIC 409883977");
        if (this.helper.existsName("TIC 305943739")) {
            this.helper.deletePlanetensucheObject("HIP 96902");
            this.helper.addNamen("TIC 305943739", "HIP 96902");
            this.helper.addNamen("TIC 305943739", "HD 344779");
            this.helper.addNamen("TIC 305943739", "Gaia DR2 2020100213712426112");
        }
        this.helper.addNamen("HIP 96902", "SAO 87582");
        this.helper.addNamen("HIP 96902", "NGC 6823 206");
        this.helper.addNamen("HIP 97165", "Fawaris");
        this.helper.deleteName("HIP 97292");
        this.helper.addNamen("HIP 97292 A", "WDS J19464+3201A");
        this.helper.addNamen("HIP 97292 A", "LHS 3482");
        this.helper.addNamen("HIP 97292 A", "GJ 767 A");
        this.helper.createPlanetensucheObjekt(List.of("HIP 97292 B", "WDS J19464+3201B", "GJ 767 B", "LHS 3483"), "Doppelstern physisch");
        this.helper.addNamen("HIP 97772", "WDS J19521+2923A");
        this.helper.addNamen("HIP 97772", "NGC 6834 72");
        this.helper.addNamen("HIP 98216", "HD 189068");
        this.helper.addNamen("HIP 98216", "WDS J19575+2018A");
        this.helper.addNamen("HIP 98272", "WDS J19580+0456A");
        this.helper.renameName("Gaia DR2 4248447753598217216", "Gaia DR2 4248447753608391936");
        if (this.helper.existsName("TIC 128790976")) {
            this.helper.deletePlanetensucheObject("HIP 98516");
            this.helper.addNamen("TIC 128790976", "HIP 98516");
            this.helper.addNamen("TIC 128790976", "HD 189247");
            this.helper.addNamen("TIC 128790976", "Gaia DR2 6685705320278556544");
        }
        this.helper.addNamen("HIP 98516", "SAO 229985");
        this.helper.addNamen("HIP 98516", "GC 27698");
        if (this.helper.existsName("TIC 117789567")) {
            this.helper.deletePlanetensucheObject("HIP 98726");
            this.helper.addNamen("TIC 117789567", "HIP 98726");
            this.helper.addNamen("TIC 117789567", "HD 190257");
            this.helper.addNamen("TIC 117789567", "Gaia DR2 1835201042675810688");
        }
        this.helper.addNamen("HIP 98726", "SAO 88121");
        this.helper.addNamen("HIP 98726", "BD+26 3769");
        this.helper.renameName("HIP 98864", "HIP 98864 A");
        this.helper.addNamen("HIP 98864 A", "WDS J20046-3513A");
        this.helper.addNamen("HIP 98864 A", "SAO 211785");
        this.helper.addNamen("HIP 98864 A", "TIC 439417807");
        this.helper.addNamen("HIP 99211", "WDS J20085+4622AB");
        if (this.helper.existsName("TIC 409934330")) {
            this.helper.deletePlanetensucheObject("HIP 99227");
            this.helper.addNamen("TIC 409934330", "HIP 99227");
            this.helper.addNamen("TIC 409934330", "HD 189995");
            this.helper.addNamen("TIC 409934330", "Gaia DR2 6422184406377527936");
        }
        this.helper.addNamen("HIP 99227", "SAO 257778");
        this.helper.addNamen("HIP 99227", "WDS J20086-7133AB");
        this.helper.addNamen("HIP 99324", "HD 191613");
        this.helper.addNamen("HIP 99324", "WDS J20096+3325A");
        this.helper.addNamen("HIP 99324", "BD+32 3724");
        this.helper.addNamen("HIP 99324", "TIC 378399855");
        this.helper.addNamen("HIP 99324", "2MASS J20093719+3324392");
        this.helper.renameName("HIP 99324", "HIP 99324 A");
        if (this.helper.existsName("TIC 312083267")) {
            this.helper.deletePlanetensucheObject("HIP 99628");
            this.helper.addNamen("TIC 312083267", "HIP 99628");
            this.helper.addNamen("TIC 312083267", "HD 192382");
            this.helper.addNamen("TIC 312083267", "Gaia DR2 2060689372656830848");
        }
        this.helper.addNamen("HIP 99628", "SAO 69625");
        this.helper.addNamen("HIP 99628", "BD+36 3937");
        this.helper.addNamen("HIP 99692", "HD 191308");
        this.helper.addNamen("HIP 99692", "WDS J20138-6728A");
        this.helper.addNamen("HIP 99692", "TIC 374353519");
        this.helper.renameName("HIP 99692", "HIP 99692 A");
        this.helper.addNamen("HIP 99935", "WDS J20166-4554AB");
        this.helper.renameName("Gaia DR2 6672725585512111744", "Gaia DR2 6672725581215340160");
        this.helper.addNamen("HIP 100127", "WDS J20187+3315A");
        this.helper.addNamen("HIP 100298", "WDS J20205-4713A");
        this.helper.addNamen("HIP 100397", "TIC 402696039");
        this.helper.addNamen("HIP 100397", "WDS J20216+1930AB");
        this.helper.addNamen("HIP 101456", "HD 196092");
        this.helper.addNamen("HIP 101456", "WDS J20337+3835A");
        this.helper.deleteName("HD 196982");
        this.helper.deleteName("CD-32 16135");
        this.helper.deleteName("AT Microscopii");
        this.helper.addNamen("HIP 102357", "GJ 804");
        this.helper.addNamen("HIP 102357", "Ross 257");
        this.helper.addNamen("HIP 102357", "WDS J20444+1945AB");
        this.helper.addNamen("HIP 102396", "HD 197322");
        this.helper.addNamen("HIP 102396", "WDS J20450-5029A");
        this.helper.renameName("Gaia DR2 6480764633558584704", "Gaia DR2 6480764736635589504");
        this.helper.addNamen("HIP 102398", "WDS J20450+1244A");
        if (this.helper.existsName("TIC 239372503")) {
            this.helper.deletePlanetensucheObject("HIP 102460");
            this.helper.addNamen("TIC 239372503", "HIP 102460");
            this.helper.addNamen("TIC 239372503", "BD+42 3854");
            this.helper.addNamen("TIC 239372503", "Gaia DR2 2066929852738261760");
        }
        this.helper.addNamen("HIP 102460", "SAO 50034");
        this.helper.addNamen("HIP 102604", "CD-46 13700");
        this.helper.addNamen("HIP 102604", "HD 197789");
        this.helper.addNamen("HIP 102604", "WDS J20476-4534A");
        this.helper.renameName("Gaia DR2 6482901912362564096", "Gaia DR2 6482901908066824192");
        this.helper.addNamen("HIP 103350", "WDS J20563-3216A");
        this.helper.addNamen("HIP 103454", "BD+60 2181");
        this.helper.addNamen("HIP 103454", "WDS J20576+6121A");
        this.helper.addNamen("HIP 103454", "TIC 305399324");
        this.helper.addNamen("HIP 103454", "TYC 4247-450-1");
        this.helper.addNamen("HIP 103454", "2MASS J20573979+6121367");
        this.helper.renameName("CCDM J21031+0132AB", "CCDM J21031+0132A");
        this.helper.renameName("Gaia DR2 1729643738815644288", "Gaia DR2 1729643738814477056");
        this.helper.addNamen("HIP 104250", "WDS J21073+4440AB");
        this.helper.addNamen("HIP 104390", "WDS J21089+0013A");
        this.helper.addNamen("HIP 104390", "TIC 387374068");
        this.helper.addNamen("HIP 104416", "WDS J21091+1906A");
        this.helper.addNamen("HIP 104416", "BD+18 4714A");
        this.helper.renameName("Gaia DR2 1789206207836245504", "Gaia DR2 1789206207838189696");
        this.helper.addNamen("HIP 104570", "BD+08 4625");
        this.helper.addNamen("HIP 104570", "HD 201686");
        this.helper.addNamen("HIP 104570", "WDS J21110+0933A");
        this.helper.addNamen("HIP 104570", "TIC 354663315");
        this.helper.addNamen("HIP 104604", "HD 201427");
        this.helper.addNamen("HIP 104604", "WDS J21114-5220A");
        this.helper.addNamen("HIP 104662", "WDS J21120-5737A");
        this.helper.renameName("Gaia DR2 6456644784417888640", "Gaia DR2 6456644784416434432");
        if (this.helper.existsName("TIC 275501623")) {
            this.helper.deletePlanetensucheObject("HIP 105363");
            this.helper.addNamen("TIC 275501623", "HIP 105363");
            this.helper.addNamen("TIC 275501623", "HD 203550");
            this.helper.addNamen("TIC 275501623", "Gaia DR2 2192733400508791552");
        }
        this.helper.addNamen("HIP 105363", "WDS J21205+6107A");
        this.helper.addNamen("HIP 105692", "WDS J21244-5435A");
        this.helper.addNamen("HIP 105692", "TIC 355579354");
        this.helper.addNamen("HIP 105692", "2MASS J21242413-5434403");
        this.helper.addNamen("HIP 106053", "WDS J21289+1105A");
        if (this.helper.existsName("TIC 275111900")) {
            this.helper.deletePlanetensucheObject("HIP 106386");
            this.helper.addNamen("TIC 275111900", "HIP 106386");
            this.helper.addNamen("TIC 275111900", "HD 205223");
            this.helper.addNamen("TIC 275111900", "Gaia DR2 1965844090875429632");
        }
        this.helper.addNamen("HIP 106386", "WDS J21328+3904A");
        this.helper.addNamen("HIP 106387", "HD 204824");
        this.helper.addNamen("HIP 106387", "WDS J21328-5103A");
        this.helper.renameName("Gaia DR2 6465826943458979712", "Gaia DR2 6465826939163834368");
        this.helper.addNamen("HIP 107588", "HD 207171");
        this.helper.addNamen("HIP 107588", "WDS J21474-1307AB");
        this.helper.addNamen("HIP 107588", "TIC 155844260");
        if (this.helper.existsName("TIC 256886630")) {
            this.helper.deletePlanetensucheObject("HIP 108390");
            this.helper.addNamen("TIC 256886630", "HIP 108390");
            this.helper.addNamen("TIC 256886630", "HD 208762");
            this.helper.addNamen("TIC 256886630", "Gaia DR2 1959980910760446720");
        }
        this.helper.addNamen("HIP 108390", "SAO 51481");
        this.helper.addNamen("HIP 108651", "WDS J22007-5002A");
        this.helper.renameName("Gaia DR2 6558358337359492992", "Gaia DR2 6558358337360755200");
        this.helper.addNamen("HIP 109180", "WDS J22070+3605A");
        this.helper.addNamen("HIP 109183", "WDS J22071-5908A");
        this.helper.addNamen("HIP 109183", "LTT 8854");
        this.helper.addNamen("HIP 109183", "TIC 265591609");
        this.helper.addNamen("HIP 109183", "NLTT 52911");
        this.helper.createPlanetensucheObjekt(List.of("TIC 265591610", "WDS J22071-5908B", "NLTT 52912"), "Doppelstern physisch");
        this.helper.addNamen("HIP 109480", "Wolf 1003");
        this.helper.addNamen("HIP 109480", "WDS J22107+0755A");
        this.helper.addNamen("HIP 109480", "LTT 16488");
        this.helper.renameName("Gaia DR2 2722006206116795008", "Gaia DR2 2722006206116795136");
        this.helper.addNamen("HIP 109595", "HD 210571");
        this.helper.addNamen("HIP 109595", "WDS J22120-3818A");
        this.helper.addNamen("HIP 110276", "HD 211933");
        this.helper.addNamen("HIP 110276", "WDS J22202+2931A");
        this.helper.addNamen("HIP 110526", "GJ 856 A");
        this.helper.addNamen("HIP 110526", "WDS J22234+3228A");
        this.helper.addNamen("HIP 110526", "NLTT 53730");
        this.helper.addNamen("HIP 110605", "HD 212472");
        this.helper.addNamen("HIP 110605", "WDS J22245+0349A");
        this.helper.addNamen("HIP 110605", "TIC 265859308");
        this.helper.addNamen("HIP 110605", "2MASS J22242747+0349052");
        this.helper.renameName("HIP 110605", "HIP 110605 A");
        this.helper.addNamen("HIP 110893 A", "TIC 471012160");
        this.helper.addNamen("HD 239960B", "HIP 110893 B");
        this.helper.addNamen("HD 239960B", "TIC 414587194");
        this.helper.addNamen("HIP 111161", "WDS J22312+6528A");
        this.helper.addNamen("HIP 111161", "TIC 338076483");
        this.helper.addNamen("HIP 111330", "WDS J22333-6049A");
        this.helper.addNamen("HIP 111330", "TIC 394580082");
        this.helper.addNamen("HIP 111330", "CD-61 6711A");
        this.helper.addNamen("HIP 111460", "HD 214040");
        this.helper.addNamen("HIP 111460", "BD+40 4856");
        this.helper.addNamen("HIP 111460", "WDS J22349+4134A");
        this.helper.addNamen("HIP 111460", "TIC 128444384");
        this.helper.renameName("HIP 111460", "HIP 111460 A");
        if (this.helper.existsName("TIC 115771549")) {
            this.helper.deletePlanetensucheObject("HIP 111842");
            this.helper.addNamen("TIC 115771549", "HIP 111842");
            this.helper.addNamen("TIC 115771549", "HD 214667");
            this.helper.addNamen("TIC 115771549", "Gaia DR2 1903064893205691392");
        }
        this.helper.addNamen("HIP 111842", "WDS J22393+3353AB");
        this.helper.addNamen("HIP 112331", "TIC 444166967");
        this.helper.addNamen("HIP 112331", "WDS J22452-2306A");
        if (this.helper.existsName("TIC 66445643")) {
            this.helper.deletePlanetensucheObject("HIP 112363");
            this.helper.addNamen("TIC 66445643", "HIP 112363");
            this.helper.addNamen("TIC 66445643", "HD 215591");
            this.helper.addNamen("TIC 66445643", "Gaia DR2 1985325925092948096");
        }
        this.helper.addNamen("HIP 112363", "SAO 52338");
        this.helper.addNamen("HIP 112458", "HD 215560");
        this.helper.addNamen("HIP 112458", "WDS J22468-4819A");
        this.helper.addNamen("HIP 112458", "TIC 161268141");
        this.helper.renameName("HIP 112458", "HIP 112458 A");
        this.helper.addNamen("HIP 112602", "HD 215788");
        this.helper.addNamen("HIP 112602", "WDS J22484-4515A");
        this.helper.addNamen("HIP 113403", "WDS J22580+4954A");
        this.helper.addNamen("HIP 113450", "WDS J22586+6950A");
        if (this.helper.existsName("TIC 155001079")) {
            this.helper.deletePlanetensucheObject("HIP 113609");
            this.helper.addNamen("TIC 155001079", "HIP 113609");
            this.helper.addNamen("TIC 155001079", "BD+45 4114");
            this.helper.addNamen("TIC 155001079", "Gaia DR2 1936088042049360896");
        }
        this.helper.addNamen("HIP 113609", "SAO 52588");
        this.helper.addNamen("HIP 113654", "HD 217544");
        this.helper.addNamen("HIP 113654", "WDS J23010+2646A");
        this.helper.addNamen("HIP 113654", "TIC 436760421");
        this.helper.addNamen("HIP 113760", "WDS J23023-4258A");
        this.helper.addNamen("HIP 113760", "TIC 139197023");
        if (this.helper.existsName("TIC 160074939")) {
            this.helper.deletePlanetensucheObject("HIP 114003");
            this.helper.addNamen("TIC 160074939", "HIP 114003");
            this.helper.addNamen("TIC 160074939", "HD 218037");
            this.helper.addNamen("TIC 160074939", "Gaia DR2 6552981691139772160");
        }
        this.helper.addNamen("HIP 114003", "SAO 214298");
        this.helper.addNamen("HIP 114582", "HD 218924");
        this.helper.addNamen("HIP 114582", "WDS J23128-6148A");
        this.helper.addNamen("HIP 114584", "WDS J23128-2156A");
        this.helper.addNamen("HIP 114631", "HD 219111");
        this.helper.addNamen("HIP 114631", "WDS J23133+2205A");
        this.helper.addNamen("HIP 114631", "GC 32328");
        this.helper.addNamen("HIP 114801", "HD 219340");
        this.helper.addNamen("HIP 114801", "WDS J23153-3543A");
        this.helper.renameName("Gaia DR2 6551985877202592640", "Gaia DR2 6551985872908696448");
        this.helper.addNamen("HIP 115268", "HD 220076");
        this.helper.addNamen("HIP 115268", "WDS J23208+2158A");
        this.helper.addNamen("HIP 115268", "TIC 243106787");
        this.helper.renameName("HIP 115268", "HIP 115268 A");
        if (this.helper.existsName("TIC 175456679")) {
            this.helper.deletePlanetensucheObject("HIP 115358");
            this.helper.addNamen("TIC 175456679", "HIP 115358");
            this.helper.addNamen("TIC 175456679", "HD 220163");
            this.helper.addNamen("TIC 175456679", "Gaia DR2 6536790454707565696");
        }
        this.helper.addNamen("HIP 115358", "WDS J23220-4010AB");
        if (this.helper.existsName("TIC 270238522")) {
            this.helper.deletePlanetensucheObject("HIP 115710");
            this.helper.addNamen("TIC 270238522", "HIP 115710");
            this.helper.addNamen("TIC 270238522", "HD 220868");
            this.helper.addNamen("TIC 270238522", "Gaia DR2 2209081592227687680");
        }
        this.helper.addNamen("HIP 115710", "SAO 20630");
        this.helper.addNamen("HIP 115798", "WDS J23276+5536A");
        this.helper.addNamen("HIP 115800", "WDS J23276+1638C");
        this.helper.addNamen("HIP 115800", "TIC 435236481");
        this.helper.addNamen("HIP 115800", "2MASS J23273646+1637439");
        this.helper.addNamen("HIP 115800", "TYC 1713-352-1");
        this.helper.renameName("HIP 115800", "HIP 115800 C");
        this.helper.deleteName("Gaia DR2 2824770686019003904");
        this.helper.addNamen("HIP 116132 A", "Gaia DR2 2824770686019003904");
        this.helper.addNamen("HIP 116153", "HD 221460");
        this.helper.addNamen("HIP 116153", "GC 32728");
        this.helper.addNamen("HIP 116153", "TIC 176551075");
        this.helper.addNamen("HIP 116153", "WDS J23320+4349A");
        this.helper.addNamen("HIP 116475", "HD 221882");
        this.helper.addNamen("HIP 116475", "NSV 26112");
        this.helper.addNamen("HIP 116475", "WDS J23361-3237A");
        this.helper.addNamen("HIP 116475", "CM Sculptoris");
        this.helper.renameName("Gaia DR2 2325190737372641408", "Gaia DR2 2325190741665892608");
        if (this.helper.existsName("TIC 176860064")) {
            this.helper.deletePlanetensucheObject("HIP 116726");
            this.helper.addNamen("TIC 176860064", "HIP 116726");
            this.helper.addNamen("TIC 176860064", "HD 222326");
            this.helper.addNamen("TIC 176860064", "Gaia DR2 1938853485592250752");
        }
        this.helper.addNamen("HIP 116726", "SAO 53242");
        this.helper.addNamen("HIP 116726", "WDS J23393+4543AB");
        this.helper.addNamen("HIP 117430", "WDS J23487+6453A");
        this.helper.addNamen("HIP 117504", "WDS J23497-4805A");
        this.helper.addNamen("HIP 117673", "WDS J23519+3753A");
        this.helper.addNamen("HIP 117673", "GCRV 14931");
        this.helper.addNamen("HIP 117673", "TIC 455767324");
        this.helper.renameName("HIP 117673", "HIP 117673 A");
        this.helper.addNamen("HIP 118031", "CD-43 15549");
        this.helper.addNamen("HIP 118031", "HD 224268");
        this.helper.addNamen("HIP 118031", "WDS J23565-4317A");
        if (this.helper.existsName("TIC 144440290")) {
            this.helper.deletePlanetensucheObject("HIP 118045");
            this.helper.addNamen("TIC 144440290", "HIP 118045");
            this.helper.addNamen("TIC 144440290", "HD 224286");
            this.helper.addNamen("TIC 144440290", "Gaia DR2 1938853485592250752");
        }
        this.helper.addNamen("HIP 118045", "SAO 231858");
        this.helper.addNamen("HIP 118045", "CD-45 15182");
        this.helper.addNamen("HIP 118310", "WDS J23598+0640A");
        this.helper.addNamen("HIP 118310", "TIC 401396607");
        this.helper.createPlanetensucheObjekt(List.of("HIP 31157", "BD+52 1088", "TIC 253017848", "WDS J06323+5225A", "Gaia DR2 992785646135669504", "GJ 235 A"), "Doppelstern physisch");
        this.helper.createPlanetensucheObjekt(List.of("HIP 115269", "HD 220002", "CD-50 13947", "TIC 355425086", "WDS J23208-5018C", "Gaia DR2 6502030631547502720"), "Doppelstern physisch");
    }

    @Override
    public int updateToVersion() {
        return 101;
    }
}

