/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbankkern.impl.migration;

import de.planetensuche.datamodel.api.StarObjectType;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.impl.migration.DatabaseUpdater;
import de.planetensuche.datenbankkern.impl.migration.MigrationHelper;
import de.planetensuche.datenbankkern.querydsl5.Daten;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.sql.SQLException;
import java.util.List;

public final class Version102Migrator
implements DatabaseUpdater {
    private static final ILogging LOGGER = LoggingFactory.getLoggerForClass(Version102Migrator.class);
    private final IDatenbankverbinder datenbankverbinder;
    private final MigrationHelper helper;

    public Version102Migrator(IDatenbankverbinder iDatenbankverbinder) {
        this.datenbankverbinder = iDatenbankverbinder;
        this.helper = new MigrationHelper(iDatenbankverbinder);
    }

    @Override
    public void update() throws SQLException {
        LOGGER.debug("starting DB migration to Version " + this.updateToVersion());
        this.helper.addNamen("HIP 25793", "MWC 758");
        if (this.helper.existsName("HIP 25793 c")) {
            this.helper.addNamen("HIP 25793 c", "MWC 758 c");
        } else {
            Daten daten = this.helper.readPlanetensucheObject("HIP 25793");
            if (daten != null) {
                this.helper.createPlanetensucheObjekt(List.of("HIP 25793 c", "MWC 758 c"), "Planet");
                Daten daten2 = this.helper.readPlanetensucheObject("HIP 25793 c");
                daten2.setZugehoerigkeit(daten.getId());
                this.helper.updatePlanetensucheObjekt(daten2);
            }
        }
        this.helper.renameName("TOI-3540", "TOI-3540 A");
        this.helper.addNamen("TIC 17865622", "2MASS J21553871+2810460");
        this.helper.deletePlanetensucheObject("TIC 157698565.01");
        this.helper.addNamen("TOI-2589 b", "TIC 157698565.01");
        this.helper.addNamen("TOI-2589 b", "TOI-2589.01");
        this.helper.addNamen("HAT-P-29", "Muspelheim");
        this.helper.addNamen("HAT-P-29", "2MASS J02123147+5146435");
        this.helper.addNamen("HAT-P-29 b", "Surt");
        this.helper.deletePlanetensucheObject("TIC 250707118.01");
        this.helper.addNamen("HAT-P-29 b", "TIC 250707118.01");
        this.helper.addNamen("HAT-P-29 b", "TOI-6028.01");
        this.helper.deletePlanetensucheObject("TIC 27491137.02");
        this.helper.addNamen("TOI-2076 d", "TIC 27491137.02");
        this.helper.addNamen("TOI-2076 d", "TOI-2076.02");
        this.helper.addNamen("WASP-12", "Bergfors-6");
        this.helper.addNamen("WASP-12", "TYC 1891-1178-1");
        this.helper.setStarObjectType("WASP-12", StarObjectType.MULTI_STAR_SYSTEM);
        this.helper.renameName("WASP-12", "WASP-12 A");
        this.helper.createPlanetensucheObjekt(List.of("WASP-12 BC"), StarObjectType.MULTI_STAR_SYSTEM.getTypeName());
        this.helper.deletePlanetensucheObject("TIC 70440470.01");
        this.helper.deletePlanetensucheObject("TIC 70440470");
        this.helper.addNamen("WASP-112", "TIC 70440470");
        this.helper.addNamen("WASP-112", "TOI-126");
        this.helper.addNamen("WASP-112", "Gaia DR2 6596925769287980416");
        this.helper.addNamen("WASP-112", "2MASS J22375744-3509143");
        this.helper.addNamen("WASP-112 b", "TIC 70440470.01");
        this.helper.addNamen("WASP-112 b", "TOI-126.01");
        this.helper.addNamen("Zkh 275", "Gaia DR2 2266698230601414784");
        this.helper.addNamen("Zkh 275", "WDS J18211+7244B");
        this.helper.createPlanetensucheObjekt(List.of("2MASS J18210058+7246592", "TIC 341873058", "WDS J18211+7244C", "Gaia DR2 2266698234898414848"), "Doppelstern physisch");
        this.helper.deletePlanetensucheObject("K2-415 b");
        this.helper.deletePlanetensucheObject("K2-415");
        this.helper.addNamen("TIC 323687123", "K2-415");
        this.helper.addNamen("TIC 323687123", "EPIC 211414619");
        this.helper.addNamen("TIC 323687123", "LHS 5144");
        this.helper.addNamen("TIC 323687123", "NLTT 21051");
        this.helper.addNamen("TIC 323687123", "2MASS J09084885+1151411");
        this.helper.addNamen("TIC 323687123", "Gaia DR2 604215144503584640");
        this.helper.addNamen("TIC 323687123.01", "K2-415 b");
        this.helper.moveChildObjectsToNewParent("Kepler-1975", "TIC 158320130");
        this.helper.deletePlanetensucheObject("Kepler-1975");
        this.helper.addNamen("TIC 158320130", "Kepler-1975");
        this.helper.addNamen("TIC 158320130", "KIC 8873450");
        this.helper.addNamen("TIC 158320130", "KOI-7913");
        this.helper.addNamen("TOI-3984", "2MASS J15052097+3647124");
        this.helper.addNamen("BD-21 397", "GJ 1044");
        this.helper.deleteName("HD 41004");
        this.helper.addNamen("HD 41004 B", "WDS J05598-4814B");
        this.helper.addNamen("HD 41004 A", "WDS J05598-4814A");
        this.helper.addNamen("TOI-1338", "2MASS J06083197-5932280");
        this.helper.deleteName("HD 206860B");
        this.helper.addNamen("GJ 836.7 B", "TIC 301880198");
        this.helper.addNamen("GJ 836.7 B", "WDS J21445+1446B");
        this.helper.addNamen("HN Pegasi", "WDS J21445+1446A");
        this.helper.renameName("GJ 896 A", "GJ 896 AB");
        this.helper.addNamen("HIP 116132 A", "GJ 896 A");
        this.helper.addNamen("GJ 896 B", "HIP 116132 B");
        this.helper.renameName("HAT-P-8", "HAT-P-8 A");
        this.helper.setStarObjectType("HAT-P-8 A", StarObjectType.MULTI_STAR_SYSTEM);
        this.helper.createPlanetensucheObjekt(List.of("HAT-P-8 BC"), StarObjectType.MULTI_STAR_SYSTEM.getTypeName());
        this.helper.deletePlanetensucheObject("HW Virginis b");
        this.helper.addPlanetsToDiscoverer("Priyashkumar", "Mistry", List.of("TOI-139 b", "TOI-1694 b", "TOI-181 b", "TOI-2194 b", "TOI-2443 b", "TOI-2459 b", "TOI-3082 b", "TOI-4308 b", "TOI-5704 b", "TOI-5803 b", "TOI-672 b", "TOI-913 b"));
        this.helper.deletePlanetensucheObject("HR 3515");
        this.helper.addNamen("M 67", "HR 3515");
    }

    @Override
    public int updateToVersion() {
        return 102;
    }
}

