/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbankkern.impl.migration;

import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLDeleteClause;
import com.querydsl.sql.dml.SQLUpdateClause;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.impl.migration.DatabaseUpdater;
import de.planetensuche.datenbankkern.impl.migration.MigrationHelper;
import de.planetensuche.datenbankkern.querydsl5.Entdecker;
import de.planetensuche.datenbankkern.querydsl5.QEntdecker;
import de.planetensuche.datenbankkern.querydsl5.QZtentdecker;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;

public final class Version103Migrator
implements DatabaseUpdater {
    private static final ILogging LOGGER = LoggingFactory.getLoggerForClass(Version103Migrator.class);
    private final IDatenbankverbinder datenbankverbinder;
    private final MigrationHelper helper;

    public Version103Migrator(IDatenbankverbinder iDatenbankverbinder) {
        this.datenbankverbinder = iDatenbankverbinder;
        this.helper = new MigrationHelper(iDatenbankverbinder);
    }

    @Override
    public void update() throws SQLException {
        Entdecker entdecker;
        LOGGER.debug("starting DB migration to Version " + this.updateToVersion());
        try {
            this.datenbankverbinder.query("CREATE CACHED TABLE gaia_stars (id IDENTITY, datenid INTEGER NOT NULL UNIQUE, non_single VARCHAR(30) NULL, rv_error DOUBLE, ruwe DOUBLE, astro_ex_noise_sig DOUBLE, FOREIGN KEY (datenid) REFERENCES daten (id) ON DELETE CASCADE);");
        }
        catch (SQLException sQLException) {
            LOGGER.debug("Tabelle gaia_stars bereits vorhanden");
        }
        QEntdecker qEntdecker = QEntdecker.entdecker;
        QZtentdecker qZtentdecker = QZtentdecker.ztentdecker;
        Entdecker entdecker2 = (Entdecker)((SQLQuery)this.datenbankverbinder.getQueryFactory().selectFrom((RelationalPath)qEntdecker).where(qEntdecker.nachname.eq("Csizmadia").and(qEntdecker.vorname.eq("Szilard")))).fetchOne();
        if (entdecker2 == null) {
            this.helper.addPlanetsToDiscoverer("Szilard", "Csizmadia", List.of("CoRoT-17 b", "CoRoT-12 b", "CoRoT-13 b"));
        }
        if ((entdecker = (Entdecker)((SQLQuery)this.datenbankverbinder.getQueryFactory().selectFrom((RelationalPath)qEntdecker).where(qEntdecker.nachname.eq("Csizmadia").and(qEntdecker.vorname.eq("Sz.")))).fetchOne()) != null) {
            List list = ((SQLQuery)this.datenbankverbinder.getQueryFactory().selectFrom((RelationalPath)qZtentdecker).where(qZtentdecker.entdeckerid.eq(entdecker2.getId()))).fetch();
            List list2 = ((SQLQuery)this.datenbankverbinder.getQueryFactory().selectFrom((RelationalPath)qZtentdecker).where(qZtentdecker.entdeckerid.eq(entdecker.getId()))).fetch();
            if (!list2.isEmpty()) {
                List<Integer> list3 = list.stream().map(ztentdecker -> ztentdecker.getDatenid()).toList();
                List<Integer> list4 = list2.stream().map(ztentdecker -> ztentdecker.getDatenid()).toList();
                List<Integer> list5 = list4.stream().filter(n -> !list3.contains(n)).toList();
                ((SQLUpdateClause)((SQLUpdateClause)this.datenbankverbinder.getNewSqlUpdateClause(qZtentdecker).set((Path)qZtentdecker.entdeckerid, entdecker2.getId())).where((Predicate)qZtentdecker.entdeckerid.eq(entdecker.getId()).and(qZtentdecker.datenid.in((Collection<Integer>)list5)))).execute();
                ((SQLDeleteClause)this.datenbankverbinder.getNewSqlDeleteClause(qZtentdecker).where((Predicate)qZtentdecker.entdeckerid.eq(entdecker.getId()))).execute();
            }
            ((SQLDeleteClause)this.datenbankverbinder.getNewSqlDeleteClause(qEntdecker).where((Predicate)qEntdecker.id.eq(entdecker.getId()))).execute();
        }
        this.helper.addPlanetsToDiscoverer("Jessie L.", "Christiansen", List.of("HD 3167 d"));
        this.helper.addPlanetsToDiscoverer("Weicheng", "Zang", List.of("KMT-2017-BLG-1194L b"));
        this.helper.addPlanetsToDiscoverer("Steven", "Giacalone", List.of("HD 56414 b"));
    }

    @Override
    public int updateToVersion() {
        return 103;
    }
}

