/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbankkern.impl.migration;

import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQuery;
import de.planetensuche.datamodel.api.GaiaNonSingleStar;
import de.planetensuche.datamodel.api.StarObjectType;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.impl.migration.DatabaseUpdater;
import de.planetensuche.datenbankkern.impl.migration.MigrationHelper;
import de.planetensuche.datenbankkern.querydsl5.Daten;
import de.planetensuche.datenbankkern.querydsl5.GaiaStars;
import de.planetensuche.datenbankkern.querydsl5.QDaten;
import de.planetensuche.datenbankkern.querydsl5.QGaiaStars;
import de.planetensuche.datenbankkern.querydsl5.QObjekttypen;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.sql.SQLException;
import java.util.List;

public final class Version104Migrator
implements DatabaseUpdater {
    private static final ILogging LOGGER = LoggingFactory.getLoggerForClass(Version104Migrator.class);
    private final IDatenbankverbinder datenbankverbinder;
    private final MigrationHelper helper;

    public Version104Migrator(IDatenbankverbinder iDatenbankverbinder) {
        this.datenbankverbinder = iDatenbankverbinder;
        this.helper = new MigrationHelper(iDatenbankverbinder);
    }

    @Override
    public void update() throws SQLException {
        LOGGER.debug("starting DB migration to Version " + this.updateToVersion());
        QGaiaStars qGaiaStars = QGaiaStars.gaiaStars;
        QDaten qDaten = QDaten.daten;
        QObjekttypen qObjekttypen = QObjekttypen.objekttypen;
        List list = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qGaiaStars, qDaten}).from((Expression<?>)qGaiaStars)).join((EntityPath)qDaten)).on((Predicate)qDaten.id.eq(qGaiaStars.datenid))).where(qGaiaStars.nonSingle.in(GaiaNonSingleStar.ASTROMETRIC_BINARY.name(), GaiaNonSingleStar.ECLIPSING_BINARY.name(), GaiaNonSingleStar.SPECTROSCOPIC_BINARY.name()).and(qDaten.objektid.eq((Expression)((SQLQuery)SQLExpressions.select(qObjekttypen.id).from((Expression<?>)qObjekttypen)).where(qObjekttypen.typ.eq(StarObjectType.SINGLE_STAR.getTypeName())))))).fetch();
        LOGGER.debug("found " + list.size() + " non-single gaia stars but was single stars in Planetensuche");
        if (!list.isEmpty()) {
            for (Tuple tuple : list) {
                Integer n;
                Daten daten = tuple.get(qDaten);
                GaiaStars gaiaStars = tuple.get(qGaiaStars);
                GaiaNonSingleStar gaiaNonSingleStar = GaiaNonSingleStar.valueOf(gaiaStars.getNonSingle());
                if (GaiaNonSingleStar.ASTROMETRIC_BINARY.equals((Object)gaiaNonSingleStar) || GaiaNonSingleStar.SPECTROSCOPIC_BINARY.equals((Object)gaiaNonSingleStar)) {
                    n = (Integer)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qObjekttypen.id).from((Expression<?>)qObjekttypen)).where(qObjekttypen.typ.eq(StarObjectType.DOUBLE_STAR_REAL.getTypeName()))).fetchOne();
                    daten.setObjektid(n);
                    this.helper.updatePlanetensucheObjekt(daten);
                    LOGGER.debug("star type updated to double star");
                    continue;
                }
                if (GaiaNonSingleStar.ECLIPSING_BINARY.equals((Object)gaiaNonSingleStar)) {
                    n = (Integer)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qObjekttypen.id).from((Expression<?>)qObjekttypen)).where(qObjekttypen.typ.eq(StarObjectType.ECLIPSING_BINARY.getTypeName()))).fetchOne();
                    daten.setObjektid(n);
                    this.helper.updatePlanetensucheObjekt(daten);
                    LOGGER.debug("star type updated to EB");
                    continue;
                }
                LOGGER.warn("something is wrong with query, got: " + gaiaStars.toString());
            }
        }
        this.helper.renameName("Konigstuhl 3A", "Koenigstuhl 3A");
    }

    @Override
    public int updateToVersion() {
        return 104;
    }
}

