/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbankkern.impl.migration;

import de.planetensuche.datamodel.api.StarObjectType;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.impl.migration.DatabaseUpdater;
import de.planetensuche.datenbankkern.impl.migration.MigrationHelper;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.sql.SQLException;
import java.util.List;

public final class Version107Migrator
implements DatabaseUpdater {
    private static final ILogging LOGGER = LoggingFactory.getLoggerForClass(Version107Migrator.class);
    private final IDatenbankverbinder datenbankverbinder;
    private final MigrationHelper helper;

    public Version107Migrator(IDatenbankverbinder iDatenbankverbinder) {
        this.datenbankverbinder = iDatenbankverbinder;
        this.helper = new MigrationHelper(iDatenbankverbinder);
    }

    @Override
    public void update() throws SQLException {
        LOGGER.debug("starting DB migration to Version " + this.updateToVersion());
        this.helper.renameName("TDSC 1A", "TDSC 1 A");
        this.helper.deleteName("TDSC 556 B");
        this.helper.deleteName("TDSC 556 A");
        this.helper.addNamen("GJ 11 B", "WDS J00133+6919B");
        this.helper.addNamen("GJ 11 B", "NLTT 622B");
        this.helper.addNamen("GJ 11 A", "NLTT 622A");
        this.helper.addNamen("GJ 11 A", "WDS J00133+6919A");
        this.helper.deleteName("HIP 4927");
        this.helper.addNamen("HIP 4927 A", "GJ 1026 A");
        this.helper.addNamen("HIP 4927 A", "WDS J01032+2006A");
        this.helper.deleteName("HEI 42Aa");
        this.helper.addNamen("HIP 50164", "TIC 453895836");
        this.helper.addNamen("HIP 50164", "2MASS J10142129-6809402");
        this.helper.renameName("HIP 50164", "HIP 50164 A");
        this.helper.deleteName("UBV M 21799");
        this.helper.renameName("uvby98 100152751 AB", "uvby98 100152751");
        this.helper.renameName("WDS 21446+2539", "WDS J21446+2539AB");
        this.helper.deleteName("BD+24 4463B");
        this.helper.deletePlanetensucheObject("ADS 13323 B");
        this.helper.renameName("ADS 13323 BPQ", "ADS 13323 B");
        this.helper.deleteName("CCDM J20041+1700BPQ");
        this.helper.addNamen("HD 354615B", "WDS J20041+1700B");
        this.helper.deleteName("HD 354615");
        this.helper.addNamen("HD 354615A", "WDS J20041+1700A");
        this.helper.addNamen("HIP 35904", "TYC 6550-4525-1");
        this.helper.addNamen("HIP 35904", "Cr 121 34");
        this.helper.addNamen("HIP 31453", "HD 47146");
        this.helper.addNamen("HIP 31453", "WDS J06354-3849A");
        this.helper.addNamen("HIP 31453", "Gaia DR3 5576941267796324864");
        this.helper.renameName("CCDM J06354-3849AB", "CCDM J06354-3849A");
        this.helper.addNamen("HIP 105058", "HD 202481");
        this.helper.addNamen("HIP 105058", "WDS J21169-2836A");
        this.helper.addNamen("HIP 105058", "CC Microscopii");
        this.helper.renameName("Gaia DR2 6790302376822574976", "Gaia DR2 6790302376822575104");
        this.helper.addNamen("HIP 465", "WDS J00056+7617A");
        this.helper.createPlanetensucheObjekt(List.of("HIP 455", "2MASS J00052754+7617297", "TIC 373145533", "TYC 4492-1332-1", "WDS J00056+7617B", "Gaia DR3 539839941291012224"), StarObjectType.DOUBLE_STAR_OPTICAL.getTypeName());
        this.helper.createPlanetensucheObjekt(List.of("HIP 1338", "ASCC 373462", "LTT 10093", "BD+40 43", "2MASS J00164504+4104089", "NLTT 836", "TIC 194459612", "TYC 2786-979-1", "Gaia DR2 383474819290674944"), StarObjectType.SINGLE_STAR.getTypeName());
        this.helper.addNamen("HIP 2190", "WDS J00277-1625A");
        this.helper.createPlanetensucheObjekt(List.of("HIP 2189", "TIC 75375144", "2MASS J00273863-1624527", "WDS J00277-1625B", "Gaia DR2 2367706691649255040"), StarObjectType.DOUBLE_STAR_OPTICAL.getTypeName());
        this.helper.createPlanetensucheObjekt(List.of("HIP 3158", "HD 3748", "BD-09 129", "2MASS J00400998-0855529", "TIC 3814749", "TYC 5269-2451-1", "CN Ceti", "WDS J00403-0855A", "Gaia DR2 2426233764315367040", "Gaia DR3 2426233764315367040"), StarObjectType.ECLIPSING_BINARY.getTypeName());
        this.helper.createPlanetensucheObjekt(List.of("HIP 3482", "2MASS J00442829+7712345", "TIC 275189030", "TYC 4497-1552-1", "WDS J00444+7713B", "Gaia DR2 563358495008062976"), StarObjectType.DOUBLE_STAR_OPTICAL.getTypeName());
        this.helper.createPlanetensucheObjekt(List.of("HIP 3856", "GJ 1022", "LFT 78", "2MASS J00492903-6102326", "TIC 234507537", "Gaia DR2 4902689745157488128"), StarObjectType.SINGLE_STAR.getTypeName());
        this.helper.createPlanetensucheObjekt(List.of("HIP 5502", "BD+42 248", "2MASS J01103088+4257268", "WDS J01107+4256B", "TYC 2808-714-1", "Gaia DR2 373209228977098496"), StarObjectType.DOUBLE_STAR_OPTICAL.getTypeName());
        this.helper.createPlanetensucheObjekt(List.of("HIP 6132", "HD 8191", "2MASS J01183803-7325272", "WDS J01186-7325A", "TIC 183645153", "Gaia DR2 4686398280211376256"), StarObjectType.DOUBLE_STAR_REAL.getTypeName());
        this.helper.createPlanetensucheObjekt(List.of("HIP 8538", "BD+13 286B", "TIC 88848242", "2MASS J01500479+1420441", "WDS J01501+1421B", "Gaia DR2 2588051948590777344"), StarObjectType.DOUBLE_STAR_OPTICAL.getTypeName());
        this.helper.createPlanetensucheObjekt(List.of("HIP 8713", "2MASS J01520727+6627171", "TIC 403915192", "TYC 4044-104-1", "WDS J01522+6627B", "Gaia DR2 519227740403939840"), StarObjectType.DOUBLE_STAR_OPTICAL.getTypeName());
        this.helper.createPlanetensucheObjekt(List.of("HIP 8781", "HD 11563", "CD-28 590", "2MASS J01525807-2804440", "TIC 33591339", "WDS J01530-2805A", "Gaia DR2 5024218009461230848", "WZ Fornacis"), StarObjectType.VARIABLE_UNKNOWN_TYPE.getTypeName());
    }

    @Override
    public int updateToVersion() {
        return 107;
    }
}

