/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbankkern.impl.migration;

import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.impl.migration.DatabaseUpdater;
import de.planetensuche.datenbankkern.impl.migration.MigrationHelper;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.sql.SQLException;

public final class Version109Migrator
implements DatabaseUpdater {
    private static final ILogging LOGGER = LoggingFactory.getLoggerForClass(Version109Migrator.class);
    private final IDatenbankverbinder datenbankverbinder;
    private final MigrationHelper helper;

    public Version109Migrator(IDatenbankverbinder iDatenbankverbinder) {
        this.datenbankverbinder = iDatenbankverbinder;
        this.helper = new MigrationHelper(iDatenbankverbinder);
    }

    @Override
    public void update() throws SQLException {
        LOGGER.debug("starting DB migration to Version " + this.updateToVersion());
        this.helper.deleteName("ADS 8627 B");
        this.helper.deleteName("ADS 8627 A");
        this.helper.deleteName("BD-12 3676B");
        this.helper.deleteName("BD-12 3676A");
        this.helper.deleteName("HIP 61910");
        this.helper.deleteName("BD-12 3676");
        this.helper.addNamen("HR 4822", "TIC 181862541");
        this.helper.addNamen("HR 4822", "WDS J12413-1301A");
        this.helper.addNamen("HR 4822", "BD-12 3676A");
        this.helper.addNamen("HR 4822", "Gaia DR2 3528976341368899712");
        this.helper.addNamen("HR 4822", "Gaia DR3 3528976341368899712");
        this.helper.addNamen("HR 4822", "HIP 61910 A");
        this.helper.addNamen("HR 4821", "BD-12 3676B");
    }

    @Override
    public int updateToVersion() {
        return 109;
    }
}

