/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbankkern.impl.migration;

import com.google.inject.Inject;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.dml.SQLUpdateClause;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.impl.migration.DatabaseUpdater;
import de.planetensuche.datenbankkern.querydsl5.QNamen;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public final class Version10Migrator
implements DatabaseUpdater {
    private static final ILogging LOGGER = LoggingFactory.getLoggerForClass(Version10Migrator.class);
    private final IDatenbankverbinder datenbankverbinder;

    @Inject
    public Version10Migrator(IDatenbankverbinder iDatenbankverbinder) {
        this.datenbankverbinder = iDatenbankverbinder;
    }

    @Override
    public int updateToVersion() {
        return 10;
    }

    @Override
    public void update() {
        try {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("OGLE-2009-BLG-151", "OGLE-2009-BLG-151L");
            hashMap.put("OGLE-2009-BLG-151 b", "OGLE-2009-BLG-151L b");
            hashMap.put("OGLE-05-169L", "OGLE-2005-BLG-169L");
            hashMap.put("OGLE-05-169L b", "OGLE-2005-BLG-169L b");
            hashMap.put("OGLE-05-071L", "OGLE-2005-BLG-71L");
            hashMap.put("OGLE-05-071L b", "OGLE-2005-BLG-71L b");
            hashMap.put("OGLE-05-390L", "OGLE-2005-BLG-390L");
            hashMap.put("OGLE-05-390L b", "OGLE-2005-BLG-390L b");
            hashMap.put("OGLE-06-109L", "OGLE-2006-BLG-109L");
            hashMap.put("OGLE-06-109L b", "OGLE-2006-BLG-109L b");
            hashMap.put("OGLE-06-109L c", "OGLE-2006-BLG-109L c");
            hashMap.put("2M1207 b", "2MASS J12073346-3932539 b");
            QNamen qNamen = QNamen.namen1;
            for (Map.Entry entry : hashMap.entrySet()) {
                long l = ((SQLUpdateClause)((SQLUpdateClause)this.datenbankverbinder.getNewSqlUpdateClause(qNamen).set((Path)qNamen.namen, (String)entry.getValue())).where((Predicate)qNamen.namen.eq((String)entry.getKey()))).execute();
                if (l <= 1L) continue;
                LOGGER.warn("f\u00fcr " + (String)entry.getKey() + " wurden " + l + " Zeilen ge\u00e4ndert!");
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace(System.out);
            LOGGER.error("Fehler beim Umbenennen von Exoplaneten", sQLException);
        }
    }
}

