/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbankkern.impl.migration;

import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLDeleteClause;
import de.planetensuche.datamodel.api.StarObjectType;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.impl.migration.DatabaseUpdater;
import de.planetensuche.datenbankkern.impl.migration.MigrationHelper;
import de.planetensuche.datenbankkern.querydsl5.QNamen;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.sql.SQLException;
import java.util.List;

public final class Version111Migrator
implements DatabaseUpdater {
    private static final ILogging LOGGER = LoggingFactory.getLoggerForClass(Version111Migrator.class);
    private final IDatenbankverbinder datenbankverbinder;
    private final MigrationHelper helper;

    public Version111Migrator(IDatenbankverbinder iDatenbankverbinder) {
        this.datenbankverbinder = iDatenbankverbinder;
        this.helper = new MigrationHelper(iDatenbankverbinder);
    }

    @Override
    public void update() throws SQLException {
        LOGGER.debug("starting DB migration to Version " + this.updateToVersion());
        QNamen qNamen = QNamen.namen1;
        List list = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qNamen.id).from((Expression<?>)qNamen)).where(qNamen.namen.startsWith("TYC -"))).fetch();
        LOGGER.info("found " + list.size() + " wrong TYC names");
        long l = ((SQLDeleteClause)this.datenbankverbinder.getNewSqlDeleteClause(qNamen).where((Predicate)qNamen.id.in(list))).execute();
        LOGGER.info(l + " wrong TYC entries deleted");
        this.helper.deletePlanetensucheObject("HD 94941");
        this.helper.deletePlanetensucheObject("HIP 53568");
        this.helper.deletePlanetensucheObject("Gaia DR3 3757117135752936576");
        this.helper.deletePlanetensucheObject("WDS J10575-1105AB");
        this.helper.addNamen("HIP 53568 A", "HD 94941");
        this.helper.addNamen("HIP 53568 A", "Gaia DR3 3757117135752936576");
        this.helper.addNamen("HIP 53568 A", "WDS J10575-1105AB");
        this.helper.addNamen("HIP 53568 A", "BD-10 3159");
        if (!this.helper.existsName("TIC 148560398")) {
            this.helper.addNamen("HIP 53568 A", "TIC 148560398");
        }
        this.helper.deletePlanetensucheObject("HIP 95723");
        this.helper.deletePlanetensucheObject("HIP 60450");
        this.helper.deletePlanetensucheObject("HIP 59018");
        this.helper.deletePlanetensucheObject("WDS J18368-4233AB");
        this.helper.renameName("HIP 91256", "HIP 91256 A");
        this.helper.addNamen("HIP 91256 A", "Gaia DR2 6722268754833584896");
        this.helper.addNamen("HIP 91256 A", "TIC 405951240");
        this.helper.addNamen("HIP 91256 A", "WDS J18368-4233A");
        this.helper.deleteName("2MASS J17461275-3206088 B");
        this.helper.deleteName("HIP 86961 B");
        this.helper.addNamen("V617 Sagittarii", "TIC 55833822");
        this.helper.addNamen("V617 Sagittarii", "Gaia DR2 4038875335491155328");
        this.helper.addNamen("IC 1", "TIC 427733229");
        this.helper.addNamen("IC 1", "Gaia DR2 2853867680699315200");
        this.helper.addNamen("ADS 449 B", "TIC 468360614");
        this.helper.addNamen("SAO 251903", "TIC 450568600");
        this.helper.addNamen("SAO 251903", "WDS J12266-6306C");
        this.helper.addNamen("SAO 251903", "Gaia DR2 6053807844582485248");
        this.helper.addNamen("LHS 6343 A", "WDS J19102+4657A");
        this.helper.addNamen("LHS 6343 A", "Gaia DR2 2130469362695417856");
        this.helper.addNamen("LHS 6343 B", "WDS J19102+4657B");
        this.helper.addNamen("LHS 6343 B", "Gaia DR2 2130469362695417728");
        this.helper.addNamen("LTT 11", "TIC 439397980");
        this.helper.addNamen("LTT 11", "EGGR 508");
        this.helper.addNamen("LTT 11", "Gaia DR2 2414888694102153088");
        this.helper.addNamen("WD 1520+525", "TIC 193990614");
        this.helper.addNamen("WD 1520+525", "Gaia DR2 1595941441250636672");
        this.helper.addNamen("DY Centauri", "TIC 359395071");
        this.helper.addNamen("DY Centauri", "Gaia DR2 6067139045081878016");
        this.helper.addNamen("QS Tauri", "EPIC 211078698");
        this.helper.addNamen("QS Tauri", "TIC 405484248");
        this.helper.addNamen("QS Tauri", "Gaia DR2 66728089380491648");
        this.helper.addNamen("AX Velorum", "TIC 81100755");
        this.helper.addNamen("AX Velorum", "Gaia DR2 5519196703818908800");
        this.helper.addNamen("BZ Tucanae", "TIC 267547804");
        this.helper.addNamen("BZ Tucanae", "Gaia DR2 4685821487608191104");
        this.helper.addNamen("TY Columbae", "TIC 20096356");
        this.helper.addNamen("TY Columbae", "Gaia DR2 2884080885842578176");
        this.helper.addNamen("BR Crucis", "TIC 419788429");
        this.helper.addNamen("BR Crucis", "Gaia DR2 6061204912121636608");
        this.helper.addNamen("BR Crucis", "WDS J12464-5629B");
        this.helper.addNamen("MY Geminorum", "TIC 60103379");
        this.helper.addNamen("MY Geminorum", "Gaia DR2 3359999443045175680");
        this.helper.addNamen("MU Geminorum", "TIC 157743471");
        this.helper.setStarObjectType("MU Geminorum", StarObjectType.ECLIPSING_BINARY);
        this.helper.deletePlanetensucheObject("GJ 831 A");
        this.helper.deletePlanetensucheObject("GJ 831 B");
        this.helper.deletePlanetensucheObject("Gaia DR3 4690499806497887360");
        this.helper.addNamen("HIP 4773", "Gaia DR3 4690499806497887360");
        this.helper.deletePlanetensucheObject("GJ 231.1 C");
        this.helper.addNamen("GJ 231.1 B", "TIC 265361131");
        this.helper.addNamen("GJ 231.1 B", "WDS J06173+0506E");
        this.helper.addNamen("GJ 231.1 B", "Gaia DR2 3317901440625203968");
        this.helper.deletePlanetensucheObject("Gaia DR3 4690499772138161536");
        this.helper.addNamen("HIP 4768", "Gaia DR3 4690499772138161536");
        this.helper.addNamen("HIP 4768", "WDS J01013-7217A");
        this.helper.deletePlanetensucheObject("HIP 16216");
        this.helper.addNamen("TOI-2690", "HIP 16216");
        this.helper.addNamen("TOI-2690", "WDS J03289-1959BC");
    }

    @Override
    public int updateToVersion() {
        return 111;
    }
}

