/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbankkern.impl.migration;

import de.planetensuche.datamodel.api.StarObjectType;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.impl.migration.DatabaseUpdater;
import de.planetensuche.datenbankkern.impl.migration.MigrationHelper;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.sql.SQLException;

public final class Version113Migrator
implements DatabaseUpdater {
    private static final ILogging LOGGER = LoggingFactory.getLoggerForClass(Version113Migrator.class);
    private final IDatenbankverbinder datenbankverbinder;
    private final MigrationHelper helper;

    public Version113Migrator(IDatenbankverbinder iDatenbankverbinder) {
        this.datenbankverbinder = iDatenbankverbinder;
        this.helper = new MigrationHelper(iDatenbankverbinder);
    }

    @Override
    public void update() throws SQLException {
        LOGGER.debug("starting DB migration to Version " + this.updateToVersion());
        this.helper.deletePlanetensucheObject("Alpha Aurigae");
        this.helper.addNamen("Alpha Aurigae A", "WDS J05167+4600A");
        this.helper.renameName("Capella A", "Capella");
        this.helper.deleteName("BD+45 1077A");
        this.helper.deleteName("13 Aurigae A");
        this.helper.deleteName("2MASS J05164138+4559525 A");
        this.helper.setStarObjectType("Capella", StarObjectType.DOUBLE_STAR_REAL);
        this.helper.deletePlanetensucheObject("GJ 1177");
        this.helper.addNamen("HIP 67308 A", "GJ 1177 A");
        this.helper.addNamen("HIP 67308 A", "WDS J13477-3226A");
        this.helper.addNamen("HIP 67308 B", "WDS J13477-3226B");
        this.helper.deletePlanetensucheObject("Alpha Comae Berenices");
        this.helper.addNamen("HR 4969", "WDS J13100+1732B");
        this.helper.addNamen("HR 4969", "TYC 1454-1134-2");
        this.helper.deletePlanetensucheObject("Gamma Coronae Australis");
        this.helper.addNamen("HR 7227", "TYC 7422-1737-2");
        this.helper.addNamen("HR 7227", "WDS J19064-3704B");
        this.helper.addNamen("HR 7227", "Gaia DR2 6719152945029845376");
        this.helper.deletePlanetensucheObject("HIP 110922");
        this.helper.addNamen("HIP 110922 A", "TIC 209308403");
        this.helper.addNamen("HIP 110922 A", "WDS J22284-2553A");
        this.helper.setStarObjectType("HIP 110922 A", StarObjectType.DOUBLE_STAR_REAL);
        this.helper.deletePlanetensucheObject("Gaia DR3 3207120455805080832");
        this.helper.addNamen("HIP 24472", "Gaia DR3 3207120455805080832");
        this.helper.deletePlanetensucheObject("WDS J12095-1151AB");
        this.helper.addNamen("HIP 59272", "WDS J12095-1151AB");
        this.helper.deletePlanetensucheObject("Gaia DR3 26283932836820096");
        this.helper.deletePlanetensucheObject("Gaia DR3 1174189362318863488");
        this.helper.addNamen("HIP 72981", "Gaia DR3 1174189362318863488");
        this.helper.addNamen("HIP 72981", "GJ 3874");
        this.helper.deletePlanetensucheObject("HIP 94336");
        this.helper.deletePlanetensucheObject("HD 28255");
        this.helper.addNamen("TIC 358290717", "WDS J04242-5704A");
        this.helper.addNamen("TIC 358290717", "GJ 9155 A");
        this.helper.addNamen("TIC 358290716", "WDS J04242-5704B");
        this.helper.addNamen("TIC 358290716", "GJ 9155 B");
        this.helper.deletePlanetensucheObject("17 Crateris");
        this.helper.deletePlanetensucheObject("Gamma Crucis");
        this.helper.addNamen("HR 4764", "TIC 272482277");
        this.helper.addNamen("HR 4764", "WDS J12312-5707B");
        this.helper.addNamen("HR 4763", "WDS J12312-5707A");
        this.helper.deletePlanetensucheObject("TIC 355480242");
        this.helper.addNamen("HIP 115781", "TIC 355480242");
        this.helper.addNamen("WDS J23274-5218B", "TIC 355480242");
        this.helper.deletePlanetensucheObject("HIP 24710");
        this.helper.deleteName("2MASS J05180068-2729267");
        this.helper.deleteName("Gaia DR2 2955234715683010688");
        this.helper.deleteName("TIC 30946263");
        this.helper.deleteName("TIC 30946262");
        this.helper.deleteName("2MASS J05180038-2729265");
        this.helper.addNamen("HIP 24710 B", "2MASS J05180038-2729265");
        this.helper.addNamen("HIP 24710 B", "TIC 30946262");
        this.helper.addNamen("HIP 24710 B", "WDS J05180-2729B");
        this.helper.addNamen("HIP 24710 B", "Gaia DR2 2955234715683010688");
        this.helper.addNamen("HIP 24710 A", "TIC 30946263");
        this.helper.addNamen("HIP 24710 A", "WDS J05180-2729A");
        this.helper.addNamen("HIP 24710 A", "2MASS J05180068-2729267");
        this.helper.addNamen("HIP 24710 A", "VW Columbae");
        this.helper.deletePlanetensucheObject("WDS J07343-2328AB");
        this.helper.addNamen("SAO 174020", "TIC 423245341");
        this.helper.deletePlanetensucheObject("Gaia DR3 5271611183731282304");
        this.helper.deletePlanetensucheObject("Gaia DR3 2665087581524066176");
        this.helper.addNamen("GJ 288 B", "TIC 149744486");
        this.helper.addNamen("GJ 837.1", "TIC 333464497");
        this.helper.addNamen("NLTT 37443", "TIC 284628173");
        this.helper.addNamen("LHS 290", "GJ 401 B");
        this.helper.addNamen("LHS 290", "Gaia DR2 3554395813252626048");
        this.helper.addNamen("LHS 290", "WDS J10457-1907B");
        this.helper.addNamen("GJ 1273", "TIC 435825249");
        this.helper.addNamen("LHS 6003", "EGGR 2");
        this.helper.addNamen("LHS 6003", "LAWD 3");
        this.helper.addNamen("LHS 6003", "TIC 58733472");
        this.helper.addNamen("CM Tauri", "Crab Pulsar");
        this.helper.addNamen("CM Tauri", "TIC 437836906");
        this.helper.addNamen("CM Tauri", "Gaia DR3 3403818172572314624");
        this.helper.addNamen("GJ 596 B", "TIC 255862815");
        this.helper.addNamen("GJ 596 B", "WDS J15430+2617B");
        this.helper.addNamen("GJ 596 A", "WDS J15430+2617A");
        this.helper.addNamen("GJ 596 A", "TIC 255862810");
        this.helper.addNamen("GJ 596 A", "ASCC 690770");
        this.helper.addNamen("GJ 394", "TIC 416519074");
        this.helper.addNamen("GJ 394", "WDS J10306+5559B");
        this.helper.addNamen("44 Bootis B", "Gaia DR2 1588936555749388928");
    }

    @Override
    public int updateToVersion() {
        return 113;
    }
}

