/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbankkern.impl.migration;

import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.impl.migration.DatabaseUpdater;
import de.planetensuche.datenbankkern.impl.migration.MigrationHelper;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.sql.SQLException;

public final class Version114Migrator
implements DatabaseUpdater {
    private static final ILogging LOGGER = LoggingFactory.getLoggerForClass(Version114Migrator.class);
    private final IDatenbankverbinder datenbankverbinder;
    private final MigrationHelper helper;

    public Version114Migrator(IDatenbankverbinder iDatenbankverbinder) {
        this.datenbankverbinder = iDatenbankverbinder;
        this.helper = new MigrationHelper(iDatenbankverbinder);
    }

    @Override
    public void update() throws SQLException {
        LOGGER.debug("starting DB migration to Version " + this.updateToVersion());
        this.helper.renameName("WDS J05278-2848AB", "WDS J05278-2848A");
        this.helper.addNamen("2MASS J05274593-2848040", "WDS J05278-2848B");
        this.helper.addNamen("2MASS J05274593-2848040", "TYC 6488-1063-2");
        this.helper.deletePlanetensucheObject("GJ 3874");
        this.helper.addNamen("HIP 72981", "GJ 3874");
        this.helper.deletePlanetensucheObject("WDS J23274-5218B");
        this.helper.addNamen("TIC 355480242", "WDS J23274-5218B");
        this.helper.deletePlanetensucheObject("HD 196885");
        this.helper.deletePlanetensucheObject("Gaia DR3 3277270538903180160");
        this.helper.deletePlanetensucheObject("Gaia DR3 4244170137974089728");
        this.helper.deletePlanetensucheObject("Gaia DR3 3279109742681295360");
        this.helper.deletePlanetensucheObject("Gaia DR3 4149820284980989184");
        this.helper.deletePlanetensucheObject("WDS J20132+0256A");
        this.helper.addNamen("HIP 99629", "WDS J20132+0256A");
        this.helper.deletePlanetensucheObject("Iota Cassiopeiae");
        this.helper.addNamen("Iota Cassiopeiae B", "Gaia DR2 517650353531686144");
        this.helper.addNamen("ADS 1860 C", "TIC 279509401");
        this.helper.deletePlanetensucheObject("WDS J04312+0157AB");
        this.helper.addNamen("HIP 21092", "WDS J04312+0157AB");
        this.helper.deletePlanetensucheObject("WDS J17459-1318A");
        this.helper.addNamen("HIP 86938", "WDS J17459-1318A");
        this.helper.deletePlanetensucheObject("HIP 91924");
        this.helper.addNamen("HIP 91906", "HIP 91924");
        this.helper.addNamen("HIP 91906", "MCC 189");
        this.helper.addNamen("HIP 91906", "WDS J18444+7600A");
    }

    @Override
    public int updateToVersion() {
        return 114;
    }
}

