/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbankkern.impl.migration;

import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.impl.migration.DatabaseUpdater;
import de.planetensuche.datenbankkern.impl.migration.MigrationHelper;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.sql.SQLException;

public final class Version115Migrator
implements DatabaseUpdater {
    private static final ILogging LOGGER = LoggingFactory.getLoggerForClass(Version115Migrator.class);
    private final IDatenbankverbinder datenbankverbinder;
    private final MigrationHelper helper;

    public Version115Migrator(IDatenbankverbinder iDatenbankverbinder) {
        this.datenbankverbinder = iDatenbankverbinder;
        this.helper = new MigrationHelper(iDatenbankverbinder);
    }

    @Override
    public void update() throws SQLException {
        LOGGER.debug("starting DB migration to Version " + this.updateToVersion());
        this.helper.deletePlanetensucheObject("TIC 59087096");
        this.helper.deletePlanetensucheObject("Gaia DR3 3313526556869575296");
        this.helper.deletePlanetensucheObject("WDS J04248+1552A");
        this.helper.addNamen("HIP 20605", "TIC 59087096");
        this.helper.addNamen("HIP 20605", "WDS J04248+1552A");
        this.helper.addNamen("HIP 20605", "Mel 25 OS 300");
        this.helper.deletePlanetensucheObject("Gaia DR3 2722184666306107008");
        this.helper.deletePlanetensucheObject("WDS J22553-4828CD");
        this.helper.deletePlanetensucheObject("Gaia DR3 50298125783225088");
        this.helper.addNamen("HIP 19082", "Mel 25 226");
        this.helper.addNamen("HIP 19082", "EPIC 210771915");
        this.helper.deletePlanetensucheObject("HIP 42652");
        this.helper.deleteName("CCDM J08416+6924AB");
        this.helper.addNamen("HIP 42652 A", "WDS J08416+6924A");
        this.helper.addNamen("HIP 42652 B", "WDS J08416+6924B");
        this.helper.deletePlanetensucheObject("Gaia DR3 2225603369338348416");
        this.helper.deletePlanetensucheObject("39 Eridani");
        this.helper.addNamen("ADS 3079 B", "Gaia DR2 3191969567824442368");
    }

    @Override
    public int updateToVersion() {
        return 115;
    }
}

