/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbankkern.impl.migration;

import de.planetensuche.datamodel.api.StarObjectType;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.impl.migration.DatabaseUpdater;
import de.planetensuche.datenbankkern.impl.migration.MigrationHelper;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.sql.SQLException;
import java.util.List;

public final class Version116Migrator
implements DatabaseUpdater {
    private static final ILogging LOGGER = LoggingFactory.getLoggerForClass(Version116Migrator.class);
    private final IDatenbankverbinder datenbankverbinder;
    private final MigrationHelper helper;

    public Version116Migrator(IDatenbankverbinder iDatenbankverbinder) {
        this.datenbankverbinder = iDatenbankverbinder;
        this.helper = new MigrationHelper(iDatenbankverbinder);
    }

    @Override
    public void update() throws SQLException {
        LOGGER.debug("starting DB migration to Version " + this.updateToVersion());
        this.helper.deletePlanetensucheObject("GJ 700.1");
        this.helper.deletePlanetensucheObject("Gaia DR3 3276041594138711040");
        this.helper.deletePlanetensucheObject("Gaia DR3 3300228444769145856");
        this.helper.deletePlanetensucheObject("Gaia DR3 266076492460606592");
        this.helper.deletePlanetensucheObject("Gaia DR3 1461833904932026368");
        this.helper.deletePlanetensucheObject("WDS J05055+5249A");
        this.helper.addNamen("TIC 327587609", "WDS J05055+5249A");
        this.helper.deletePlanetensucheObject("TIC 459822191");
        this.helper.deletePlanetensucheObject("WDS J13164+2906A");
        this.helper.addNamen("HIP 64766", "WDS J13164+2906A");
        this.helper.deleteName("TIC 471011820");
        this.helper.addNamen("HIP 64766", "TIC 459822191");
        this.helper.deletePlanetensucheObject("HIP 69684");
        this.helper.deleteName("HIP 69684 B");
        this.helper.deleteName("HIP 69684 A");
        this.helper.deleteName("Gaia DR2 1225039507360455040");
        this.helper.deleteName("Gaia DR2 1225039507359916800");
        this.helper.addNamen("TIC 421730173", "HD 124864");
        this.helper.addNamen("TIC 421730173", "HIP 69684 A");
        this.helper.addNamen("TIC 421730173", "GC 19243");
        this.helper.addNamen("TIC 421730173", "WDS J14158+1018AB");
        this.helper.addNamen("TIC 421730173", "Gaia DR2 1225039507359916800");
        this.helper.addNamen("TIC 421730174", "Gaia DR2 1225039507360455040");
        this.helper.addNamen("TIC 421730174", "WDS J14158+1018C");
        this.helper.addNamen("TIC 421730174", "BD+10 2657C");
        this.helper.deleteName("2MASS J21513992+1918263");
        this.helper.deleteName("2MASS J21514016+1918248");
        this.helper.deleteName("ADS 15386 AB");
        this.helper.deleteName("TIC 257953070");
        this.helper.deletePlanetensucheObject("HD 207859");
        this.helper.addNamen("HIP 107896", "TIC 257953066");
        this.helper.deletePlanetensucheObject("HIP 62653 B");
        this.helper.deletePlanetensucheObject("TIC 392996372");
        this.helper.deletePlanetensucheObject("HIP 71228");
        this.helper.addNamen("Gaia DR2 5878363481412711936", "TIC 392996372");
        this.helper.addNamen("Gaia DR2 5878363481412711936", "HIP 71228");
        this.helper.addNamen("Gaia DR2 5878363481412711936", "WDS J14338-6124A");
        this.helper.deletePlanetensucheObject("TIC 1233934");
        this.helper.addNamen("Gaia DR2 4874497923424781312", "TIC 1233934");
        this.helper.addNamen("TIC 421911619", "TYC 8764-2607-2");
        this.helper.deletePlanetensucheObject("V431 Scuti");
        this.helper.addNamen("HIP 90617", "V431 Scuti");
        this.helper.deletePlanetensucheObject("2MASS J10491891-5319100");
        this.helper.deletePlanetensucheObject("Gaia DR2 5353625852001928960");
        this.helper.deletePlanetensucheObject("TIC 119862115");
        this.helper.addNamen("WDS J10493-5319AB", "2MASS J10491891-5319100");
        this.helper.addNamen("WDS J10493-5319AB", "TIC 119862115");
        this.helper.addNamen("WDS J10493-5319AB", "Gaia DR3 5353626573555863424");
        this.helper.deletePlanetensucheObject("TIC 29928567");
        this.helper.addNamen("Zkh 27", "TIC 29928567");
        this.helper.deletePlanetensucheObject("Gaia DR2 5337283948144897664");
        this.helper.deletePlanetensucheObject("TIC 466524153");
        this.helper.deletePlanetensucheObject("HIP 54171");
        this.helper.addNamen("WDS J11049-6103B", "TIC 466524153");
        this.helper.addNamen("WDS J11049-6103B", "Gaia DR2 5337283948144897664");
        this.helper.addNamen("WDS J11049-6103B", "HIP 54171");
        this.helper.deletePlanetensucheObject("TIC 61430026");
        this.helper.addNamen("HIP 89535", "TIC 61430026");
        this.helper.deletePlanetensucheObject("TIC 84224669");
        this.helper.addNamen("Gaia DR2 528066641362242688", "TIC 84224669");
        this.helper.deletePlanetensucheObject("TIC 467431322");
        this.helper.addNamen("Gaia DR2 1987715679258222976", "TIC 467431322");
        this.helper.deleteName("2MASS J22275958+5741453");
        this.helper.addNamen("Zkh 332", "2MASS J22275958+5741453 B");
        this.helper.deletePlanetensucheObject("2MASS J10481463-3956062");
        this.helper.deletePlanetensucheObject("TIC 107012050");
        this.helper.deletePlanetensucheObject("WDS J10482-3956A");
        this.helper.addNamen("Gaia DR2 5393446658454453632", "2MASS J10481463-3956062");
        this.helper.addNamen("Gaia DR2 5393446658454453632", "TIC 107012050");
        this.helper.addNamen("Gaia DR2 5393446658454453632", "WDS J10482-3956A");
        this.helper.deletePlanetensucheObject("TIC 146692032");
        this.helper.deletePlanetensucheObject("Gaia DR2 4752399493622045696");
        this.helper.addNamen("2MASS J02550357-4700509", "Gaia DR2 4752399493622045696");
        this.helper.addNamen("2MASS J02550357-4700509", "TIC 146692032");
        this.helper.deletePlanetensucheObject("TIC 67773411");
        this.helper.deletePlanetensucheObject("WISE J041521.21-093500.6");
        this.helper.deletePlanetensucheObject("WISEA J041521.26-093500.4");
        this.helper.addNamen("2MASS J04151954-0935066", "TIC 67773411");
        this.helper.addNamen("2MASS J04151954-0935066", "WISE J041521.21-093500.6");
        this.helper.addNamen("2MASS J04151954-0935066", "WISEA J041521.26-093500.4");
        this.helper.deletePlanetensucheObject("2MASS J18353790+3259545");
        this.helper.deletePlanetensucheObject("WISEA J183537.82+325945.4");
        this.helper.deletePlanetensucheObject("TIC 27858644");
        this.helper.addNamen("Gaia DR2 2091177593123254016", "2MASS J18353790+3259545");
        this.helper.addNamen("Gaia DR2 2091177593123254016", "WISEA J183537.82+325945.4");
        this.helper.addNamen("Gaia DR2 2091177593123254016", "TIC 27858644");
        this.helper.deletePlanetensucheObject("2MASS J17412462+2553343");
        this.helper.deletePlanetensucheObject("WISEA J174124.22+255319.2");
        this.helper.deletePlanetensucheObject("WISE J174124.25+255319.6");
        this.helper.addNamen("TIC 359416488", "2MASS J17412462+2553343");
        this.helper.addNamen("TIC 359416488", "WISEA J174124.22+255319.2");
        this.helper.addNamen("TIC 359416488", "WISE J174124.25+255319.6");
        this.helper.deletePlanetensucheObject("WDS J19169+0510B");
        this.helper.deletePlanetensucheObject("2MASS J19165762+0509021");
        this.helper.deletePlanetensucheObject("Gaia DR2 4293315765165489536");
        this.helper.deletePlanetensucheObject("TIC 176178205");
        this.helper.addNamen("V1298 Aquilae", "WDS J19169+0510B");
        this.helper.addNamen("V1298 Aquilae", "2MASS J19165762+0509021");
        this.helper.addNamen("V1298 Aquilae", "Gaia DR2 4293315765165489536");
        this.helper.addNamen("V1298 Aquilae", "TIC 176178205");
        this.helper.deletePlanetensucheObject("WISE J093735.61+293127.7");
        this.helper.deletePlanetensucheObject("2MASS J09373487+2931409");
        this.helper.deletePlanetensucheObject("SDSS J093735.17+293135.7");
        this.helper.deletePlanetensucheObject("WISEA J093735.63+293127.2");
        this.helper.addNamen("TIC 330794872", "2MASS J09373487+2931409");
        this.helper.addNamen("TIC 330794872", "WISE J093735.61+293127.7");
        this.helper.addNamen("TIC 330794872", "SDSS J093735.17+293135.7");
        this.helper.addNamen("TIC 330794872", "WISEA J093735.63+293127.2");
        this.helper.deletePlanetensucheObject("2MASS J01365662+0933473");
        this.helper.deletePlanetensucheObject("Gaia DR2 2572901021957789568");
        this.helper.deletePlanetensucheObject("WISEA J013657.44+093347.0");
        this.helper.addNamen("TIC 346896171", "2MASS J01365662+0933473");
        this.helper.addNamen("TIC 346896171", "Gaia DR2 2572901021957789568");
        this.helper.addNamen("TIC 346896171", "WISEA J013657.44+093347.0");
        this.helper.deletePlanetensucheObject("Gaia DR3 5038199742917400192");
        this.helper.deletePlanetensucheObject("CCDM J05068-2135BC");
        this.helper.deletePlanetensucheObject("2MASS J05064946-2135038");
        this.helper.deletePlanetensucheObject("TYC 5913-1376-1");
        this.helper.deletePlanetensucheObject("GJ 3332");
        this.helper.deletePlanetensucheObject("WDS J05069-2135BC");
        this.helper.deletePlanetensucheObject("StKM 1-545");
        this.helper.addNamen("TIC 146522419", "CCDM J05068-2135BC");
        this.helper.addNamen("TIC 146522419", "2MASS J05064946-2135038");
        this.helper.addNamen("TIC 146522419", "Gaia DR2 2962658549474035712");
        this.helper.addNamen("TIC 146522419", "TYC 5913-1376-1");
        this.helper.addNamen("TIC 146522419", "GJ 3332");
        this.helper.addNamen("TIC 146522419", "WDS J05069-2135BC");
        this.helper.deletePlanetensucheObject("8pc 156.30");
        this.helper.addNamen("GJ 3877", "8pc 156.30");
        this.helper.deleteName("TYC 3501-1952-1");
        this.helper.addNamen("GJ 661 B", "Gaia DR3 1364668825433435776");
        this.helper.deletePlanetensucheObject("PM J16555-0823");
        this.helper.deletePlanetensucheObject("LHS 429");
        this.helper.deletePlanetensucheObject("CCDM J16555-0820D");
        this.helper.deletePlanetensucheObject("NLTT 43802");
        this.helper.deletePlanetensucheObject("8pc 153.96C");
        this.helper.deletePlanetensucheObject("WDS J16555-0820F");
        this.helper.deletePlanetensucheObject("Gaia DR2 4339417394313320192");
        this.helper.deletePlanetensucheObject("2MASS J16553529-0823401");
        this.helper.deletePlanetensucheObject("USNO 869");
        this.helper.deletePlanetensucheObject("UCAC4 409-067034");
        this.helper.deletePlanetensucheObject("UCAC3 164-149688");
        this.helper.deletePlanetensucheObject("WISEA J165534.68-082349.7");
        this.helper.addNamen("GJ 644 C", "LHS 429");
        this.helper.addNamen("GJ 644 C", "TIC 181609153");
        this.helper.addNamen("GJ 644 C", "CCDM J16555-0820D");
        this.helper.addNamen("GJ 644 C", "NLTT 43802");
        this.helper.addNamen("GJ 644 C", "8pc 153.96C");
        this.helper.addNamen("GJ 644 C", "WDS J16555-0820F");
        this.helper.addNamen("GJ 644 C", "Gaia DR2 4339417394313320192");
        this.helper.addNamen("GJ 644 C", "2MASS J16553529-0823401");
        this.helper.deletePlanetensucheObject("2MASS J15150083+4847416");
        this.helper.addNamen("TIC 309848930", "Gaia DR3 1589250088362827776");
        this.helper.addNamen("TIC 309848930", "2MASS J15150083+4847416");
        this.helper.deletePlanetensucheObject("Gaia DR2 5260451999700465536");
        this.helper.addNamen("TIC 142052876", "Gaia DR2 5260451999700465536");
        this.helper.deletePlanetensucheObject("GJ 3192");
        this.helper.deletePlanetensucheObject("2MASS J03015107-1635306");
        this.helper.deletePlanetensucheObject("LP 771-95");
        this.helper.deletePlanetensucheObject("NLTT 9671");
        this.helper.deletePlanetensucheObject("UCAC4 368-003328");
        this.helper.deletePlanetensucheObject("WDS J03019-1633BC");
        this.helper.deletePlanetensucheObject("Gaia DR2 5153091836072107008");
        this.helper.addNamen("TIC 98796342", "GJ 3192");
        this.helper.addNamen("TIC 98796342", "2MASS J03015107-1635306");
        this.helper.addNamen("TIC 98796342", "LP 771-95");
        this.helper.addNamen("TIC 98796342", "NLTT 9671");
        this.helper.addNamen("TIC 98796342", "WDS J03019-1633BC");
        this.helper.addNamen("TIC 98796342", "Gaia DR2 5153091836072107008");
        this.helper.deletePlanetensucheObject("TIC 432216119");
        this.helper.deletePlanetensucheObject("WISEA J150747.56-162749.3");
        this.helper.deletePlanetensucheObject("Gaia DR2 6306068659857135232");
        this.helper.addNamen("2MASS J15074769-1627386", "TIC 432216119");
        this.helper.addNamen("2MASS J15074769-1627386", "EPIC 249914869");
        this.helper.addNamen("2MASS J15074769-1627386", "Gaia DR2 6306068659857135232");
        this.helper.deletePlanetensucheObject("WISEA J125905.84-433627.2");
        this.helper.deletePlanetensucheObject("2MASS J12590470-4336243");
        this.helper.deletePlanetensucheObject("Gaia DR2 6135947032490329472");
        this.helper.addNamen("TIC 248223026", "2MASS J12590470-4336243");
        this.helper.addNamen("TIC 248223026", "Gaia DR2 6135947032490329472");
        this.helper.deletePlanetensucheObject("2MASS J18002648+0134565");
        this.helper.deletePlanetensucheObject("Gaia DR2 4468009917744160000");
        this.helper.addNamen("TIC 404613256", "2MASS J18002648+0134565");
        this.helper.addNamen("TIC 404613256", "Gaia DR2 4468009917744160000");
        this.helper.addNamen("TIC 404613256", "Gaia DR3 4468009917744160000");
        this.helper.deletePlanetensucheObject("2MASS J04465175-1116476");
        this.helper.deletePlanetensucheObject("UCAC4 394-006560");
        this.helper.deletePlanetensucheObject("RBS 584");
        this.helper.deletePlanetensucheObject("WDS J04469-1117AB");
        this.helper.addNamen("TIC 146819340", "2MASS J04465175-1116476");
        this.helper.addNamen("TIC 146819340", "WDS J04469-1117AB");
        this.helper.deletePlanetensucheObject("2MASS J21481633+4003594");
        this.helper.deletePlanetensucheObject("Gaia DR2 1954170404122975232");
        this.helper.deletePlanetensucheObject("WISEA J214817.01+400404.1");
        this.helper.addNamen("TIC 305387751", "2MASS J21481633+4003594");
        this.helper.addNamen("TIC 305387751", "Gaia DR2 1954170404122975232");
        this.helper.deletePlanetensucheObject("Gaia DR2 672055699133504768");
        this.helper.addNamen("2MASS J07464256+2000321", "Gaia DR2 672055699133504768");
        this.helper.addNamen("2MASS J07464256+2000321", "TIC 62854893");
        this.helper.deletePlanetensucheObject("TIC 144294174");
        this.helper.addNamen("53 Ursae Majoris A", "Gaia DR2 756853643637996672");
        this.helper.addNamen("53 Ursae Majoris A", "TIC 144294174");
        this.helper.addNamen("HIP 94223 B", "Gaia DR2 6661809427911371136");
        this.helper.addNamen("HIP 94223 B", "WDS J19109-4804C");
        this.helper.addNamen("HIP 94223 B", "TYC 8379-2079-2");
        this.helper.deletePlanetensucheObject("HIP 114176");
        this.helper.deletePlanetensucheObject("TIC 14711043");
        this.helper.deletePlanetensucheObject("WISEA J072719.15+170951.3");
        this.helper.addNamen("2MASS J07271824+1710012", "TIC 14711043");
        this.helper.deletePlanetensucheObject("TIC 257504474");
        this.helper.deletePlanetensucheObject("WDS J02055-1159AB");
        this.helper.deletePlanetensucheObject("WISEA J020529.69-115929.2");
        this.helper.deletePlanetensucheObject("Gaia DR2 5151358868307074432");
        this.helper.addNamen("2MASS J02052940-1159296", "TIC 257504474");
        this.helper.addNamen("2MASS J02052940-1159296", "WDS J02055-1159AB");
        this.helper.addNamen("2MASS J02052940-1159296", "Gaia DR2 5151358868307074432");
        this.helper.deletePlanetensucheObject("2MASS J04132663-0139211");
        this.helper.deletePlanetensucheObject("Gaia DR2 3252692330853394304");
        this.helper.deletePlanetensucheObject("WDS J04134-0139AB");
        this.helper.deletePlanetensucheObject("UCAC4 442-005985");
        this.helper.addNamen("TIC 250134805", "2MASS J04132663-0139211");
        this.helper.addNamen("TIC 250134805", "Gaia DR2 3252692330853394304");
        this.helper.addNamen("TIC 250134805", "WDS J04134-0139A");
        this.helper.createPlanetensucheObjekt(List.of("Gaia DR2 3252692330851198976", "WDS J04134-0139B"), StarObjectType.DOUBLE_STAR_REAL.getTypeName());
        this.helper.deletePlanetensucheObject("2MASS J20490993-4012062");
        this.helper.deletePlanetensucheObject("TIC 389426731");
        this.helper.deletePlanetensucheObject("UCAC3 100-409084");
        this.helper.deletePlanetensucheObject("UCAC4 249-180185");
        this.helper.addNamen("Gaia DR2 6678510081826546048", "2MASS J20490993-4012062");
        this.helper.addNamen("Gaia DR2 6678510081826546048", "TIC 389426731");
        this.helper.addNamen("Gaia DR2 6678510081826546048", "WDS J20492-4012AB");
        this.helper.deletePlanetensucheObject("HIP 102141 B");
        this.helper.addNamen("Zkh 312", "HIP 102141 B");
        this.helper.addNamen("AG+63 164", "2MASS J01474607+6350220");
        this.helper.addNamen("AG+63 164", "TIC 373694383");
        this.helper.addNamen("AG+63 164", "WDS J01477+6351B");
        this.helper.addNamen("AG+63 164", "Gaia DR2 512167948043662848");
        this.helper.deletePlanetensucheObject("2MASS J10475385+2124234");
        this.helper.deletePlanetensucheObject("WISEA J104752.35+212417.2");
        this.helper.addNamen("TIC 95838193", "2MASS J10475385+2124234");
        this.helper.deletePlanetensucheObject("2MASS J02431371-2453298");
        this.helper.deletePlanetensucheObject("WISEA J024313.47-245332.1");
        this.helper.deletePlanetensucheObject("WISE J024313.47-245331.9");
        this.helper.addNamen("TIC 65415207", "2MASS J02431371-2453298");
        this.helper.deletePlanetensucheObject("2MASS J15010818+2250020");
        this.helper.deletePlanetensucheObject("PLX 3391.01");
        this.helper.deletePlanetensucheObject("SDSS J150108.17+225001.8");
        this.helper.deletePlanetensucheObject("TIC 311188315");
        this.helper.deletePlanetensucheObject("USNO-B1.0 1128-00290573");
        this.helper.addNamen("Gaia DR2 1262763648230973440", "2MASS J15010818+2250020");
        this.helper.addNamen("Gaia DR2 1262763648230973440", "TIC 311188315");
        this.helper.deletePlanetensucheObject("Gaia DR2 5848753805085988352");
        this.helper.deletePlanetensucheObject("2MASS J14540797-6604476");
        this.helper.deletePlanetensucheObject("WISEA J145408.80-660451.2");
        this.helper.addNamen("TIC 259315924", "Gaia DR2 5848753805085988352");
        this.helper.addNamen("TIC 259315924", "2MASS J14540797-6604476");
        this.helper.addNamen("UCAC2 6537644", "TIC 464393953");
        this.helper.addNamen("UCAC2 6537644", "Gaia DR2 5255677056923564544");
        this.helper.addNamen("UCAC2 6537463", "TIC 464294590");
        this.helper.addNamen("UCAC2 6537463", "V712 Carinae");
        this.helper.addNamen("UCAC2 6537463", "Gaia DR2 5255678160756667776");
        this.helper.setStarObjectType("UCAC2 6537463", StarObjectType.ECLIPSING_BINARY);
        this.helper.addNamen("SU Ursae Majoris", "TIC 73247975");
        this.helper.addNamen("SU Ursae Majoris", "Gaia DR2 1091051096255456384");
        this.helper.deleteName("BDS 12115 A");
        this.helper.deletePlanetensucheObject("HIP 114110");
        this.helper.deleteName("CPD-63 3723B");
        this.helper.addNamen("GJ 601 B", "Gaia DR2 5826192135711183488");
        this.helper.addNamen("ADS 7494 B", "TIC 446127292");
        this.helper.addNamen("ADS 7494 B", "Gaia DR2 1022096388455816576");
        this.helper.addNamen("CD-51 11224", "TIC 409640093");
        this.helper.addNamen("CD-51 11224", "Gaia DR2 5945442413748166656");
        this.helper.addNamen("BD+38 315", "TIC 189626411");
        this.helper.addNamen("BD+38 315", "Gaia DR2 346855515807371520");
        this.helper.addNamen("GSC2 N23021204764", "Gaia DR2 936605992140011392");
        this.helper.addNamen("SDSS J140615.80+562725.9", "WD 1404+566");
        this.helper.addNamen("SDSS J140615.80+562725.9", "Gaia DR2 1657929394267851648");
        this.helper.addNamen("SDSS J140615.80+562725.9", "Gaia DR3 1657929398564495872");
        this.helper.addNamen("GJ 841 B", "TIC 140045537");
        this.helper.addNamen("GJ 841 B", "Gaia DR2 6558209044297239424");
        this.helper.addNamen("NLTT 9035", "LP 197-55");
        this.helper.addNamen("NLTT 9035", "Gaia DR2 337449812306056832");
        this.helper.addNamen("NLTT 57796", "LP 191-8");
        this.helper.addNamen("NLTT 57796", "Gaia DR2 1939308236730745472");
        this.helper.addNamen("BD-12 1172", "Gaia DR2 2985789113026163584");
        this.helper.addNamen("GSC 05653-00197", "Gaia DR2 4141505881131938560");
        this.helper.addNamen("BD-13 842", "TIC 332705938");
        this.helper.addNamen("BD-13 842", "Gaia DR2 3189152962633165056");
        this.helper.addNamen("BD+12 937B", "TIC 91690158");
        this.helper.addNamen("BD+12 937B", "Gaia DR2 3343243985350681728");
        this.helper.addNamen("ADS 2859 B", "TIC 94471001");
        this.helper.addNamen("ADS 2859 B", "Gaia DR2 168450545792008448");
        this.helper.addNamen("BD+18 2952a", "TIC 367679927");
        this.helper.addNamen("BD+18 2952a", "Gaia DR2 1188354130101035392");
        this.helper.addNamen("CCDM J12415-4858C", "TIC 161733431");
        this.helper.addNamen("CCDM J12415-4858C", "Gaia DR2 6127791473718388224");
        this.helper.addNamen("ADS 7555 C", "TIC 56558787");
        this.helper.addNamen("ADS 7555 C", "Gaia DR2 3771611580929954048");
        this.helper.addNamen("ADS 7555 B", "TYC 5475-1379-2");
        this.helper.addNamen("ADS 4334 C", "TIC 93280705");
        this.helper.addNamen("ADS 4334 C", "Gaia DR3 2964001637288852096");
        this.helper.addNamen("ADS 14702 C", "Gaia DR2 1744662655333070592");
        this.helper.addNamen("CCDM J17254-5623C", "TIC 325709804");
        this.helper.addNamen("CCDM J17254-5623C", "Gaia DR2 5922299377618521472");
        this.helper.addNamen("CCDM J17254-5623B", "TIC 325709808");
        this.helper.addNamen("CCDM J17254-5623B", "Gaia DR2 5922299416284639232");
        this.helper.addNamen("ADS 10022 C", "TIC 458724296");
        this.helper.addNamen("ADS 10022 C", "Gaia DR2 1201068229730858496");
        this.helper.addNamen("ADS 11581 B", "Gaia DR2 4155413809880317824");
        this.helper.deleteName("BD-09 4796C");
        this.helper.addNamen("ADS 11581 C", "TIC 162499919");
        this.helper.addNamen("ADS 11581 C", "Gaia DR2 4155413745531032448");
        this.helper.addNamen("ADS 9696 C", "TIC 159331744");
        this.helper.addNamen("ADS 9696 C", "Gaia DR2 1720992781328891520");
        this.helper.addNamen("ADS 16145 C", "TIC 240716828");
        this.helper.addNamen("ADS 16145 C", "Gaia DR2 2598528129740418176");
        this.helper.addNamen("ADS 16145 B", "Gaia DR2 2598528198459891840");
        this.helper.deletePlanetensucheObject("CCDM J20112-3605B");
        this.helper.addNamen("Zkh 302", "Gaia DR3 6697578465310948992");
        this.helper.addNamen("Zkh 302", "CCDM J20112-3605B");
        this.helper.addNamen("ADS 9446 D", "TIC 287157678");
        this.helper.addNamen("ADS 9446 D", "Gaia DR2 6232512912508474624");
        this.helper.addNamen("ADS 9446 C", "TIC 287157663");
        this.helper.addNamen("ADS 9446 C", "Gaia DR2 6232512809429256576");
        this.helper.addNamen("ADS 9446 E", "TIC 287157655");
        this.helper.addNamen("ADS 9446 E", "Gaia DR2 6232512706350038784");
        this.helper.deleteName("GJ 896 D");
        this.helper.addNamen("CCDM J23319+1956D", "TIC 247985098");
        this.helper.addNamen("CCDM J23319+1956D", "Gaia DR2 2824773640956502912");
        this.helper.deleteName("GJ 896 C");
        this.helper.addNamen("CCDM J23319+1956C", "TIC 247985097");
        this.helper.addNamen("CCDM J23319+1956C", "Gaia DR2 2824772163487753344");
        this.helper.addNamen("BD+45 2505C", "Gaia DR2 1364669027297994624");
        this.helper.addNamen("CCDM J04312+5858C", "TIC 356322666");
        this.helper.addNamen("CCDM J04312+5858C", "Gaia DR2 470827685226535936");
        this.helper.addNamen("CCDM J01080+5455P", "TIC 252191264");
        this.helper.addNamen("CCDM J01080+5455P", "WDS J01083+5455E");
        this.helper.addNamen("CCDM J01080+5455P", "Gaia DR2 411414646707978496");
        this.helper.deleteName("BD+54 223D");
        this.helper.addNamen("CCDM J01080+5455D", "TIC 252191203");
        this.helper.addNamen("CCDM J01080+5455D", "Gaia DR2 411414371830082560");
        this.helper.addNamen("CCDM J01080+5455C", "TIC 252191204");
        this.helper.addNamen("CCDM J01080+5455C", "Gaia DR2 411414371830082432");
        this.helper.setStarObjectType("CCDM J01080+5455C", StarObjectType.ECLIPSING_BINARY);
        this.helper.addNamen("GJ 127 B", "Gaia DR2 5059348952156075392");
        this.helper.addNamen("CD-35 2685", "TIC 160330442");
        this.helper.addNamen("CD-35 2685", "Gaia DR2 2886108660162391936");
        this.helper.addNamen("BSD 56-441", "TIC 4631260");
        this.helper.addNamen("BSD 56-441", "Gaia DR2 4007915531888812288");
        this.helper.addNamen("GJ 85.1", "TIC 63585149");
        this.helper.addNamen("GJ 85.1", "Gaia DR2 329448322594099072");
        this.helper.addNamen("LHS 1368", "TIC 63717351");
        this.helper.addNamen("LHS 1368", "Gaia DR2 324794605269408896");
        this.helper.addNamen("GJ 1099", "TIC 279859945");
        this.helper.addNamen("GJ 1099", "Gaia DR2 3134682194522547968");
        this.helper.addNamen("DO 41575", "TIC 64470952");
        this.helper.addNamen("DO 41575", "Gaia DR2 2200195820289135104");
        this.helper.addNamen("GJ 1059", "TIC 385048602");
        this.helper.addNamen("GJ 1059", "Gaia DR2 240945608019526272");
        this.helper.addNamen("GJ 3045", "TIC 240688842");
        this.helper.addNamen("GJ 3045", "Gaia DR2 415665118140313472");
        this.helper.addNamen("LP 415-26", "TIC 17308657");
        this.helper.addNamen("LP 415-26", "Gaia DR2 48191667661477120");
        this.helper.addNamen("G 125-18", "TIC 138104312");
        this.helper.addNamen("G 125-18", "Gaia DR2 2052469973468984192");
        this.helper.addNamen("LHS 5131", "TIC 171523647");
        this.helper.addNamen("LHS 5131", "Gaia DR2 876358870971624320");
        this.helper.addNamen("LHS 5131", "WDS J08005+2900A");
        this.helper.addNamen("LTT 5", "TIC 70744276");
        this.helper.addNamen("LTT 5", "Gaia DR2 2320815402647457536");
    }

    @Override
    public int updateToVersion() {
        return 116;
    }
}

