/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbankkern.impl.migration;

import de.planetensuche.datamodel.api.StarObjectType;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.impl.migration.DatabaseUpdater;
import de.planetensuche.datenbankkern.impl.migration.MigrationHelper;
import de.planetensuche.datenbankkern.querydsl5.Daten;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.sql.SQLException;
import java.util.List;

public final class Version117Migrator
implements DatabaseUpdater {
    private static final ILogging LOGGER = LoggingFactory.getLoggerForClass(Version117Migrator.class);
    private final IDatenbankverbinder datenbankverbinder;
    private final MigrationHelper helper;

    public Version117Migrator(IDatenbankverbinder iDatenbankverbinder) {
        this.datenbankverbinder = iDatenbankverbinder;
        this.helper = new MigrationHelper(iDatenbankverbinder);
    }

    @Override
    public void update() throws SQLException {
        LOGGER.debug("starting DB migration to Version " + this.updateToVersion());
        this.helper.createPlanetensucheObjekt(List.of("Gaia DR2 1824801659879180544"), StarObjectType.SINGLE_STAR.getTypeName());
        Daten daten = this.helper.readPlanetensucheObject("Gaia DR2 1824801659879180544");
        daten.setEntfernung(4.41164016);
        this.helper.updatePlanetensucheObjekt(daten);
        this.helper.createPlanetensucheObjekt(List.of("Gaia DR2 4062844895337938688", "Gaia DR3 4062844899488433152"), StarObjectType.SINGLE_STAR.getTypeName());
        daten = this.helper.readPlanetensucheObject("Gaia DR2 4062844895337938688");
        daten.setEntfernung(9.21467232);
        this.helper.updatePlanetensucheObjekt(daten);
        this.helper.createPlanetensucheObjekt(List.of("TIC 265274458", "Gaia DR2 2228101077501418240"), StarObjectType.ECLIPSING_BINARY.getTypeName());
        this.helper.addNamen("Delta02 Velorum", "TYC 8573-3571-2");
        this.helper.updateMkSystem("Delta02 Velorum", "F", 8.0, "V");
        this.helper.addNamen("G 179-43", "TIC 155970640");
        this.helper.addNamen("G 179-43", "Gaia DR2 1391241478857408768");
        daten = this.helper.readPlanetensucheObject("HIP 111172");
        if (daten != null) {
            daten.setEntfernung(253.8210116726568);
            this.helper.updatePlanetensucheObjekt(daten);
        }
        if ((daten = this.helper.readPlanetensucheObject("HD 197802")) != null) {
            daten.setEntfernung(261.5557337623944);
            this.helper.updatePlanetensucheObjekt(daten);
        }
        if ((daten = this.helper.readPlanetensucheObject("HIP 4934")) != null) {
            daten.setEntfernung(261.9759036158856);
            this.helper.updatePlanetensucheObjekt(daten);
        }
        this.helper.deletePlanetensucheObject("HIP 61910");
        this.helper.addNamen("HR 4822", "HIP 61910");
        this.helper.addNamen("HR 4822", "BD-12 3676");
        this.helper.deletePlanetensucheObject("WDS J09287+4536A");
        this.helper.addNamen("41 Lyncis A", "WDS J09287+4536A");
        this.helper.deletePlanetensucheObject("Gaia DR3 561897209694596992");
        this.helper.addNamen("HIP 8885", "Gaia DR3 561897209694596992");
        this.helper.deletePlanetensucheObject("WDS J13240-5253AB");
        this.helper.addNamen("HIP 65385", "WDS J13240-5253AB");
        this.helper.deletePlanetensucheObject("Gaia DR3 5224879500011370496");
        this.helper.addNamen("HIP 58490", "Gaia DR3 5224879500011370496");
        daten = this.helper.readPlanetensucheObject("Sonne");
        if (daten != null) {
            daten.setEntfernung(0.0);
            this.helper.updatePlanetensucheObjekt(daten);
        }
        this.helper.deletePlanetensucheObject("HIP 65679");
        this.helper.addNamen("TYC 8670-481-1", "WDS J13280-5806A");
        this.helper.addNamen("TYC 8670-481-1", "HD 116906A");
        this.helper.renameName("CCDM J13280-5806AB", "CCDM J13280-5806A");
        this.helper.addNamen("TYC 8670-481-2", "WDS J13280-5806B");
        this.helper.addNamen("TYC 8670-481-2", "HD 116906B");
        this.helper.addNamen("HIP 73626", "Gaia DR3 1161626445538992128");
        this.helper.deleteName("CCDM J11395-3726AB");
        this.helper.deletePlanetensucheObject("HIP 56863");
        this.helper.addNamen("HIP 56863 A", "HD 101327A");
        this.helper.addNamen("HIP 56863 B", "HD 101327B");
        this.helper.addNamen("HIP 56863 A", "WDS J11395-3726A");
        this.helper.addNamen("HIP 56863 B", "WDS J11395-3726B");
        this.helper.deletePlanetensucheObject("HD 11783");
        this.helper.deleteName("CCDM J00023-2708AB");
        this.helper.deletePlanetensucheObject("HIP 178");
        this.helper.addNamen("HIP 178 A", "HD 224989A");
        this.helper.addNamen("HIP 178 A", "WDS J00023-2708A");
        this.helper.addNamen("HIP 178 B", "HD 224989B");
        this.helper.addNamen("HIP 178 B", "WDS J00023-2708B");
        this.helper.deletePlanetensucheObject("HIP 81101");
        this.helper.addNamen("HIP 81101 A", "HD 149651A");
        this.helper.addNamen("HIP 81101 A", "WDS J16339+4717A");
        this.helper.addNamen("HIP 81101 B", "HD 149651B");
        this.helper.addNamen("HIP 81101 B", "WDS J16339+4717B");
        this.helper.deleteName("CCDM J17324-4638AB");
        this.helper.deletePlanetensucheObject("HIP 85836");
        this.helper.addNamen("HIP 85836 A", "HD 158585A");
        this.helper.addNamen("HIP 85836 A", "WDS J17324-4638A");
        this.helper.addNamen("HIP 85836 B", "HD 158585B");
        this.helper.addNamen("HIP 85836 B", "WDS J17324-4638B");
        this.helper.deletePlanetensucheObject("Rho Ophiuchi");
        this.helper.addNamen("Rho Ophiuchi A", "WDS J16256-2327A");
        this.helper.addNamen("Rho Ophiuchi B", "WDS J16256-2327B");
        this.helper.addNamen("Rho Ophiuchi B", "Gaia DR2 6050943410590451328");
        this.helper.deletePlanetensucheObject("HIP 81619");
        this.helper.deletePlanetensucheObject("Gaia DR3 6032514633650275840");
        this.helper.deletePlanetensucheObject("WDS J16402-2800AB");
        this.helper.deletePlanetensucheObject("HIP 87377");
        this.helper.deleteName("CCDM J17512+4455AB");
        this.helper.addNamen("HIP 87377 A", "HD 162880A");
        this.helper.addNamen("HIP 87377 A", "WDS J17512+4454A");
        this.helper.addNamen("HIP 87377 B", "HD 162880B");
        this.helper.addNamen("HIP 87377 B", "WDS J17512+4454B");
        this.helper.deletePlanetensucheObject("Gaia DR3 4326521359869384576");
        this.helper.deletePlanetensucheObject("V1121 Ophiuchi");
        this.helper.addNamen("HIP 82323", "V1121 Ophiuchi");
        this.helper.deletePlanetensucheObject("HIP 91832");
        this.helper.addNamen("HIP 91832 A", "HD 172494A");
        this.helper.addNamen("HIP 91832 A", "WDS J18434-5252A");
        this.helper.addNamen("HIP 91832 B", "HD 172494B");
        this.helper.addNamen("HIP 91832 B", "WDS J18434-5252B");
        this.helper.deletePlanetensucheObject("17 Draconis");
        this.helper.deletePlanetensucheObject("BD-17 5341");
        this.helper.addNamen("HIP 92492", "BDS 8843 B");
        this.helper.addNamen("HIP 92492", "WDS J18510-1747B");
        this.helper.deletePlanetensucheObject("HIP 48131");
        this.helper.deleteName("CCDM J09488-3501AB");
        this.helper.addNamen("HIP 48131 A", "HD 85100A");
        this.helper.addNamen("HIP 48131 A", "WDS J09488-3501A");
        this.helper.addNamen("HIP 48131 B", "HD 85100B");
        this.helper.addNamen("HIP 48131 B", "WDS J09488-3501B");
        this.helper.deletePlanetensucheObject("Gaia DR3 3499149202247569536");
        this.helper.deletePlanetensucheObject("LW Hydrae");
        this.helper.addNamen("HIP 62905", "LW Hydrae");
        this.helper.deleteName("14 Lyncis");
        this.helper.addNamen("14 Lyncis A", "WDS J06531+5927A");
        this.helper.renameName("WDS J06531+5927AB", "WDS J06531+5927B");
        this.helper.deletePlanetensucheObject("HIP 29608");
        this.helper.addNamen("HIP 29608 A", "HD 43579A");
        this.helper.addNamen("HIP 29608 A", "WDS J06144-4907A");
        this.helper.addNamen("HIP 29608 B", "HD 43579B");
        this.helper.addNamen("HIP 29608 B", "WDS J06144-4907B");
        this.helper.deletePlanetensucheObject("Gaia DR3 1530736690873640832");
        this.helper.deletePlanetensucheObject("WDS J12567+4537B");
        this.helper.addNamen("HIP 63190", "Gaia DR3 1530736690873640832");
        this.helper.addNamen("HIP 63190", "WDS J12567+4537B");
        this.helper.deletePlanetensucheObject("Gaia DR3 2748257114950150144");
        daten = this.helper.readPlanetensucheObject("HIP 53573");
        if (daten != null) {
            daten.setEntfernung(0.0);
            this.helper.updatePlanetensucheObjekt(daten);
        }
        this.helper.deletePlanetensucheObject("HIP 97809");
        this.helper.deleteName("CCDM J19525+0039AB");
        this.helper.addNamen("HIP 97809 A", "HD 187930A");
        this.helper.addNamen("HIP 97809 A", "WDS J19525+0039A");
        this.helper.addNamen("HIP 97809 B", "HD 187930B");
        this.helper.addNamen("HIP 97809 B", "WDS J19525+0039B");
        this.helper.deletePlanetensucheObject("Nu Geminorum");
        this.helper.addNamen("HIP 30883", "WDS J06290+2013A");
        this.helper.addNamen("HD 257937", "WDS J06290+2013B");
        this.helper.addNamen("HD 257937", "TIC 46943780");
        this.helper.deletePlanetensucheObject("HIP 29622");
        this.helper.addNamen("HIP 29622 A", "HD 43677A");
        this.helper.addNamen("HIP 29622 A", "WDS J06145-5305A");
        this.helper.addNamen("HIP 29622 B", "HD 43677B");
        this.helper.addNamen("HIP 29622 B", "WDS J06145-5305B");
        this.helper.deletePlanetensucheObject("HIP 92875");
        this.helper.deleteName("CCDM J18555+2914AB");
        this.helper.addNamen("HIP 92875 A", "BD+29 3399A");
        this.helper.addNamen("HIP 92875 A", "WDS J18555+2914A");
        this.helper.addNamen("HIP 92875 B", "BD+29 3399B");
        this.helper.addNamen("HIP 92875 B", "WDS J18555+2914B");
        this.helper.deletePlanetensucheObject("58 Ceti");
        this.helper.addNamen("58 Ceti A", "WDS J01580-0204A");
        this.helper.createPlanetensucheObjekt(List.of("TYC 4686-2532-2", "Gaia DR2 2505013291408658432", "WDS J01580-0204B", "HD 12020B"), StarObjectType.SINGLE_STAR.getTypeName());
        this.helper.deletePlanetensucheObject("HIP 47520");
        this.helper.deleteName("IDS 09377-5042 AB");
        this.helper.addNamen("HIP 47520 A", "HD 84120A");
        this.helper.addNamen("HIP 47520 A", "WDS J09413-5109A");
        this.helper.addNamen("HIP 47520 B", "HD 84120B");
        this.helper.addNamen("HIP 47520 B", "WDS J09413-5109B");
        this.helper.deletePlanetensucheObject("Lambda Scorpii");
        this.helper.addNamen("Lambda Scorpii A", "WDS J17336-3706A");
        this.helper.addNamen("Lambda Scorpii B", "WDS J17336-3706B");
        this.helper.deletePlanetensucheObject("DF Tauri A");
        this.helper.deleteName("DF Tauri B");
        this.helper.deletePlanetensucheObject("HIP 78146");
        this.helper.deleteName("CCDM J15575+4140AB");
        this.helper.addNamen("HIP 78146 A", "HD 143208A");
        this.helper.addNamen("HIP 78146 A", "WDS J15574+4140A");
        this.helper.addNamen("HIP 78146 B", "HD 143208B");
        this.helper.addNamen("HIP 78146 B", "WDS J15574+4140B");
        this.helper.deletePlanetensucheObject("1 Arietis");
        this.helper.addNamen("1 Arietis B", "Gaia DR2 98209860357332864");
        this.helper.deletePlanetensucheObject("HIP 4278");
        this.helper.deleteName("CCDM J00548+0926AB");
        this.helper.addNamen("HIP 4278 A", "HD 5280A");
        this.helper.addNamen("HIP 4278 A", "WDS J00548+0926A");
        this.helper.addNamen("HIP 4278 B", "HD 5280B");
        this.helper.addNamen("HIP 4278 B", "WDS J00548+0926B");
        this.helper.deletePlanetensucheObject("Gaia DR3 4609493459100758400");
        this.helper.deletePlanetensucheObject("HIP 10226");
        this.helper.deleteName("CCDM J02115-4920AB");
        this.helper.addNamen("HIP 10226 A", "HD 13618A");
        this.helper.addNamen("HIP 10226 A", "WDS J02115-4920A");
        this.helper.addNamen("HIP 10226 B", "HD 13618B");
        this.helper.addNamen("HIP 10226 B", "WDS J02115-4920B");
        this.helper.deletePlanetensucheObject("HIP 63231");
        this.helper.deleteName("CCDM J12574+3022AB");
        this.helper.addNamen("HIP 63231 A", "HD 112571A");
        this.helper.addNamen("HIP 63231 A", "WDS J12574+3022A");
        this.helper.addNamen("HIP 63231 B", "HD 112571B");
        this.helper.addNamen("HIP 63231 B", "WDS J12574+3022B");
        this.helper.deletePlanetensucheObject("HIP 81056");
        this.helper.deleteName("CCDM J16333+3855AB");
        this.helper.addNamen("HIP 81056 A", "BD+39 3011A");
        this.helper.addNamen("HIP 81056 A", "WDS J16333+3855A");
        this.helper.addNamen("HIP 81056 B", "BD+39 3011B");
        this.helper.addNamen("HIP 81056 B", "WDS J16333+3855B");
        this.helper.deletePlanetensucheObject("BD+44 1727");
        this.helper.addNamen("HIP 40441", "WDS J08155+4358A");
        this.helper.renameName("BD+44 1727a", "BD+44 1727A");
        this.helper.deletePlanetensucheObject("HIP 35960");
        this.helper.addNamen("HIP 35960 A", "WDS J07248-3717A");
        this.helper.addNamen("HIP 35960 B", "WDS J07248-3717B");
        this.helper.deletePlanetensucheObject("HIP 114536");
        this.helper.deleteName("CCDM J23120-1156AB");
        this.helper.addNamen("HIP 114536 A", "HD 218928A");
        this.helper.addNamen("HIP 114536 A", "WDS J23120-1156A");
        this.helper.addNamen("HIP 114536 B", "HD 218928B");
        this.helper.addNamen("HIP 114536 B", "WDS J23120-1156B");
        this.helper.deletePlanetensucheObject("HD 312644");
        this.helper.addNamen("TIC 184965038", "WDS J18072-1854B");
        this.helper.createPlanetensucheObjekt(List.of("TYC 6259-2107-3", "WDS J18072-1854C", "Gaia DR2 4095362921465891712", "HIP 88759", "HD 312644"), StarObjectType.DOUBLE_STAR_REAL.getTypeName());
        this.helper.deletePlanetensucheObject("Delta Orionis");
        this.helper.addNamen("CCDM J05320-0018B", "TIC 50743476");
        this.helper.addNamen("HR 1851", "TIC 50743458");
        this.helper.deletePlanetensucheObject("HIP 63767");
        this.helper.deleteName("IDS 12593+1956");
        this.helper.addNamen("HIP 63767 A", "HD 113527A");
        this.helper.addNamen("HIP 63767 A", "WDS J13042+1924A");
        this.helper.addNamen("HIP 63767 B", "HD 113527B");
        this.helper.addNamen("HIP 63767 B", "WDS J13042+1924B");
        this.helper.deletePlanetensucheObject("Gaia DR3 768250047300748288");
        this.helper.deleteName("HIP 39533");
        this.helper.deletePlanetensucheObject("Gaia DR3 932851782702639872");
        this.helper.deletePlanetensucheObject("HD 66263");
        this.helper.addNamen("HIP 39533 A", "HD 66263A");
        this.helper.addNamen("HIP 39533 B", "HD 66263B");
        this.helper.deletePlanetensucheObject("WDS J08047+4717AB");
        this.helper.addNamen("HIP 39533 A", "WDS J08047+4717A");
        this.helper.addNamen("HIP 39533 B", "WDS J08047+4717B");
        this.helper.deletePlanetensucheObject("HIP 68248");
        this.helper.deleteName("CCDM J13583-6538AB");
        this.helper.addNamen("HIP 68248 A", "HD 121544A");
        this.helper.addNamen("HIP 68248 A", "WDS J13583-6538A");
        this.helper.addNamen("HIP 68248 B", "HD 121544B");
        this.helper.addNamen("HIP 68248 B", "WDS J13583-6538B");
        this.helper.deletePlanetensucheObject("HIP 72832");
        this.helper.deleteName("CCDM J14532-6932AB");
        this.helper.addNamen("HIP 72832 A", "HD 130635A");
        this.helper.addNamen("HIP 72832 A", "WDS J14532-6932A");
        this.helper.addNamen("HIP 72832 B", "HD 130635B");
        this.helper.addNamen("HIP 72832 B", "WDS J14532-6932B");
        this.helper.deleteName("BD-05 4927B");
        this.helper.deletePlanetensucheObject("BD-05 4926");
        this.helper.addNamen("HIP 94856", "WDS J19181-0525B");
        this.helper.addNamen("HIP 94856", "BD-05 4926");
        this.helper.deletePlanetensucheObject("Lambda Orionis");
        this.helper.addNamen("Lambda Orionis B", "Gaia DR2 3337991583942616704");
        this.helper.deletePlanetensucheObject("HIP 50377");
        this.helper.deleteName("CCDM J10172-6636AB");
        this.helper.addNamen("HIP 50377 A", "HD 89465A");
        this.helper.addNamen("HIP 50377 A", "WDS J10172-6635A");
        this.helper.addNamen("HIP 50377 B", "HD 89465B");
        this.helper.addNamen("HIP 50377 B", "WDS J10172-6635B");
        this.helper.deletePlanetensucheObject("HIP 98369");
        this.helper.deleteName("CCDM J19591+3533AB");
        this.helper.addNamen("HIP 98369 A", "HD 189528A");
        this.helper.addNamen("HIP 98369 A", "WDS J19591+3532A");
        this.helper.addNamen("HIP 98369 B", "HD 189528B");
        this.helper.addNamen("HIP 98369 B", "WDS J19591+3532B");
        this.helper.deletePlanetensucheObject("HIP 34716");
        this.helper.deletePlanetensucheObject("WDS J07113-2148BC");
        this.helper.addNamen("Gaia DR2 2928252288031000320", "HIP 34716");
        this.helper.addNamen("Gaia DR2 2928252288031000320", "WDS J07113-2148BC");
        this.helper.addNamen("HIP 63447", "UCAC4 452-052185");
        daten = this.helper.readPlanetensucheObject("HIP 63447");
        if (daten != null) {
            daten.setEntfernung(0.0);
            this.helper.updatePlanetensucheObjekt(daten);
        }
        this.helper.deletePlanetensucheObject("HIP 19021");
        this.helper.deleteName("CCDM J04045+5545AB");
        this.helper.addNamen("HIP 19021 A", "HD 25337A");
        this.helper.addNamen("HIP 19021 A", "WDS J04045+5544A");
        this.helper.addNamen("HIP 19021 B", "HD 25337B");
        this.helper.addNamen("HIP 19021 B", "WDS J04045+5544B");
        this.helper.deletePlanetensucheObject("Gaia DR3 53795466114074368");
        this.helper.deletePlanetensucheObject("Gaia DR3 6292074655679874688");
        this.helper.deletePlanetensucheObject("HIP 35290");
        this.helper.deleteName("CCDM J07175-1843AB");
        this.helper.addNamen("HIP 35290 A", "HD 56727A");
        this.helper.addNamen("HIP 35290 A", "WDS J07174-1843A");
        this.helper.addNamen("HIP 35290 B", "HD 56727B");
        this.helper.addNamen("HIP 35290 B", "WDS J07174-1843B");
        this.helper.deletePlanetensucheObject("HIP 56878");
        this.helper.deleteName("IDS 11344+2731");
        this.helper.addNamen("HIP 56878 A", "HD 101320A");
        this.helper.addNamen("HIP 56878 A", "WDS J11396+2657A");
        this.helper.addNamen("HIP 56878 B", "HD 101320B");
        this.helper.addNamen("HIP 56878 B", "WDS J11396+2657B");
        this.helper.deletePlanetensucheObject("Gaia DR3 3226736469093461120");
        this.helper.deletePlanetensucheObject("Ypsilon Carinae");
        this.helper.addNamen("HR 3891", "Gaia DR2 5249119024124571136");
        this.helper.deletePlanetensucheObject("Gaia DR3 3958428334589607552");
        this.helper.deletePlanetensucheObject("HD 112313");
        this.helper.deletePlanetensucheObject("IN Comae Berenices");
        this.helper.addNamen("HIP 63087", "HD 112313");
        this.helper.addNamen("HIP 63087", "IN Comae Berenices");
        this.helper.deletePlanetensucheObject("HIP 84010");
        this.helper.deleteName("CCDM J17103-4644AB");
        this.helper.addNamen("HIP 84010 A", "HD 154873A");
        this.helper.addNamen("HIP 84010 A", "WDS J17103-4644A");
        this.helper.addNamen("HIP 84010 B", "HD 154873B");
        this.helper.addNamen("HIP 84010 B", "WDS J17103-4644B");
        this.helper.deletePlanetensucheObject("HIP 5583");
        this.helper.deleteName("CCDM J01116-4528AB");
        this.helper.addNamen("HIP 5583 A", "HD 7197A");
        this.helper.addNamen("HIP 5583 A", "WDS J01116-4528A");
        this.helper.addNamen("HIP 5583 B", "HD 7197B");
        this.helper.addNamen("HIP 5583 B", "WDS J01116-4528B");
        this.helper.deletePlanetensucheObject("Gaia DR3 5027175038609503360");
        this.helper.deletePlanetensucheObject("Gaia DR3 5878363481412711936");
        this.helper.deletePlanetensucheObject("WDS J14338-6124A");
        this.helper.addNamen("HIP 71228", "WDS J14338-6124A");
        this.helper.deletePlanetensucheObject("BD+42 4397");
        this.helper.deleteName("BD+42 4398C");
        this.helper.addNamen("HIP 110766", "BD+42 4397");
        this.helper.addNamen("HIP 110766", "WDS J22265+4332C");
        this.helper.deletePlanetensucheObject("U Aquilae A");
        this.helper.deletePlanetensucheObject("HIP 35391");
        this.helper.deleteName("CCDM J07186-3048AB");
        this.helper.addNamen("HIP 35391 A", "HD 57120A");
        this.helper.addNamen("HIP 35391 A", "WDS J07186-3048A");
        this.helper.addNamen("HIP 35391 B", "HD 57120B");
        this.helper.addNamen("HIP 35391 B", "WDS J07186-3048B");
        this.helper.deletePlanetensucheObject("Gaia DR3 5913709374299865216");
        this.helper.deletePlanetensucheObject("Gaia DR3 4517129500229625856");
        this.helper.deletePlanetensucheObject("Gaia DR3 3467219350218342656");
        this.helper.deletePlanetensucheObject("WDS J12008-3230A");
        this.helper.addNamen("HIP 58581", "WDS J12008-3230A");
        this.helper.deletePlanetensucheObject("WDS J14492-5924AB");
        this.helper.addNamen("HD 130206", "WDS J14492-5924AB");
        this.helper.addNamen("HD 130206", "SAO 242025");
        this.helper.addNamen("HD 130206", "CD-58 5801");
        this.helper.createPlanetensucheObjekt(List.of("WDS J14492-5924C", "TIC 194189309", "CD-58 5802", "SAO 242027"), StarObjectType.DOUBLE_STAR_OPTICAL.getTypeName());
        this.helper.deletePlanetensucheObject("HIP 30783");
        this.helper.deletePlanetensucheObject("Gaia DR3 5574196611895072512");
        this.helper.addNamen("TIC 119360117", "HIP 30783");
        this.helper.deletePlanetensucheObject("HD 140523");
        this.helper.deletePlanetensucheObject("Gaia DR3 2700089842703841536");
        this.helper.deletePlanetensucheObject("Gaia DR3 5920834381446704384");
        this.helper.deletePlanetensucheObject("Gaia DR3 528183090813390848");
        this.helper.deletePlanetensucheObject("Gaia DR3 468306779942552192");
        this.helper.deletePlanetensucheObject("HIP 83733");
        this.helper.deleteName("CCDM J17068-3553AB");
        this.helper.deletePlanetensucheObject("HD 154407");
        this.helper.deletePlanetensucheObject("WDS J17068-3553AB");
        this.helper.addNamen("HIP 83733 A", "HD 154407A");
        this.helper.addNamen("HIP 83733 B", "HD 154407B");
        this.helper.addNamen("HIP 83733 A", "WDS J17068-3553A");
        this.helper.addNamen("HIP 83733 B", "WDS J17068-3553B");
        this.helper.deletePlanetensucheObject("Gaia DR3 2178397693037492608");
        this.helper.deletePlanetensucheObject("WDS J21390+5729D");
        this.helper.addNamen("HIP 106884", "WDS J21390+5729D");
        this.helper.deletePlanetensucheObject("Gaia DR3 4874497923424781312");
        this.helper.deletePlanetensucheObject("HIP 120411");
        this.helper.addNamen("TIC 1233934", "HIP 120411");
        this.helper.deletePlanetensucheObject("Gaia DR3 528409143531333376");
        this.helper.deletePlanetensucheObject("Gaia DR3 182699318840513024");
        this.helper.deletePlanetensucheObject("Gaia DR1 182699318840513024");
        this.helper.deletePlanetensucheObject("WDS J05223+3348B");
        this.helper.addNamen("HIP 25093", "WDS J05223+3348B");
        this.helper.setStarObjectType("HIP 25093", StarObjectType.ECLIPSING_BINARY);
        this.helper.deletePlanetensucheObject("Gaia DR3 5937998243333783296");
        this.helper.deletePlanetensucheObject("WDS J17040-5105D");
        this.helper.deleteName("CD-50 10978D");
        this.helper.addNamen("HIP 83513", "WDS J17040-5105D");
        this.helper.deletePlanetensucheObject("HIP 17986");
        this.helper.deleteName("CCDM J03507+6007AB");
        this.helper.addNamen("HIP 17986 A", "HD 23726A");
        this.helper.addNamen("HIP 17986 A", "WDS J03507+6007A");
        this.helper.addNamen("HIP 17986 B", "HD 23726B");
        this.helper.addNamen("HIP 17986 B", "WDS J03507+6007B");
        this.helper.deletePlanetensucheObject("Gaia DR3 2178396937123252736");
        this.helper.deletePlanetensucheObject("WDS J21390+5729C");
        this.helper.addNamen("HIP 106890", "WDS J21390+5729C");
        this.helper.deletePlanetensucheObject("Gaia DR3 2128132243353007232");
        this.helper.addNamen("HIP 96538", "NGC 6811 106");
        this.helper.deletePlanetensucheObject("Gaia DR3 5999879788513847936");
        this.helper.deletePlanetensucheObject("Gaia DR3 2014109142339316096");
        this.helper.deletePlanetensucheObject("Gaia DR3 1736724009582675968");
        this.helper.deletePlanetensucheObject("Gaia DR3 4498570431128162688");
        this.helper.deletePlanetensucheObject("Gaia DR3 4256260466614300928");
        this.helper.deletePlanetensucheObject("Gaia DR3 493089909469573632");
        this.helper.deletePlanetensucheObject("UCAC4 184-061368");
        this.helper.deletePlanetensucheObject("WISE J104915.57-531906.1");
        this.helper.deletePlanetensucheObject("WISEA J104915.52-531906.1");
        this.helper.deletePlanetensucheObject("WISE J104915.57-531906A");
        this.helper.deletePlanetensucheObject("WISE J104915.57-531906B");
        this.helper.deletePlanetensucheObject("Gaia DR3 2059076148587293696");
        this.helper.deletePlanetensucheObject("WDS J20060+3547D");
        this.helper.deletePlanetensucheObject("Gaia DR3 1730390891326220672");
        this.helper.deletePlanetensucheObject("Gaia DR3 459365448308247552");
        this.helper.deletePlanetensucheObject("Gaia DR3 4530814090658118656");
        this.helper.deletePlanetensucheObject("HD 349423");
        this.helper.addNamen("HIP 92400", "HD 349423");
        this.helper.deletePlanetensucheObject("Gaia DR3 5338509937981912576");
        this.helper.deletePlanetensucheObject("HD 96261B");
        this.helper.deletePlanetensucheObject("WDS J11051-5943B");
        this.helper.addNamen("HIP 54181", "HD 96261B");
        this.helper.addNamen("HIP 54181", "WDS J11051-5943B");
        this.helper.deletePlanetensucheObject("Gaia DR3 514872025095936512");
        this.helper.deletePlanetensucheObject("Gaia DR3 3448131343028451072");
        this.helper.deletePlanetensucheObject("WDS J05444+3210AB");
        this.helper.addNamen("HIP 27066", "WDS J05444+3210AB");
        this.helper.deletePlanetensucheObject("Gaia DR3 4232672987259603968");
        this.helper.deletePlanetensucheObject("Gaia DR3 465645515129855872");
        this.helper.deletePlanetensucheObject("V615 Cassiopeiae");
        this.helper.addNamen("HIP 12469", "V615 Cassiopeiae");
        this.helper.deletePlanetensucheObject("Gaia DR3 464147018218589056");
        this.helper.deletePlanetensucheObject("Gaia DR3 5337283948144897664");
        this.helper.deletePlanetensucheObject("Gaia DR3 2759267418233392640");
        this.helper.deletePlanetensucheObject("Gaia DR3 6217210111536223872");
        this.helper.deletePlanetensucheObject("Gaia DR1 509862474025364864");
        this.helper.deletePlanetensucheObject("V1123 Cassiopeiae");
        this.helper.addNamen("HIP 7238", "NGC 581 42");
        this.helper.addNamen("HIP 7238", "V1123 Cassiopeiae");
        this.helper.deletePlanetensucheObject("Gaia DR3 508753277248724864");
        this.helper.deletePlanetensucheObject("Gaia DR3 2011951763086676352");
        this.helper.deletePlanetensucheObject("Gaia DR3 4049331244394134912");
        this.helper.deletePlanetensucheObject("HD 167362");
        this.helper.addNamen("HIP 89535", "HD 167362");
        this.helper.deletePlanetensucheObject("Gaia DR3 509677829088466048");
        this.helper.deletePlanetensucheObject("Gaia DR3 2167668688623855232");
        this.helper.deletePlanetensucheObject("BDS 10397 B");
        this.helper.deletePlanetensucheObject("WDS J20379+4757B");
        this.helper.addNamen("HIP 101807", "BDS 10397 B");
        this.helper.addNamen("HIP 101807", "WDS J20379+4757B");
        this.helper.deletePlanetensucheObject("Gaia DR3 2699523632871124736");
        this.helper.setStarObjectType("HIP 106832", StarObjectType.DOUBLE_STAR_REAL);
        this.helper.deletePlanetensucheObject("Gaia DR3 528066641362242688");
        this.helper.deletePlanetensucheObject("Gaia DR3 2027892212121136128");
        this.helper.deletePlanetensucheObject("Gaia DR3 509979507594269952");
        this.helper.addNamen("HIP 7416", "Tr 1 1133");
        this.helper.deletePlanetensucheObject("Gaia DR3 2011892084529086848");
        this.helper.deletePlanetensucheObject("Gaia DR3 2012423247417638400");
        this.helper.deletePlanetensucheObject("Gaia DR3 422138527212598528");
        this.helper.setStarObjectType("GJ 866 A", StarObjectType.MULTI_STAR_SYSTEM);
        this.helper.deletePlanetensucheObject("Gaia DR3 2198646161734895360");
        this.helper.addNamen("HIP 109603", "NGC 7235 2");
        this.helper.deletePlanetensucheObject("Gaia DR3 1533367925276710272");
        this.helper.deletePlanetensucheObject("Gaia DR3 5640106561553155072");
        this.helper.setStarObjectType("HIP 42014", StarObjectType.VARIABLE_LONG_PERIOD);
        this.helper.deletePlanetensucheObject("Gaia DR3 1987715679258222976");
        this.helper.deletePlanetensucheObject("WDS J22243+4850AB");
        this.helper.addNamen("HIP 110595", "WDS J22243+4850AB");
        this.helper.deletePlanetensucheObject("Gaia DR3 6701965825948059136");
        this.helper.deletePlanetensucheObject("WDS J18207-5203A");
        this.helper.addNamen("HIP 89903", "WDS J18207-5203A");
        this.helper.deletePlanetensucheObject("Gaia DR3 4258284534415364224");
        this.helper.addNamen("HIP 92536", "2MASS J18512671+0351234");
        this.helper.deletePlanetensucheObject("WISE J072227.27-054029.9");
        this.helper.addNamen("UGPS J072227.51-054031.2", "WISE J072227.27-054029.9");
        this.helper.deletePlanetensucheObject("USNO-B1.0 0500-00227632");
        this.helper.deletePlanetensucheObject("WISEA J104813.47-395617.3");
        this.helper.addNamen("LHS 1850", "WDS J06293-0248B");
        this.helper.deletePlanetensucheObject("Gaia DR3 3437721136875257472");
        this.helper.deletePlanetensucheObject("Gaia DR3 444707755718683392");
        this.helper.addNamen("Zkh 180", "WDS J12335+0901B");
        this.helper.renameName("WDS J12335+0901AB", "WDS J12335+0901A");
        this.helper.addNamen("Zkh 179", "Mel 25 EGG 43");
        this.helper.setStarObjectType("Zkh 179", StarObjectType.DOUBLE_STAR_REAL);
        this.helper.addNamen("G 41-14A", "WDS J08589+0829A");
        this.helper.addNamen("G 41-14A", "GJ 3522 A");
        this.helper.addNamen("G 41-14A", "Gaia DR3 585250252550906624");
        this.helper.addNamen("G 41-14B", "WDS J08589+0829B");
        this.helper.addNamen("G 41-14B", "GJ 3522 B");
        this.helper.addNamen("G 41-14B", "Gaia DR3 585250248258396416");
        this.helper.renameName("LHS 3494 b", "LHS 3494B");
        this.helper.deleteName("CCDM J10196+1952A");
        this.helper.addNamen("AD Leonis", "TIC 95431305");
        this.helper.addNamen("AD Leonis", "8pc 204.60");
        this.helper.deletePlanetensucheObject("WISEA J025504.75-470057.3");
        this.helper.deletePlanetensucheObject("Gaia DR3 468734073350010496");
        this.helper.deletePlanetensucheObject("TIC 67772873");
        this.helper.addNamen("40 Eridani C", "TIC 67772873");
        this.helper.addNamen("40 Eridani C", "2MASS J04152173-0739173");
        this.helper.addNamen("40 Eridani C", "8pc 198.24C");
        this.helper.addNamen("40 Eridani C", "CCDM J04153-0739C");
        this.helper.addNamen("40 Eridani C", "Gaia DR2 3195919322830293760");
        this.helper.addNamen("40 Eridani C", "Omikron02 Eridani C");
        this.helper.addNamen("40 Eridani C", "STF 518C");
        this.helper.addNamen("40 Eridani C", "WDS J04153-0739C");
        this.helper.addNamen("40 Eridani C", "WEB 3796");
        this.helper.deletePlanetensucheObject("BD+02 3482C");
        this.helper.deletePlanetensucheObject("Gaia DR3 2012912500041834752");
        this.helper.addNamen("2MASS J08581519+1945470", "TIC 197251248");
        this.helper.renameName("WDS J08582+1945AB", "WDS J08582+1945A");
        this.helper.deletePlanetensucheObject("Gaia DR3 3344973478481675264");
        this.helper.deletePlanetensucheObject("V1308 Orionis");
        this.helper.addNamen("TIC 437994564", "V1308 Orionis");
        this.helper.addNamen("GJ 1005 B", "WDS J00155-1608B");
        this.helper.addNamen("GJ 1005 B", "CCDM J00155-1608B");
        this.helper.renameName("CCDM J00155-1608AB", "CCDM J00155-1608A");
        this.helper.deleteName("2MASS J00152799-1608008 A");
        this.helper.renameName("WDS J00155-1608AB", "WDS J00155-1608A");
        this.helper.addNamen("HIP 57146", "2MASS J11431189-3925575");
        this.helper.addNamen("HIP 57146", "WDS J11432-3926BC");
        this.helper.deletePlanetensucheObject("USNO-B1.0 1229-00376318");
        this.helper.deletePlanetensucheObject("LSPM J1835+3259");
        this.helper.deletePlanetensucheObject("WISEA J191657.19+050847.2");
        this.helper.deletePlanetensucheObject("CSV 102917");
        this.helper.deletePlanetensucheObject("LDS 6334B");
        this.helper.deletePlanetensucheObject("CSI+04 4048 2");
        this.helper.deletePlanetensucheObject("USNO 885");
        this.helper.deletePlanetensucheObject("UBV 16317");
        this.helper.deletePlanetensucheObject("WISE J191657.20+050847.6");
        this.helper.deletePlanetensucheObject("CCDM J19169+0510B");
        this.helper.deletePlanetensucheObject("LSPM J1916+0509");
        this.helper.deletePlanetensucheObject("USNO-B1.0 0951-00432259");
        this.helper.deletePlanetensucheObject("8pc 170.26B");
        this.helper.addNamen("Zkh 289", "8pc 170.26B");
        this.helper.addNamen("Zkh 244", "TIC 1277142191");
        this.helper.deleteName("2MASS J17152095-2636064 B");
        this.helper.deleteName("2MASS J17152095-2636064");
        this.helper.deleteName("36 Ophiuchi");
        this.helper.deleteName("IDS 17092-2627 AB");
        this.helper.renameName("TIC 79454735", "TIC 1277142190");
        this.helper.deleteName("HIP 84405");
        this.helper.addNamen("Zkh 244", "HIP 84405 A");
        this.helper.addNamen("Zkh 245", "HIP 84405 B");
        this.helper.addNamen("8pc 162.00B", "WDS J07364+0705B");
        this.helper.renameName("WDS J07364+0705AB", "WDS J07364+0705A");
        this.helper.deletePlanetensucheObject("Zkh 349");
        this.helper.addNamen("EQ Pegasi A", "Zkh 349");
        this.helper.addNamen("EQ Pegasi A", "LFT 1799");
        this.helper.addNamen("Zkh 100", "HIP 34603 B");
        this.helper.addNamen("Zkh 99", "Mel 25 EGG 27");
        this.helper.renameName("HIP 34603", "HIP 34603 A");
        this.helper.addNamen("Zkh 100", "8pc 157.24B");
        this.helper.deletePlanetensucheObject("GJ 644");
        this.helper.deletePlanetensucheObject("HIP 82817 A");
        this.helper.addNamen("GJ 644 A", "V1054 Ophiuchi A");
        this.helper.addNamen("GJ 644 A", "HIP 82817 A");
        this.helper.addNamen("GJ 644 A", "TIC 181589861");
        this.helper.addNamen("GJ 644 A", "HD 152751A");
        this.helper.addNamen("GJ 644 A", "WDS J16555-0820A");
        this.helper.addNamen("GJ 644 B", "V1054 Ophiuchi B");
        this.helper.addNamen("GJ 644 B", "HIP 82817 B");
        this.helper.addNamen("GJ 644 B", "HD 152751B");
        this.helper.addNamen("GJ 644 B", "WDS J16555-0820B");
        this.helper.deletePlanetensucheObject("PM 16529-0818");
        this.helper.deletePlanetensucheObject("CSI-08-16529");
        this.helper.deletePlanetensucheObject("WDS J12179+1627AB");
        this.helper.deleteName("IDS 14468+1931 AB");
        this.helper.deletePlanetensucheObject("HIP 72659 A");
        this.helper.deletePlanetensucheObject("WISEA J151459.85+484756.7");
        this.helper.deletePlanetensucheObject("SDSS J151500.62+484744.8");
        this.helper.deletePlanetensucheObject("Gaia DR3 1990060353443655808");
        this.helper.deletePlanetensucheObject("V442 Lacertae");
        this.helper.addNamen("HIP 112887", "V442 Lacertae");
        this.helper.addNamen("Zkh 252", "TYC 7370-850-2");
        this.helper.deleteName("GJ 661 AB");
        this.helper.deleteName("CCDM J17121+4540AB");
        this.helper.deletePlanetensucheObject("Zkh 242");
        this.helper.addNamen("HIP 84140 A", "Zkh 242");
        this.helper.addNamen("HIP 84140 A", "GJ 661 A");
        this.helper.addNamen("HIP 84140 A", "Gaia DR3 1364668825433448704");
        this.helper.addNamen("HIP 84140 A", "WDS J17121+4540A");
        this.helper.addNamen("HIP 84140 A", "BD+45 2505");
        this.helper.addNamen("HIP 84140 A", "LFT 1326");
        this.helper.addNamen("HIP 84140 A", "LHS 433");
        this.helper.addNamen("HIP 84140 A", "LTT 15095");
        this.helper.addNamen("HIP 84140 A", "NLTT 44362");
        this.helper.renameName("HD 155876 A", "HD 155876A");
        this.helper.deletePlanetensucheObject("HIP 84140 B");
        this.helper.addNamen("GJ 661 B", "Gaia DR3 1364668825433435776");
        this.helper.addNamen("GJ 661 B", "HIP 84140 B");
        this.helper.addNamen("GJ 661 B", "TIC 471012596");
        this.helper.addNamen("GJ 661 B", "WDS J17121+4540B");
        this.helper.addNamen("GJ 661 B", "HD 155876B");
        this.helper.deletePlanetensucheObject("Gaia DR3 4638467544702324864");
        this.helper.deletePlanetensucheObject("CCDM J03019-1635BC");
        this.helper.deletePlanetensucheObject("PM J03018-1635B");
        this.helper.addNamen("Zkh 45", "HD 16160B");
        this.helper.addNamen("Zkh 45", "WDS J02361+0653B");
        this.helper.addNamen("G 203-47B", "GJ 3991 B");
        this.helper.renameName("GJ 3991", "GJ 3991 A");
        this.helper.deleteName("2MUCD 10019");
        this.helper.deleteName("LHS 1070 b");
        this.helper.addNamen("GJ 2005 B", "WDS J00247-2653B");
        this.helper.deleteName("GJ 2005");
        this.helper.addNamen("GJ 2005 A", "WDS J00247-2653A");
        this.helper.addNamen("GJ 2005 C", "WDS J00247-2653C");
        this.helper.deletePlanetensucheObject("GJ 2005 D");
        this.helper.deleteName("CCDM J01080+5455B");
        this.helper.addNamen("GJ 53 A", "CSI+54 223 1");
        this.helper.addNamen("GJ 53 B", "CSI+54 223 2");
        this.helper.deleteName("BD+54 223B");
        this.helper.createPlanetensucheObjekt(List.of("TYC 3673-194-1", "CCDM J01080+5455B", "TIC 252187462", "WDS J01083+5455B"), StarObjectType.DOUBLE_STAR_OPTICAL.getTypeName());
        this.helper.deleteName("VVO 130");
        this.helper.addNamen("GJ 185 B", "Gaia DR3 2974726136265625088");
        this.helper.addNamen("GJ 185 B", "WDS J05025-2115B");
        this.helper.addNamen("GJ 185 B", "TYC 5912-481-2");
        this.helper.addNamen("GJ 185 B", "HIP 23452 B");
        this.helper.deleteName("HIP 23452");
        this.helper.deleteName("WDS J05025-2115AB");
        this.helper.deleteName("IDS 04582-2124 AB");
        this.helper.deleteName("HD 32450 AB");
        this.helper.deleteName("CCDM J05025-2115AB");
        this.helper.deletePlanetensucheObject("GJ 185 A");
        this.helper.renameName("HD 32450", "HD 32450A");
        this.helper.addNamen("HD 32450A", "GJ 185 A");
        this.helper.addNamen("GJ 185 A", "Gaia DR3 2974726131970829952");
        this.helper.addNamen("GJ 185 A", "WDS J05025-2115A");
        this.helper.addNamen("GJ 185 A", "TYC 5912-481-1");
        this.helper.addNamen("GJ 185 A", "Zkh 67");
        this.helper.addNamen("GJ 185 A", "8pc 129.40A");
        this.helper.addNamen("GJ 185 A", "VVO 129");
        this.helper.deletePlanetensucheObject("1RXS J044652.0-111658");
        this.helper.deletePlanetensucheObject("PM J04468-1116");
        this.helper.deletePlanetensucheObject("USNO-B1.0 0787-00048124");
        this.helper.deletePlanetensucheObject("HIP 33499 A");
        this.helper.deletePlanetensucheObject("CSI-44 3045 22");
        this.helper.renameName("WDS J06579-4417AB", "WDS J06579-4417A");
        this.helper.deleteName("IDS 06549-4409 AB");
        this.helper.renameName("CD-44 3045", "CD-44 3045A");
        this.helper.addNamen("CCDM J16240+4821B", "Gaia DR2 1411180194514214272");
        this.helper.addNamen("CCDM J16240+4821B", "TIC 162673757");
        this.helper.addNamen("CCDM J16240+4821B", "Gaia DR3 1411180194514214272");
        this.helper.deletePlanetensucheObject("2MASS J21481628+4003593");
        this.helper.addNamen("TIC 305387751", "2MASS J21481628+4003593");
        this.helper.addNamen("GJ 747 B", "CSI+32 3326 5");
        this.helper.addNamen("GJ 747 B", "ADS 12061 D");
        this.helper.renameName("ADS 12061 CD", "ADS 12061 C");
        this.helper.deleteName("CCDM J19075+3231HI");
        this.helper.addNamen("GJ 423 D", "WEB 9946");
        this.helper.deleteName("ADS 10786 C");
        this.helper.addNamen("GJ 695 C", "WDS J17465+2743C");
        this.helper.addNamen("GJ 695 C", "Gaia DR3 4594497838483177984");
        this.helper.addNamen("GJ 618 B", "TIC 3657908");
        this.helper.addNamen("GJ 618 B", "WDS J16202-3734B");
        this.helper.deletePlanetensucheObject("WISEA J031326.00+780744.3");
        this.helper.addNamen("WISE J031325.94+780744.3", "WISEA J031326.00+780744.3");
        this.helper.deleteName("2MASS J05542300+2016344 A");
        this.helper.renameName("CCDM J05544+2017AB", "CCDM J05544+2017A");
        this.helper.addNamen("Zkh 79", "CCDM J05544+2017B");
        this.helper.renameName("WDS J05544+2017AB", "WDS J05544+2017A");
        this.helper.addNamen("Zkh 79", "WDS J05544+2017B");
        this.helper.addNamen("LHS 1952", "WDS J07519+0001B");
        this.helper.addNamen("GJ 666 C", "TIC 217005900");
        this.helper.deletePlanetensucheObject("CCDM J17191-4638C");
        this.helper.addNamen("GJ 666 C", "CCDM J17191-4638C");
        this.helper.addNamen("GJ 666 C", "CD-46 11370C");
        this.helper.addNamen("Zkh 250", "Gaia DR2 5951165857153490432");
        this.helper.addNamen("Zkh 250", "CCDM J17191-4638D");
        this.helper.deleteName("WDS J20298+0941AB");
        this.helper.deleteName("CCDM J20298+0941AB");
        this.helper.addNamen("Zkh 306", "WDS J20298+0941A");
        this.helper.addNamen("Zkh 307", "WDS J20298+0941B");
        this.helper.addNamen("ADS 4334 B", "TIC 93279196");
        this.helper.addNamen("Zkh 76", "TIC 93331588");
        this.helper.addNamen("Zkh 199", "TYC 3460-2162-2");
        this.helper.deletePlanetensucheObject("WDS J14164+1348B");
        this.helper.addNamen("WISE J141623.93+134836.0", "WDS J14164+1348B");
        this.helper.deletePlanetensucheObject("WISE J020529.68-115929.1");
        this.helper.addNamen("TIC 257504474", "WISE J020529.68-115929.1");
        this.helper.deletePlanetensucheObject("WISEA J180435.37+311706.2");
        this.helper.addNamen("WISE J180435.37+311706.4", "WISEA J180435.37+311706.2");
        this.helper.deletePlanetensucheObject("1RXS J041325.8-013919");
        this.helper.deletePlanetensucheObject("WISEA J041326.72-013921.2");
        this.helper.deletePlanetensucheObject("GJ 508 AB");
        this.helper.renameName("HIP 65026 A", "HIP 65026 B");
        this.helper.addNamen("GJ 508 A", "SAO 44566");
        this.helper.addNamen("GJ 508 A", "GCRV 7920");
        this.helper.addNamen("GJ 508 A", "HIP 65026 A");
        this.helper.addNamen("GJ 508 A", "TIC 393894049");
        this.helper.addNamen("GJ 508 A", "WEB 11489");
        this.helper.addNamen("GJ 508 A", "TYC 3460-2162-1");
        this.helper.addNamen("GJ 508 B", "TYC 3460-2162-2");
        this.helper.deletePlanetensucheObject("SCR J2049-4012");
        this.helper.addNamen("TIC 389426731", "SCR J2049-4012");
        daten = this.helper.readPlanetensucheObject("HIP 31500");
        if (daten != null) {
            daten.setEntfernung(0.0);
            this.helper.updatePlanetensucheObjekt(daten);
        }
        this.helper.deletePlanetensucheObject("GJ 569 Ba");
        this.helper.deletePlanetensucheObject("GJ 569 Bb");
        this.helper.deletePlanetensucheObject("WISEA J161441.47+173935.4");
        this.helper.addNamen("WISE J161441.46+173935.5", "WISEA J161441.47+173935.4");
        this.helper.deletePlanetensucheObject("Gaia DR3 4689033539046230400");
        this.helper.deletePlanetensucheObject("HIP 46706 A");
        this.helper.addNamen("GJ 352 B", "WDS J09313-1329B");
        this.helper.addNamen("GJ 352 B", "Gaia DR3 5690033426054600320");
        this.helper.renameName("CCDM J09313-1329AB", "CCDM J09313-1329A");
        this.helper.deleteName("IDS 09265-1303 AB");
        this.helper.addNamen("GJ 352 A", "Gaia DR3 5690031948585514368");
        this.helper.renameName("ADS 440 AC", "ADS 440 A");
        this.helper.deleteName("TIC 420470815");
        this.helper.addNamen("Zkh 11", "TIC 420470815");
        this.helper.addNamen("Zkh 10", "TIC 420470817");
        this.helper.addNamen("Zkh 12", "TIC 608170820");
        this.helper.deletePlanetensucheObject("HIP 2552 A");
        this.helper.addNamen("HD 43834B", "WDS J06102-7445B");
        this.helper.addNamen("HD 43834B", "Gaia DR2 5264749303457104384");
        this.helper.deletePlanetensucheObject("HIP 72896 A");
        this.helper.addNamen("G 272-10", "TIC 32550424");
        this.helper.addNamen("GJ 352 B", "WDS J09313-1329B");
        this.helper.addNamen("GJ 352 B", "Gaia DR3 5690033426054600320");
        this.helper.addNamen("GJ 766 B", "2MASS J19454548+2707318 B");
        this.helper.deletePlanetensucheObject("ADS 3266 B");
        this.helper.addNamen("TIC 449050247", "ADS 3266 B");
        this.helper.addNamen("TIC 449050247", "CCDM J04302+0518B");
        this.helper.addNamen("TIC 449050247", "PPM 147611");
        this.helper.addNamen("TIC 449050247", "WDS J04302+0518B");
        this.helper.createPlanetensucheObjekt(List.of("NLTT 8406", "L 225-57", "TIC 166788138"), StarObjectType.SINGLE_STAR.getTypeName());
        this.helper.updateMkSystem("L 225-57", "M", 4.0, "V");
        daten = this.helper.readPlanetensucheObject("L 225-57");
        daten.setEntfernung(65.12077944);
        this.helper.updatePlanetensucheObjekt(daten);
    }

    @Override
    public int updateToVersion() {
        return 117;
    }
}

