/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbankkern.impl.migration;

import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.impl.migration.DatabaseUpdater;
import de.planetensuche.datenbankkern.impl.migration.MigrationHelper;
import de.planetensuche.datenbankkern.querydsl5.Daten;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.sql.SQLException;

public final class Version118Migrator
implements DatabaseUpdater {
    private static final ILogging LOGGER = LoggingFactory.getLoggerForClass(Version118Migrator.class);
    private final IDatenbankverbinder datenbankverbinder;
    private final MigrationHelper helper;

    public Version118Migrator(IDatenbankverbinder iDatenbankverbinder) {
        this.datenbankverbinder = iDatenbankverbinder;
        this.helper = new MigrationHelper(iDatenbankverbinder);
    }

    @Override
    public void update() throws SQLException {
        LOGGER.debug("starting DB migration to Version " + this.updateToVersion());
        Daten daten = this.helper.readPlanetensucheObject("HD 114762 b");
        if (daten != null) {
            daten.setMasse(107.0);
            this.helper.updatePlanetensucheObjekt(daten);
            this.helper.setBrownDwarfObjectType("HD 114762 b");
        }
        if ((daten = this.helper.readPlanetensucheObject("Kepler-503 b")) != null) {
            daten.setMasse(78.6);
            daten.setDurchmesser(96.0);
            this.helper.updatePlanetensucheObjekt(daten);
            this.helper.setBrownDwarfObjectType("Kepler-503 b");
        }
        if ((daten = this.helper.readPlanetensucheObject("HW Virginis c")) != null) {
            daten.setMasse(65.0);
            this.helper.updatePlanetensucheObjekt(daten);
            this.helper.setBrownDwarfObjectType("HW Virginis c");
        }
        this.helper.deletePlanetensucheObject("GJ 581 f");
        this.helper.deletePlanetensucheObject("HD 73256 b");
        this.helper.deletePlanetensucheObject("Alpha Piscis Austrini b");
        this.helper.deletePlanetensucheObject("UZ Fornacis d");
        this.helper.deletePlanetensucheObject("HD 131399 A b");
        this.helper.setzeAufUnbestaetigt("GJ 667 C d");
        this.helper.setzeAufUnbestaetigt("GJ 1151 b");
        this.helper.setzeAufUnbestaetigt("GJ 9066 b");
        this.helper.setzeAufUnbestaetigt("Kepler-699 b");
        this.helper.setzeAufUnbestaetigt("Kepler-840 b");
        this.helper.setzeAufUnbestaetigt("Kepler-854 b");
        this.helper.setzeAufUnbestaetigt("Kepler-486 b");
        this.helper.setzeAufUnbestaetigt("HD 122430 b");
        this.helper.setzeAufUnbestaetigt("HD 47536 c");
        this.helper.setzeAufUnbestaetigt("HD 74156 d");
        this.helper.setzeAufUnbestaetigt("NGC 4349 127 b");
        this.helper.setzeAufUnbestaetigt("BD+20 1790 b");
        this.helper.setzeAufUnbestaetigt("Gl 581 d");
        this.helper.setzeAufUnbestaetigt("GJ 581 g");
        this.helper.setzeAufUnbestaetigt("Alpha Centauri B b");
        this.helper.setzeAufUnbestaetigt("GJ 832 c");
        this.helper.setzeAufUnbestaetigt("TOI-561 f");
    }

    @Override
    public int updateToVersion() {
        return 118;
    }
}

