/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbankkern.impl.migration;

import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLDeleteClause;
import de.planetensuche.datamodel.api.StarObjectType;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.api.repos.EntdeckerProjekte;
import de.planetensuche.datenbankkern.api.repos.EntdeckerWeltraumteleskope;
import de.planetensuche.datenbankkern.impl.migration.DatabaseUpdater;
import de.planetensuche.datenbankkern.impl.migration.MigrationHelper;
import de.planetensuche.datenbankkern.querydsl5.QNamen;
import de.planetensuche.datenbankkern.querydsl5.QZtentdecker;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.sql.SQLException;
import java.util.List;

public final class Version119Migrator
implements DatabaseUpdater {
    private static final ILogging LOGGER = LoggingFactory.getLoggerForClass(Version119Migrator.class);
    private final IDatenbankverbinder datenbankverbinder;
    private final MigrationHelper helper;

    public Version119Migrator(IDatenbankverbinder iDatenbankverbinder) {
        this.datenbankverbinder = iDatenbankverbinder;
        this.helper = new MigrationHelper(iDatenbankverbinder);
    }

    @Override
    public void update() throws SQLException {
        LOGGER.debug("starting DB migration to Version " + this.updateToVersion());
        this.helper.setStarObjectType("51 Pegasi", StarObjectType.SINGLE_STAR);
        this.helper.addPlanetsToSpaceTelescope(EntdeckerWeltraumteleskope.HUBBLE, "", List.of("PSR B1620-26 b"));
        this.helper.addPlanetsToSpaceTelescope(EntdeckerWeltraumteleskope.SPITZER, "", List.of("FU Tauri b", "HN Pegasi b"));
        QNamen qNamen = QNamen.namen1;
        Integer n = (Integer)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qNamen.datenid).from((Expression<?>)qNamen)).where(qNamen.namen.eq("HATS-19 b"))).fetchOne();
        if (n != null) {
            QZtentdecker qZtentdecker = QZtentdecker.ztentdecker;
            ((SQLDeleteClause)this.datenbankverbinder.getNewSqlDeleteClause(qZtentdecker).where((Predicate)qZtentdecker.datenid.eq(n))).execute();
            this.helper.addPlanetsToDiscovererProject(EntdeckerProjekte.HAT_SOUTH, "", List.of("HATS-19 b"));
        }
        this.helper.addPlanetsToSpaceTelescope(EntdeckerWeltraumteleskope.WISE, "", List.of("BD+60 1417 b"));
    }

    @Override
    public int updateToVersion() {
        return 119;
    }
}

