/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbankkern.impl.migration;

import com.google.inject.Inject;
import com.querydsl.sql.dml.SQLInsertClause;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.api.repos.EntdeckerProjekte;
import de.planetensuche.datenbankkern.api.repos.EntdeckerTyp;
import de.planetensuche.datenbankkern.api.repos.EntdeckerWeltraumteleskope;
import de.planetensuche.datenbankkern.impl.migration.DatabaseUpdater;
import de.planetensuche.datenbankkern.querydsl5.Entdecker;
import de.planetensuche.datenbankkern.querydsl5.QEntdecker;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.sql.SQLException;

public final class Version11Migrator
implements DatabaseUpdater {
    private static final ILogging LOGGER = LoggingFactory.getLoggerForClass(Version11Migrator.class);
    private final IDatenbankverbinder datenbankverbinder;

    @Inject
    public Version11Migrator(IDatenbankverbinder iDatenbankverbinder) {
        this.datenbankverbinder = iDatenbankverbinder;
    }

    @Override
    public int updateToVersion() {
        return 11;
    }

    @Override
    public void update() {
        try {
            QEntdecker qEntdecker = QEntdecker.entdecker;
            Entdecker entdecker = new Entdecker();
            entdecker.setNachname(EntdeckerWeltraumteleskope.JWST.getNameInDatabase());
            entdecker.setTyp(EntdeckerTyp.SPACE_TELESCOPE.getType());
            ((SQLInsertClause)this.datenbankverbinder.getNewSqlInsertClause(qEntdecker).populate(entdecker)).execute();
            this.saveNewProject(EntdeckerProjekte.SPECULOOS.getNameInDatabase());
            this.saveNewProject(EntdeckerProjekte.TRAPPIST.getNameInDatabase());
            this.saveNewProject(EntdeckerProjekte.EPIC.getNameInDatabase());
        }
        catch (SQLException sQLException) {
            LOGGER.error("Fehler beim Abspeichern von Exoplaneten-Projekten", sQLException);
        }
    }

    private void saveNewProject(String string) throws SQLException {
        QEntdecker qEntdecker = QEntdecker.entdecker;
        Entdecker entdecker = new Entdecker();
        entdecker.setNachname(string);
        entdecker.setTyp(EntdeckerTyp.PROJECT.getType());
        ((SQLInsertClause)this.datenbankverbinder.getNewSqlInsertClause(qEntdecker).populate(entdecker)).execute();
    }
}

