/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbankkern.impl.migration;

import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLInsertClause;
import de.planetensuche.datamodel.api.ObjektKategorie;
import de.planetensuche.datamodel.api.StarObjectType;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.impl.migration.DatabaseUpdater;
import de.planetensuche.datenbankkern.impl.migration.MigrationHelper;
import de.planetensuche.datenbankkern.querydsl5.QKategorie;
import de.planetensuche.datenbankkern.querydsl5.QObjekttypen;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.sql.SQLException;

public final class Version120Migrator
implements DatabaseUpdater {
    private static final ILogging LOGGER = LoggingFactory.getLoggerForClass(Version120Migrator.class);
    private final IDatenbankverbinder datenbankverbinder;
    private final MigrationHelper helper;

    public Version120Migrator(IDatenbankverbinder iDatenbankverbinder) {
        this.datenbankverbinder = iDatenbankverbinder;
        this.helper = new MigrationHelper(iDatenbankverbinder);
    }

    @Override
    public void update() throws SQLException {
        LOGGER.debug("starting DB migration to Version " + this.updateToVersion());
        QObjekttypen qObjekttypen = QObjekttypen.objekttypen;
        QKategorie qKategorie = QKategorie.kategorie;
        Integer n = (Integer)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qKategorie.id).from((Expression<?>)qKategorie)).where(qKategorie.name.eq(ObjektKategorie.STERNE.getKategorienName()))).fetchOne();
        if (n == null) {
            throw new IllegalStateException("missing object category 'stars'");
        }
        ((SQLInsertClause)((SQLInsertClause)this.datenbankverbinder.getNewSqlInsertClause(qObjekttypen).columns(new Path[]{qObjekttypen.kategorieid, qObjekttypen.typ})).values(new Object[]{n, StarObjectType.ECLIPSING_BINARY_CANDIDATE.getTypeName()})).execute();
        try {
            this.datenbankverbinder.query("CREATE CACHED TABLE pht_eb_candidates (tic_id BIGINT NOT NULL, datenid INTEGER NULL, auto_valid VARCHAR(30) DEFAULT 'TBD' NOT NULL, eb_catalog VARCHAR(30), PRIMARY KEY (tic_id), FOREIGN KEY (datenid) REFERENCES daten (id) ON DELETE CASCADE);");
        }
        catch (SQLException sQLException) {
            LOGGER.debug("table pht_eb_candidates already exists");
        }
        try {
            this.datenbankverbinder.query("CREATE CACHED TABLE pht_eb_candidate_tags (id BIGINT IDENTITY, subject_id BIGINT NOT NULL, tic_id BIGINT NOT NULL, tag_name VARCHAR(30) NOT NULL, count INTEGER NOT NULL, FOREIGN KEY (tic_id) REFERENCES pht_eb_candidates (tic_id) ON DELETE CASCADE);");
            this.datenbankverbinder.query("CREATE INDEX idx_phttags_subjectid ON pht_eb_candidate_tags(subject_id);");
        }
        catch (SQLException sQLException) {
            LOGGER.debug("table pht_eb_candidate_tags already exists");
        }
    }

    @Override
    public int updateToVersion() {
        return 120;
    }
}

