/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbankkern.impl.migration;

import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.impl.migration.DatabaseUpdater;
import de.planetensuche.datenbankkern.impl.migration.MigrationHelper;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.sql.SQLException;

public final class Version126Migrator
implements DatabaseUpdater {
    private static final ILogging LOGGER = LoggingFactory.getLoggerForClass(Version126Migrator.class);
    private final IDatenbankverbinder datenbankverbinder;
    private final MigrationHelper helper;

    public Version126Migrator(IDatenbankverbinder iDatenbankverbinder) {
        this.datenbankverbinder = iDatenbankverbinder;
        this.helper = new MigrationHelper(iDatenbankverbinder);
    }

    @Override
    public void update() throws SQLException {
        LOGGER.debug("starting DB migration to Version " + this.updateToVersion());
        this.helper.deletePlanetensucheObject("K2-419 A b");
        this.helper.deletePlanetensucheObject("K2-419 A");
        this.helper.addNamen("TOI-5176", "EPIC 211509553");
        this.helper.addNamen("TOI-5176", "K2-419 A");
        this.helper.addNamen("TOI-5176.01", "K2-419 A b");
        this.helper.deleteName("TOI-1173");
        this.helper.addNamen("TIC 10930507", "2MASS J02495639-0557352");
        this.helper.deleteName("Gaia DR2 4092190177629426816");
        this.helper.addNamen("HAT-P-63", "Gaia DR2 4474644332250439552");
        this.helper.renameName("Gaia DR2 481646209193812940", "Gaia DR2 4816462091938129408");
        this.helper.addNamen("TIC 150058659", "ITG 15");
        this.helper.addNamen("TIC 150058659", "EPIC 248030407");
        this.helper.addNamen("TIC 230741378", "2MASS J20492745+3336512");
        this.helper.addNamen("TIC 230741378", "SPECULOOS-3");
        this.helper.deleteName("HD 206860 b");
        this.helper.deleteName("Kepler-1660");
        this.helper.renameName("Kepler-1660 AB", "Kepler-1660 A");
        this.helper.deleteName("Kepler-1660 b");
        this.helper.renameName("TOI-858", "TOI-858 B");
        this.helper.renameName("TOI-858.01", "TOI-858 B b");
        this.helper.renameName("OGLE-2007-BLG-349L(AB)", "OGLE-2007-BLG-349L A");
        this.helper.deletePlanetensucheObject("OGLE-2007-BLG-349L(AB) c");
    }

    @Override
    public int updateToVersion() {
        return 126;
    }
}

