/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbankkern.impl.migration;

import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.impl.migration.DatabaseUpdater;
import de.planetensuche.datenbankkern.impl.migration.MigrationHelper;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.sql.SQLException;

public final class Version129Migrator
implements DatabaseUpdater {
    private static final ILogging LOGGER = LoggingFactory.getLoggerForClass(Version129Migrator.class);
    private final IDatenbankverbinder datenbankverbinder;
    private final MigrationHelper helper;

    public Version129Migrator(IDatenbankverbinder iDatenbankverbinder) {
        this.datenbankverbinder = iDatenbankverbinder;
        this.helper = new MigrationHelper(iDatenbankverbinder);
    }

    @Override
    public void update() throws SQLException {
        LOGGER.debug("starting DB migration to Version " + this.updateToVersion());
        this.helper.deleteName("2MASS J23592924+3343269 A");
        this.helper.deleteName("BD+32 4747");
        this.helper.renameName("WDS J23595+3343AB", "WDS J23595+3343A");
        if (this.helper.existsName("HIP 118281")) {
            this.helper.deleteName("HIP 118281 A");
        } else {
            this.helper.renameName("HIP 118281 A", "HIP 118281");
        }
        this.helper.addNamen("HIP 118281", "SAO 73656");
        this.helper.deleteName("SAO 73656B");
        this.helper.addNamen("HR 9075", "WDS J23595+3343B");
        this.helper.addNamen("HR 9075", "Gaia DR2 2875096978193654528");
        this.helper.deleteName("KOI-13B");
        this.helper.deletePlanetensucheObject("TIC 1717079066.01");
        this.helper.deletePlanetensucheObject("TIC 1717079066");
        this.helper.addNamen("WDS J19079+4652B", "TIC 1717079066");
        this.helper.deletePlanetensucheObject("Kepler-35(AB) b");
        this.helper.deletePlanetensucheObject("Kepler-35 A");
        this.helper.renameName("Kepler-16B", "Kepler-16 B");
        this.helper.renameName("OGLE-2008-BLG-513", "OGLE-2008-BLG-513L");
        this.helper.renameName("OGLE-2008-BLG-513 b", "OGLE-2008-BLG-513L b");
        this.helper.addNamen("HD 261938", "TIC 220322416");
        this.helper.deleteName("ADS 5325");
        this.helper.deleteName("BD+10 1220E");
        this.helper.deleteName("CCDM J06410+0953E");
        this.helper.renameName("CCDM J06410+0953HI", "CCDM J06410+0953H");
        this.helper.addNamen("Gaia DR2 3990321005089649408", "TIC 159523953");
        this.helper.renameName("ADS 1778 a", "ADS 1778 A");
        this.helper.deleteName("BD+11 3834p");
        this.helper.deleteName("HD 72946E");
        this.helper.deleteName("BD+07 1997E");
        this.helper.addNamen("ADS 6886 E", "TIC 468986261");
        this.helper.addNamen("ADS 6886 D", "TIC 468986288");
        this.helper.addNamen("ADS 6886 C", "TIC 468986270");
        this.helper.renameName("ADS 14787 c", "ADS 14787 C");
        if (this.helper.existsName("ADS 14787 B")) {
            this.helper.deleteName("ADS 14787 b");
        } else {
            this.helper.renameName("ADS 14787 b", "ADS 14787 B");
        }
        this.helper.renameName("Do 25", "DO 25");
        this.helper.renameName("Do 27", "DO 27");
        this.helper.renameName("Do 39", "DO 39");
        this.helper.deletePlanetensucheObject("GD 66 b");
        this.helper.addNamen("GD 66", "TIC 2515421");
        this.helper.deletePlanetensucheObject("BD+37 4734p");
        this.helper.addNamen("TIC 346338553", "ADS 16402 A");
        this.helper.addNamen("TIC 346338553", "PPM 88381");
        this.helper.renameName("BD+58 1372 A", "BD+58 1372A");
        this.helper.renameName("KIC 4862625 B", "KIC 4862625B");
        this.helper.deletePlanetensucheObject("HW Vir 4");
    }

    @Override
    public int updateToVersion() {
        return 129;
    }
}

