/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbankkern.impl.migration;

import com.google.inject.Inject;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLInsertClause;
import com.querydsl.sql.dml.SQLUpdateClause;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.impl.migration.DatabaseUpdater;
import de.planetensuche.datenbankkern.impl.migration.MigrationHelper;
import de.planetensuche.datenbankkern.querydsl5.Daten;
import de.planetensuche.datenbankkern.querydsl5.Namen;
import de.planetensuche.datenbankkern.querydsl5.QDaten;
import de.planetensuche.datenbankkern.querydsl5.QNamen;
import de.planetensuche.datenbankkern.querydsl5.QObjekttypen;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.sql.Timestamp;
import java.util.ArrayList;

public final class Version12Migrator
implements DatabaseUpdater {
    private static final ILogging LOGGER = LoggingFactory.getLoggerForClass(Version12Migrator.class);
    private final IDatenbankverbinder datenbankverbinder;
    private final MigrationHelper migrationHelper;

    @Inject
    public Version12Migrator(IDatenbankverbinder iDatenbankverbinder) {
        this.datenbankverbinder = iDatenbankverbinder;
        this.migrationHelper = new MigrationHelper(this.datenbankverbinder);
    }

    @Override
    public int updateToVersion() {
        return 12;
    }

    @Override
    public void update() {
        LOGGER.info("update Datenbank von Version 11 auf 12...");
        QDaten qDaten = QDaten.daten;
        QNamen qNamen = QNamen.namen1;
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("WASP-85 A");
            arrayList.add("WASP-85 A b");
            this.migrationHelper.deletePlanetensucheObjects(arrayList);
            ((SQLUpdateClause)((SQLUpdateClause)this.datenbankverbinder.getNewSqlUpdateClause(qNamen).set((Path)qNamen.namen, "WASP-85 A")).where((Predicate)qNamen.namen.eq("WASP-85"))).execute();
            ((SQLUpdateClause)((SQLUpdateClause)this.datenbankverbinder.getNewSqlUpdateClause(qNamen).set((Path)qNamen.namen, "WASP-85 A b")).where((Predicate)qNamen.namen.eq("WASP-85 b"))).execute();
            QObjekttypen qObjekttypen = QObjekttypen.objekttypen;
            Integer n = (Integer)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qObjekttypen.id).from((Expression<?>)qObjekttypen)).where(qObjekttypen.typ.eq("Doppelstern physisch"))).fetchFirst();
            Daten daten = this.migrationHelper.readPlanetensucheObject("WASP-85 A");
            if (daten != null) {
                daten.setObjektid(n);
                this.migrationHelper.updatePlanetensucheObjekt(daten);
            }
            Daten daten2 = new Daten();
            daten2.setObjektid(n);
            daten2.setAutor("Gerd G\u00fchne");
            daten2.setStamp(new Timestamp(System.currentTimeMillis()));
            Integer n2 = ((SQLInsertClause)this.datenbankverbinder.getNewSqlInsertClause(qDaten).populate(daten2)).executeWithKey(qDaten.id);
            Namen namen = new Namen();
            namen.setDatenid(n2);
            namen.setNamen("WASP-85 AB");
            ((SQLInsertClause)this.datenbankverbinder.getNewSqlInsertClause(qNamen).populate(namen)).execute();
            this.migrationHelper.addNamen("WASP-85 AB", "WDS J11436+0634AB");
            this.migrationHelper.addNamen("WASP-85 AB", "CCDM J11436+0634AB");
            this.migrationHelper.addNamen("WASP-85 AB", "TYC 278-584-1");
            this.migrationHelper.addNamen("WASP-85 AB", "ADS 8279 AB");
            this.migrationHelper.addNamen("WASP-85 AB", "BD+07 2474");
            arrayList = new ArrayList();
            arrayList.add("Kepler-410 A");
            arrayList.add("Kepler-410 A b");
            this.migrationHelper.deletePlanetensucheObjects(arrayList);
            ((SQLUpdateClause)((SQLUpdateClause)this.datenbankverbinder.getNewSqlUpdateClause(qNamen).set((Path)qNamen.namen, "Kepler-410 A")).where((Predicate)qNamen.namen.eq("Kepler-410A"))).execute();
            ((SQLUpdateClause)((SQLUpdateClause)this.datenbankverbinder.getNewSqlUpdateClause(qNamen).set((Path)qNamen.namen, "Kepler-410 A b")).where((Predicate)qNamen.namen.eq("Kepler-410A b"))).execute();
            Daten daten3 = this.migrationHelper.readPlanetensucheObject("Kepler-410 A");
            if (daten3 != null) {
                daten3.setObjektid(n);
                this.migrationHelper.updatePlanetensucheObjekt(daten3);
            }
            this.migrationHelper.addNamen("Kepler-410 A", "HD 175289");
            this.migrationHelper.addNamen("Kepler-410 A", "BD+44 3008");
            this.migrationHelper.addNamen("Kepler-410 A", "Gaia 2106904144153090560");
            this.migrationHelper.addNamen("Kepler-410 A", "GSC 03540-00760");
            this.migrationHelper.addNamen("Kepler-410 A", "2MASS J18523616+4508233");
            this.migrationHelper.addNamen("Kepler-410 A", "PPM 57594");
            this.migrationHelper.addNamen("Kepler-410 A", "SAO 47882");
            this.migrationHelper.addNamen("Kepler-410 A", "TYC 3540-760-1");
            this.migrationHelper.addNamen("Kepler-410 A", "WDS J18526+4508AB");
            this.migrationHelper.addNamen("Kepler-410 A", "WISE J185236.23+450824.2");
            arrayList = new ArrayList();
            arrayList.add("Kepler-34 b");
            this.migrationHelper.deletePlanetensucheObjects(arrayList);
            this.migrationHelper.addNamen("Kepler-34(AB) b", "KOI-2459.02");
            this.migrationHelper.addNamen("Kepler-34(AB) b", "KIC 8572936 b");
            ((SQLUpdateClause)((SQLUpdateClause)this.datenbankverbinder.getNewSqlUpdateClause(qDaten).set((Path)qDaten.entdeckungbestaetigt, (Object)true)).where((Predicate)qDaten.id.eq((Expression)((SQLQuery)SQLExpressions.select(qNamen.datenid).from((Expression<?>)qNamen)).where(qNamen.namen.eq("Kepler-34(AB) b"))))).execute();
        }
        catch (Exception exception) {
            LOGGER.debug("", exception);
        }
    }
}

