/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbankkern.impl.migration;

import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.dml.SQLUpdateClause;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.impl.migration.DatabaseUpdater;
import de.planetensuche.datenbankkern.impl.migration.MigrationHelper;
import de.planetensuche.datenbankkern.querydsl5.QNamen;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.sql.SQLException;
import java.util.List;

public final class Version130Migrator
implements DatabaseUpdater {
    private static final ILogging LOGGER = LoggingFactory.getLoggerForClass(Version130Migrator.class);
    private final IDatenbankverbinder datenbankverbinder;
    private final MigrationHelper helper;

    public Version130Migrator(IDatenbankverbinder iDatenbankverbinder) {
        this.datenbankverbinder = iDatenbankverbinder;
        this.helper = new MigrationHelper(iDatenbankverbinder);
    }

    @Override
    public void update() throws SQLException {
        LOGGER.debug("starting DB migration to Version " + this.updateToVersion());
        QNamen qNamen = QNamen.namen1;
        long l = ((SQLUpdateClause)((SQLUpdateClause)this.datenbankverbinder.getNewSqlUpdateClause(qNamen).set((Path)qNamen.isbayerflamsteedgcvs2, (Object)true)).where((Predicate)qNamen.namen.in(List.of("WX Columbae", "IM Librae", "CM Sculptoris", "SX Cassiopeiae", "PS Cephei", "CC Microscopii", "CN Ceti", "WZ Fornacis", "BL Lac", "41 Aurigae A", "41 Aurigae B", "VW Columbae", "IN Comae Berenices", "Omikron02 Eridani C", "Delta02 Orionis", "Delta01 Orionis", "Beta Muscae B", "19 Lyncis B", "19 Lyncis A")))).execute();
        LOGGER.info(l + " rows updated");
        this.helper.renameName("BL Lac", "BL Lacertae");
        this.helper.addNamen("BL Lacertae", "TIC 353622691");
    }

    @Override
    public int updateToVersion() {
        return 130;
    }
}

