/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbankkern.impl.migration;

import de.planetensuche.datamodel.api.StarObjectType;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.api.repos.EntdeckerProjekte;
import de.planetensuche.datenbankkern.impl.migration.DatabaseUpdater;
import de.planetensuche.datenbankkern.impl.migration.MigrationHelper;
import de.planetensuche.datenbankkern.querydsl5.Daten;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.sql.SQLException;
import java.util.List;

public final class Version135Migrator
implements DatabaseUpdater {
    private static final ILogging LOGGER = LoggingFactory.getLoggerForClass(Version135Migrator.class);
    private final IDatenbankverbinder datenbankverbinder;
    private final MigrationHelper helper;

    public Version135Migrator(IDatenbankverbinder iDatenbankverbinder) {
        this.datenbankverbinder = iDatenbankverbinder;
        this.helper = new MigrationHelper(iDatenbankverbinder);
    }

    @Override
    public void update() throws SQLException {
        LOGGER.debug("starting DB migration to Version " + this.updateToVersion());
        this.helper.createPlanetensucheObjekt(List.of("2017 OF201"), "Kleinplanet");
        Daten daten = this.helper.readPlanetensucheObject("2017 OF201");
        daten.setEntfernung(878.9134619798807);
        daten.setDurchmesser(700.0);
        daten.setUmlaufszeit(9517384.203756295);
        daten.setExzentritaet(0.9485184863826539);
        this.helper.updatePlanetensucheObjekt(daten);
        this.helper.addPlanetsToDiscovererProject(EntdeckerProjekte.KOBE, "K-dwarfs Orbited By habitable Exoplanets (KOBE)", null);
        this.helper.addNamen("HIP 5957", "KOBE-1");
        this.helper.createPlanetensucheObjekt(List.of("ZTF J123016.59-265551.34", "GALEX J123016.6-265551", "Gaia DR2 3475360576690175616", "Gaia DR3 3475360576690175616"), StarObjectType.WHITE_DWARF.getTypeName());
        this.helper.createPlanetensucheObjekt(List.of("ZTF J182848.77+230838.0", "ZTF J182848.76+230838.0", "Gaia DR2 4529477698683435264", "Gaia DR3 4529477698683435264"), StarObjectType.WHITE_DWARF.getTypeName());
    }

    @Override
    public int updateToVersion() {
        return 135;
    }
}

