/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbankkern.impl.migration;

import com.google.inject.Inject;
import com.querydsl.core.types.Expression;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLInsertClause;
import de.planetensuche.datamodel.api.StarObjectType;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.impl.migration.DatabaseUpdater;
import de.planetensuche.datenbankkern.impl.migration.MigrationHelper;
import de.planetensuche.datenbankkern.querydsl5.Daten;
import de.planetensuche.datenbankkern.querydsl5.Namen;
import de.planetensuche.datenbankkern.querydsl5.QDaten;
import de.planetensuche.datenbankkern.querydsl5.QNamen;
import de.planetensuche.datenbankkern.querydsl5.QObjekttypen;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.sql.SQLException;
import java.sql.Timestamp;

public final class Version13Migrator
implements DatabaseUpdater {
    private static final ILogging LOGGER = LoggingFactory.getLoggerForClass(Version13Migrator.class);
    private final IDatenbankverbinder datenbankverbinder;
    private final MigrationHelper migrationHelper;

    @Inject
    public Version13Migrator(IDatenbankverbinder iDatenbankverbinder) {
        this.datenbankverbinder = iDatenbankverbinder;
        this.migrationHelper = new MigrationHelper(this.datenbankverbinder);
    }

    @Override
    public int updateToVersion() {
        return 13;
    }

    @Override
    public void update() {
        LOGGER.info("update Datenbank von Version 12 auf 13...");
        try {
            QObjekttypen qObjekttypen = QObjekttypen.objekttypen;
            Integer n = (Integer)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qObjekttypen.id).from((Expression<?>)qObjekttypen)).where(qObjekttypen.typ.eq("Doppelstern physisch"))).fetchFirst();
            Integer n2 = (Integer)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qObjekttypen.id).from((Expression<?>)qObjekttypen)).where(qObjekttypen.typ.eq("Einzelstern"))).fetchFirst();
            Integer n3 = (Integer)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qObjekttypen.id).from((Expression<?>)qObjekttypen)).where(qObjekttypen.typ.eq(StarObjectType.MULTI_STAR_SYSTEM.getTypeName()))).fetchFirst();
            Integer n4 = (Integer)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qObjekttypen.id).from((Expression<?>)qObjekttypen)).where(qObjekttypen.typ.eq("Veraenderlicher unregelmaessig"))).fetchFirst();
            Integer n5 = (Integer)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qObjekttypen.id).from((Expression<?>)qObjekttypen)).where(qObjekttypen.typ.eq("Veraenderlicher kurzperiodisch"))).fetchFirst();
            Integer n6 = (Integer)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qObjekttypen.id).from((Expression<?>)qObjekttypen)).where(qObjekttypen.typ.eq("Bedeckungsveraenderlicher"))).fetchFirst();
            Integer n7 = (Integer)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qObjekttypen.id).from((Expression<?>)qObjekttypen)).where(qObjekttypen.typ.eq("Nova"))).fetchFirst();
            this.saveNewStar(new String[]{"2MASS J01033563-5515561 AB"}, n);
            this.saveNewStar(new String[]{"2MASS J01225093-2439505 AB", "WDS J01228-2440AB"}, n);
            this.saveNewStar(new String[]{"2MASS J02192210-3925225 AB"}, n);
            this.saveNewStar(new String[]{"WDS J04417+2302Aa,Ab", "2MASS J04414489+2301513", "WDS J04417+2302A"}, n3);
            this.saveNewStar(new String[]{"TYC 9486-927-1", "ASAS J212528-8138.5", "2MASS J21252752-8138278"}, n2);
            this.saveNewStar(new String[]{"V866 Scorpii", "AS 205A", "GSC 06205-01297", "2MASS J16113134-1838259", "MHA 365-14"}, n4);
            this.saveNewStar(new String[]{"CI Tauri", "GCRV 55186", "Haro 6-25", "2MASS J04335200+2250301"}, n4);
            this.saveNewStar(new String[]{"2MASS J22362452+4751425", "UCAC4 690-119045"}, n5);
            this.saveNewStar(new String[]{"DW Ursae Majoris", "2MASS J10335283+5846547", "GSC 03822-00464", "GUVV J103352.8+584655.1"}, n6);
            this.saveNewStar(new String[]{"GP Comae Berenices", "LTT 18284", "2MASS J13054243+1801039", "NLTT 32844", "WD 1303+18"}, n7);
            this.saveNewStar(new String[]{"V396 Hydrae", "L 854-35", "WD 1310-230"}, n7);
            this.saveNewStar(new String[]{"MXB 1658-298", "V2134 Ophiuchi"}, n);
            this.saveNewStar(new String[]{"BD+03 2562", "GSC 00276-00507", "2MASS J11501555+0245365", "PPM 158252", "TYC 276-507-1"}, n2);
            this.saveNewStar(new String[]{"CoRoT 223977153", "2MASS J06404684+0915267"}, n5);
            this.saveNewStar(new String[]{"LP 358-499", "ASCC 659586", "2MASS J04403562+2500361", "NLTT 13719"}, n2);
        }
        catch (SQLException sQLException) {
            LOGGER.debug("", sQLException);
        }
    }

    private void saveNewStar(String[] stringArray, int n) throws SQLException {
        for (String string : stringArray) {
            String[] stringArray2 = this.migrationHelper.readPlanetensucheObject(string);
            if (stringArray2 == null) continue;
            for (String string2 : stringArray) {
                this.migrationHelper.addNamen(string, string2);
            }
            return;
        }
        QDaten qDaten = QDaten.daten;
        QNamen qNamen = QNamen.namen1;
        Daten daten = new Daten();
        daten.setObjektid(n);
        daten.setAutor("Gerd G\u00fchne");
        daten.setStamp(new Timestamp(System.currentTimeMillis()));
        Integer n2 = ((SQLInsertClause)this.datenbankverbinder.getNewSqlInsertClause(qDaten).populate(daten)).executeWithKey(qDaten.id);
        for (String string : stringArray) {
            Namen namen = new Namen();
            namen.setDatenid(n2);
            namen.setNamen(string);
            ((SQLInsertClause)this.datenbankverbinder.getNewSqlInsertClause(qNamen).populate(namen)).execute();
        }
    }
}

