/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbankkern.impl.migration;

import com.google.inject.Inject;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLDeleteClause;
import com.querydsl.sql.dml.SQLInsertClause;
import com.querydsl.sql.dml.SQLUpdateClause;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.impl.migration.DatabaseUpdater;
import de.planetensuche.datenbankkern.querydsl5.Namen;
import de.planetensuche.datenbankkern.querydsl5.QNamen;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.sql.SQLException;

public final class Version16Migrator
implements DatabaseUpdater {
    private static final ILogging LOGGER = LoggingFactory.getLoggerForClass(Version16Migrator.class);
    private final IDatenbankverbinder datenbankverbinder;

    @Inject
    public Version16Migrator(IDatenbankverbinder iDatenbankverbinder) {
        this.datenbankverbinder = iDatenbankverbinder;
    }

    @Override
    public int updateToVersion() {
        return 16;
    }

    @Override
    public void update() throws SQLException {
        Namen namen;
        LOGGER.debug("starting DB migration to Version 16");
        QNamen qNamen = QNamen.namen1;
        ((SQLDeleteClause)this.datenbankverbinder.getNewSqlDeleteClause(qNamen).where((Predicate)qNamen.namen.eq("2MASS 19454459+4438296"))).execute();
        ((SQLDeleteClause)this.datenbankverbinder.getNewSqlDeleteClause(qNamen).where((Predicate)qNamen.namen.eq("Kepler-16A"))).execute();
        ((SQLDeleteClause)this.datenbankverbinder.getNewSqlDeleteClause(qNamen).where((Predicate)qNamen.namen.eq("BD-082823 c"))).execute();
        ((SQLUpdateClause)((SQLUpdateClause)this.datenbankverbinder.getNewSqlUpdateClause(qNamen).set((Path)qNamen.namen, "Kepler-16 b")).where((Predicate)qNamen.namen.eq("Kepler-16A b"))).execute();
        ((SQLUpdateClause)((SQLUpdateClause)this.datenbankverbinder.getNewSqlUpdateClause(qNamen).set((Path)qNamen.namen, "2MASS J16222521-2405139 b")).where((Predicate)qNamen.namen.eq("Oph 11 b"))).execute();
        ((SQLUpdateClause)((SQLUpdateClause)this.datenbankverbinder.getNewSqlUpdateClause(qNamen).set((Path)qNamen.namen, "CFBDS J145829+101343 b")).where((Predicate)qNamen.namen.eq("CFBDS 1458 b"))).execute();
        ((SQLUpdateClause)((SQLUpdateClause)this.datenbankverbinder.getNewSqlUpdateClause(qNamen).set((Path)qNamen.namen, "HIP 61595 A")).where((Predicate)qNamen.namen.eq("HIP 61595A"))).execute();
        ((SQLUpdateClause)((SQLUpdateClause)this.datenbankverbinder.getNewSqlUpdateClause(qNamen).set((Path)qNamen.namen, "OGLE-2011-BLG-0251L")).where((Predicate)qNamen.namen.eq("OGLE-2011-BLG-0251"))).execute();
        ((SQLUpdateClause)((SQLUpdateClause)this.datenbankverbinder.getNewSqlUpdateClause(qNamen).set((Path)qNamen.namen, "OGLE-2011-BLG-0251L b")).where((Predicate)qNamen.namen.eq("OGLE-2011-BLG-0251 b"))).execute();
        ((SQLUpdateClause)((SQLUpdateClause)this.datenbankverbinder.getNewSqlUpdateClause(qNamen).set((Path)qNamen.namen, "MOA-2003-BLG-053L")).where((Predicate)qNamen.namen.eq("MOA-2003-BLG-53L"))).execute();
        ((SQLUpdateClause)((SQLUpdateClause)this.datenbankverbinder.getNewSqlUpdateClause(qNamen).set((Path)qNamen.namen, "PSR B1257+12")).where((Predicate)qNamen.namen.eq("PSR 1257+12"))).execute();
        ((SQLUpdateClause)((SQLUpdateClause)this.datenbankverbinder.getNewSqlUpdateClause(qNamen).set((Path)qNamen.namen, "PSR B1257+12 b")).where((Predicate)qNamen.namen.eq("PSR 1257+12 b"))).execute();
        ((SQLUpdateClause)((SQLUpdateClause)this.datenbankverbinder.getNewSqlUpdateClause(qNamen).set((Path)qNamen.namen, "PSR B1257+12 c")).where((Predicate)qNamen.namen.eq("PSR 1257+12 c"))).execute();
        ((SQLUpdateClause)((SQLUpdateClause)this.datenbankverbinder.getNewSqlUpdateClause(qNamen).set((Path)qNamen.namen, "PSR B1257+12 d")).where((Predicate)qNamen.namen.eq("PSR 1257+12 d"))).execute();
        ((SQLUpdateClause)((SQLUpdateClause)this.datenbankverbinder.getNewSqlUpdateClause(qNamen).set((Path)qNamen.namen, "GJ 667 C b")).where((Predicate)qNamen.namen.eq("GJ 667C b"))).execute();
        ((SQLUpdateClause)((SQLUpdateClause)this.datenbankverbinder.getNewSqlUpdateClause(qNamen).set((Path)qNamen.namen, "GJ 667 C c")).where((Predicate)qNamen.namen.eq("GJ 667C c"))).execute();
        ((SQLUpdateClause)((SQLUpdateClause)this.datenbankverbinder.getNewSqlUpdateClause(qNamen).set((Path)qNamen.namen, "GJ 667 C d")).where((Predicate)qNamen.namen.eq("GJ 667C d"))).execute();
        ((SQLUpdateClause)((SQLUpdateClause)this.datenbankverbinder.getNewSqlUpdateClause(qNamen).set((Path)qNamen.namen, "GJ 667 C e")).where((Predicate)qNamen.namen.eq("GJ 667C e"))).execute();
        ((SQLUpdateClause)((SQLUpdateClause)this.datenbankverbinder.getNewSqlUpdateClause(qNamen).set((Path)qNamen.namen, "GJ 667 C f")).where((Predicate)qNamen.namen.eq("GJ 667C f"))).execute();
        ((SQLUpdateClause)((SQLUpdateClause)this.datenbankverbinder.getNewSqlUpdateClause(qNamen).set((Path)qNamen.namen, "GJ 667 C g")).where((Predicate)qNamen.namen.eq("GJ 667C g"))).execute();
        ((SQLUpdateClause)((SQLUpdateClause)this.datenbankverbinder.getNewSqlUpdateClause(qNamen).set((Path)qNamen.namen, "GJ 676 A b")).where((Predicate)qNamen.namen.eq("GJ 676A b"))).execute();
        ((SQLUpdateClause)((SQLUpdateClause)this.datenbankverbinder.getNewSqlUpdateClause(qNamen).set((Path)qNamen.namen, "GJ 676 A c")).where((Predicate)qNamen.namen.eq("GJ 676A c"))).execute();
        ((SQLUpdateClause)((SQLUpdateClause)this.datenbankverbinder.getNewSqlUpdateClause(qNamen).set((Path)qNamen.namen, "GJ 676 A d")).where((Predicate)qNamen.namen.eq("GJ 676A d"))).execute();
        ((SQLUpdateClause)((SQLUpdateClause)this.datenbankverbinder.getNewSqlUpdateClause(qNamen).set((Path)qNamen.namen, "GJ 676 A e")).where((Predicate)qNamen.namen.eq("GJ 676A e"))).execute();
        ((SQLUpdateClause)((SQLUpdateClause)this.datenbankverbinder.getNewSqlUpdateClause(qNamen).set((Path)qNamen.namen, "HIP 59743 A")).where((Predicate)qNamen.namen.eq("HIP 59743A"))).execute();
        ((SQLUpdateClause)((SQLUpdateClause)this.datenbankverbinder.getNewSqlUpdateClause(qNamen).set((Path)qNamen.namen, "WASP-77 A")).where((Predicate)qNamen.namen.eq("WASP-77A"))).execute();
        ((SQLUpdateClause)((SQLUpdateClause)this.datenbankverbinder.getNewSqlUpdateClause(qNamen).set((Path)qNamen.namen, "WASP-77 A b")).where((Predicate)qNamen.namen.eq("WASP-77A b"))).execute();
        ((SQLUpdateClause)((SQLUpdateClause)this.datenbankverbinder.getNewSqlUpdateClause(qNamen).set((Path)qNamen.namen, "WASP-70 A")).where((Predicate)qNamen.namen.eq("WASP-70"))).execute();
        ((SQLUpdateClause)((SQLUpdateClause)this.datenbankverbinder.getNewSqlUpdateClause(qNamen).set((Path)qNamen.namen, "WASP-70 A b")).where((Predicate)qNamen.namen.eq("WASP-70 b"))).execute();
        Integer n = (Integer)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qNamen.datenid).from((Expression<?>)qNamen)).where(qNamen.namen.eq("POTS-1"))).fetchFirst();
        Integer n2 = (Integer)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qNamen.datenid).from((Expression<?>)qNamen)).where(qNamen.namen.eq("POTS-1 b"))).fetchFirst();
        if (n != null) {
            namen = new Namen();
            namen.setNamen("2MASS J13342613-6634520");
            namen.setDatenid(n);
            ((SQLInsertClause)this.datenbankverbinder.getNewSqlInsertClause(qNamen).populate(namen)).execute();
        }
        if (n2 != null) {
            namen = new Namen();
            namen.setNamen("2MASS J13342613-6634520 b");
            namen.setDatenid(n2);
            ((SQLInsertClause)this.datenbankverbinder.getNewSqlInsertClause(qNamen).populate(namen)).execute();
        }
        if ((n2 = (Integer)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qNamen.datenid).from((Expression<?>)qNamen)).where(qNamen.namen.eq("1RXS1609 b"))).fetchFirst()) != null) {
            namen = new Namen();
            namen.setNamen("2MASS J16093030-2104589 b");
            namen.setDatenid(n2);
            ((SQLInsertClause)this.datenbankverbinder.getNewSqlInsertClause(qNamen).populate(namen)).execute();
        }
        if ((n2 = (Integer)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qNamen.datenid).from((Expression<?>)qNamen)).where(qNamen.namen.eq("WISE 1217+16A b"))).fetchFirst()) != null) {
            namen = new Namen();
            namen.setNamen("WDS J12179+1627A b");
            namen.setDatenid(n2);
            ((SQLInsertClause)this.datenbankverbinder.getNewSqlInsertClause(qNamen).populate(namen)).execute();
        }
        if ((n2 = (Integer)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qNamen.datenid).from((Expression<?>)qNamen)).where(qNamen.namen.eq("OGLE-235/MOA-53 b"))).fetchFirst()) != null) {
            namen = new Namen();
            namen.setNamen("MOA-2003-BLG-053L b");
            namen.setDatenid(n2);
            ((SQLInsertClause)this.datenbankverbinder.getNewSqlInsertClause(qNamen).populate(namen)).execute();
        }
    }
}

