/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbankkern.impl.migration;

import com.google.inject.Inject;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLDeleteClause;
import com.querydsl.sql.dml.SQLInsertClause;
import com.querydsl.sql.dml.SQLUpdateClause;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.impl.migration.DatabaseUpdater;
import de.planetensuche.datenbankkern.querydsl5.Daten;
import de.planetensuche.datenbankkern.querydsl5.Entdecker;
import de.planetensuche.datenbankkern.querydsl5.Namen;
import de.planetensuche.datenbankkern.querydsl5.QDaten;
import de.planetensuche.datenbankkern.querydsl5.QEntdecker;
import de.planetensuche.datenbankkern.querydsl5.QNamen;
import de.planetensuche.datenbankkern.querydsl5.QObjekttypen;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.sql.SQLException;
import java.sql.Timestamp;

public final class Version17Migrator
implements DatabaseUpdater {
    private static final ILogging LOGGER = LoggingFactory.getLoggerForClass(Version17Migrator.class);
    private final IDatenbankverbinder datenbankverbinder;

    @Inject
    public Version17Migrator(IDatenbankverbinder iDatenbankverbinder) {
        this.datenbankverbinder = iDatenbankverbinder;
    }

    @Override
    public void update() throws SQLException {
        Entdecker entdecker;
        LOGGER.debug("starting DB migration to Version " + this.updateToVersion());
        QNamen qNamen = QNamen.namen1;
        QDaten qDaten = QDaten.daten;
        ((SQLDeleteClause)this.datenbankverbinder.getNewSqlDeleteClause(qNamen).where((Predicate)qNamen.namen.eq("KOI-507").or(qNamen.namen.eq("2MASS J19500088+4103252").or(qNamen.namen.eq("KIC 5812960")).or(qNamen.namen.eq("Kepler-582"))))).execute();
        QObjekttypen qObjekttypen = QObjekttypen.objekttypen;
        Integer n = (Integer)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qObjekttypen.id).from((Expression<?>)qObjekttypen)).where(qObjekttypen.typ.eq("Einzelstern"))).fetchFirst();
        Daten daten = new Daten();
        daten.setObjektid(n);
        daten.setAutor("NASA");
        daten.setStamp(new Timestamp(System.currentTimeMillis()));
        Integer n2 = ((SQLInsertClause)this.datenbankverbinder.getNewSqlInsertClause(qDaten).populate(daten)).executeWithKey(qDaten.id);
        Namen namen = new Namen();
        namen.setDatenid(n2);
        namen.setNamen("Kepler-582");
        ((SQLInsertClause)this.datenbankverbinder.getNewSqlInsertClause(qNamen).populate(namen)).execute();
        Namen namen2 = (Namen)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qNamen).from((Expression<?>)qNamen)).where(qNamen.namen.eq("Kepler-582 b"))).fetchFirst();
        if (namen2 != null) {
            ((SQLUpdateClause)((SQLUpdateClause)this.datenbankverbinder.getNewSqlUpdateClause(qDaten).set((Path)qDaten.zugehoerigkeit, n2)).where((Predicate)qDaten.id.eq(namen2.getDatenid()))).execute();
        }
        Entdecker entdecker2 = new Entdecker();
        entdecker2.setFachgebiet("Planetenforscher");
        entdecker2.setNachname("Mayo");
        entdecker2.setVorname("Andrew W.");
        this.insertDiscoverer(entdecker2);
        Entdecker entdecker3 = new Entdecker();
        entdecker3.setFachgebiet("Planetenforscher");
        entdecker3.setNachname("Bento");
        entdecker3.setVorname("Joao");
        this.insertDiscoverer(entdecker3);
        Entdecker entdecker4 = new Entdecker();
        entdecker4.setFachgebiet("Planetenforscher");
        entdecker4.setNachname("Eigm\u00fcller");
        entdecker4.setVorname("Philipp");
        this.insertDiscoverer(entdecker4);
        QEntdecker qEntdecker = QEntdecker.entdecker;
        Entdecker entdecker5 = (Entdecker)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qEntdecker).from((Expression<?>)qEntdecker)).where(qEntdecker.nachname.eq("Sinukoff"))).fetchFirst();
        if (entdecker5 == null) {
            entdecker = new Entdecker();
            entdecker.setFachgebiet("Planetenforscher");
            entdecker.setNachname("Sinukoff");
            entdecker.setVorname("E.");
            this.insertDiscoverer(entdecker);
        }
        if ((entdecker = (Entdecker)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qEntdecker).from((Expression<?>)qEntdecker)).where(qEntdecker.nachname.eq("Morton"))).fetchFirst()) == null) {
            Entdecker entdecker6 = new Entdecker();
            entdecker6.setFachgebiet("Planetenforscher");
            entdecker6.setNachname("Morton");
            entdecker6.setVorname("Timothy");
            this.insertDiscoverer(entdecker6);
        }
    }

    @Override
    public int updateToVersion() {
        return 17;
    }

    private void insertDiscoverer(Entdecker entdecker) throws SQLException {
        QEntdecker qEntdecker = QEntdecker.entdecker;
        ((SQLInsertClause)this.datenbankverbinder.getNewSqlInsertClause(qEntdecker).populate(entdecker)).execute();
    }
}

