/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbankkern.impl.migration;

import com.google.inject.Inject;
import com.querydsl.core.types.Expression;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLInsertClause;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.api.repos.EntdeckerTyp;
import de.planetensuche.datenbankkern.impl.migration.DatabaseUpdater;
import de.planetensuche.datenbankkern.querydsl5.Daten;
import de.planetensuche.datenbankkern.querydsl5.Entdecker;
import de.planetensuche.datenbankkern.querydsl5.Namen;
import de.planetensuche.datenbankkern.querydsl5.Notizen;
import de.planetensuche.datenbankkern.querydsl5.QDaten;
import de.planetensuche.datenbankkern.querydsl5.QEntdecker;
import de.planetensuche.datenbankkern.querydsl5.QNamen;
import de.planetensuche.datenbankkern.querydsl5.QNotizen;
import de.planetensuche.datenbankkern.querydsl5.QZtentdecker;
import de.planetensuche.datenbankkern.querydsl5.Ztentdecker;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import org.apache.commons.io.FileUtils;

public final class Version18Migrator
implements DatabaseUpdater {
    private static final ILogging LOGGER = LoggingFactory.getLoggerForClass(Version18Migrator.class);
    private final IDatenbankverbinder datenbankverbinder;

    @Inject
    public Version18Migrator(IDatenbankverbinder iDatenbankverbinder) {
        this.datenbankverbinder = iDatenbankverbinder;
    }

    @Override
    public void update() throws SQLException {
        boolean bl;
        Object object;
        Object object2;
        Object object3;
        LOGGER.debug("starting DB migration to Version " + this.updateToVersion());
        QEntdecker qEntdecker = QEntdecker.entdecker;
        Entdecker entdecker = (Entdecker)((SQLQuery)this.datenbankverbinder.getQueryFactory().selectFrom((RelationalPath)qEntdecker).where(qEntdecker.nachname.eq("Next-Generation Transit Survey (NGTS)"))).fetchFirst();
        if (entdecker == null) {
            entdecker = new Entdecker();
            entdecker.setFachgebiet("NGTS is a ground-based robotic search for exoplanets");
            entdecker.setNachname("Next-Generation Transit Survey (NGTS)");
            entdecker.setVorname("");
            entdecker.setTyp(EntdeckerTyp.PROJECT.getType());
            this.insertDiscoverer(entdecker);
        }
        QDaten qDaten = QDaten.daten;
        QNamen qNamen = QNamen.namen1;
        Daten daten = (Daten)((SQLQuery)this.datenbankverbinder.getQueryFactory().selectFrom((RelationalPath)qDaten).where(qDaten.id.eq((Expression)((SQLQuery)SQLExpressions.select(qNamen.datenid).from((Expression<?>)qNamen)).where(qNamen.namen.eq("NGTS-1 b"))))).fetchFirst();
        if (daten != null) {
            object3 = QZtentdecker.ztentdecker;
            object2 = new Ztentdecker();
            ((Ztentdecker)object2).setDatenid(daten.getId());
            ((Ztentdecker)object2).setEntdeckerid(entdecker.getId());
            ((SQLInsertClause)this.datenbankverbinder.getNewSqlInsertClause((RelationalPath<?>)object3).populate(object2)).execute();
        }
        if ((entdecker = (Entdecker)((SQLQuery)this.datenbankverbinder.getQueryFactory().selectFrom((RelationalPath)qEntdecker).where(qEntdecker.nachname.eq("Qatar Exoplanet Survey (QES)"))).fetchFirst()) == null) {
            entdecker = new Entdecker();
            entdecker.setFachgebiet("transit survey");
            entdecker.setNachname("Qatar Exoplanet Survey (QES)");
            entdecker.setVorname("");
            entdecker.setTyp(EntdeckerTyp.PROJECT.getType());
            this.insertDiscoverer(entdecker);
        }
        object3 = ((SQLQuery)this.datenbankverbinder.getQueryFactory().selectFrom((RelationalPath)qNamen).where(qNamen.namen.startsWith("Qatar-").and(qNamen.namen.endsWith("b")))).fetch();
        object2 = object3.iterator();
        while (object2.hasNext()) {
            object = (Namen)object2.next();
            QZtentdecker qZtentdecker = QZtentdecker.ztentdecker;
            Ztentdecker ztentdecker = new Ztentdecker();
            ztentdecker.setDatenid(((Namen)object).getDatenid());
            ztentdecker.setEntdeckerid(entdecker.getId());
            ((SQLInsertClause)this.datenbankverbinder.getNewSqlInsertClause(qZtentdecker).populate(ztentdecker)).execute();
        }
        try {
            object = QNotizen.notizen;
            this.datenbankverbinder.getQueryFactory().selectFrom((RelationalPath)object).fetchCount();
            bl = true;
        }
        catch (Exception exception) {
            bl = false;
        }
        if (!bl) {
            this.datenbankverbinder.query("CREATE TABLE notizen (id IDENTITY, datenid INTEGER NOT NULL UNIQUE, notiz VARCHAR(1073741824) NOT NULL, FOREIGN KEY (datenid) REFERENCES daten (id) ON DELETE CASCADE);");
            this.datenbankverbinder.query("ALTER TABLE daten DROP COLUMN Notiz;");
            this.datenbankverbinder.query("DROP INDEX objektnamen IF EXISTS;");
            this.datenbankverbinder.query("CREATE INDEX idx_objektnamen_datenid ON namen (namen, datenid);");
            this.datenbankverbinder.query("DROP INDEX objektnamenids IF EXISTS;");
            this.datenbankverbinder.query("CREATE INDEX idx_objektnamen_id ON namen (namen, id);");
            this.datenbankverbinder.query("DROP INDEX entdeckerids IF EXISTS;");
            this.datenbankverbinder.query("CREATE INDEX idx_entdeckername_id ON Entdecker (nachname, id);");
            this.datenbankverbinder.query("DROP INDEX entdeckungsmethodenids IF EXISTS;");
        }
        this.importNotizen(qNamen);
    }

    private void importNotizen(QNamen qNamen) throws SQLException {
        try {
            Object object;
            Object object2;
            QNotizen qNotizen = QNotizen.notizen;
            File file = new File("temp/notizen.csv");
            if (file.exists()) {
                object2 = FileUtils.readLines(file, StandardCharsets.UTF_8);
                object = object2.iterator();
                while (object.hasNext()) {
                    String string = object.next();
                    String[] stringArray = string.split(";");
                    String string2 = stringArray[0];
                    String string3 = stringArray[1];
                    Integer n = (Integer)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qNamen.datenid).from((Expression<?>)qNamen)).where(qNamen.namen.eq(string2))).fetchFirst();
                    if (n != null) {
                        Notizen notizen = (Notizen)((SQLQuery)this.datenbankverbinder.getQueryFactory().selectFrom((RelationalPath)qNotizen).where(qNotizen.datenid.eq(n))).fetchFirst();
                        if (notizen != null) continue;
                        Notizen notizen2 = new Notizen();
                        notizen2.setDatenid(n);
                        notizen2.setNotiz(string3);
                        ((SQLInsertClause)this.datenbankverbinder.getNewSqlInsertClause(qNotizen).populate(notizen2)).execute();
                        continue;
                    }
                    LOGGER.warn("found no object for name '" + string2 + "'");
                }
                file.delete();
            } else {
                LOGGER.warn("file nicht gefunden: " + file.getAbsolutePath());
            }
            object2 = new File("database/database-notizen");
            if (((File)object2).exists()) {
                FileUtils.deleteDirectory((File)object2);
            }
            if (((File)(object = new File("database/database-notizen2_2"))).exists()) {
                FileUtils.deleteDirectory((File)object);
            }
        }
        catch (IOException iOException) {
            LOGGER.error(iOException);
        }
    }

    @Override
    public int updateToVersion() {
        return 18;
    }

    private void insertDiscoverer(Entdecker entdecker) throws SQLException {
        QEntdecker qEntdecker = QEntdecker.entdecker;
        Integer n = ((SQLInsertClause)this.datenbankverbinder.getNewSqlInsertClause(qEntdecker).populate(entdecker)).executeWithKey(qEntdecker.id);
        entdecker.setId(n);
    }
}

