/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbankkern.impl.migration;

import com.google.inject.Inject;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.dml.SQLUpdateClause;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.impl.migration.DatabaseUpdater;
import de.planetensuche.datenbankkern.querydsl5.QSternbilder;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.sql.SQLException;

public final class Version19Migrator
implements DatabaseUpdater {
    private static final ILogging LOGGER = LoggingFactory.getLoggerForClass(Version19Migrator.class);
    private final IDatenbankverbinder datenbankverbinder;

    @Inject
    public Version19Migrator(IDatenbankverbinder iDatenbankverbinder) {
        this.datenbankverbinder = iDatenbankverbinder;
    }

    @Override
    public void update() throws SQLException {
        LOGGER.debug("starting DB migration to Version " + this.updateToVersion());
        QSternbilder qSternbilder = QSternbilder.sternbilder;
        ((SQLUpdateClause)((SQLUpdateClause)this.datenbankverbinder.getNewSqlUpdateClause(qSternbilder).set((Path)qSternbilder.dtbezeichnung, "Gro\u00dfer B\u00e4r")).where((Predicate)qSternbilder.latabk.eq("UMa"))).execute();
        ((SQLUpdateClause)((SQLUpdateClause)this.datenbankverbinder.getNewSqlUpdateClause(qSternbilder).set((Path)qSternbilder.dtbezeichnung, "Kleiner B\u00e4r")).where((Predicate)qSternbilder.latabk.eq("UMi"))).execute();
        ((SQLUpdateClause)((SQLUpdateClause)this.datenbankverbinder.getNewSqlUpdateClause(qSternbilder).set((Path)qSternbilder.dtbezeichnung, "Kleine/M\u00e4nnliche Wasserschlange")).where((Predicate)qSternbilder.latabk.eq("Hyi"))).execute();
    }

    @Override
    public int updateToVersion() {
        return 19;
    }
}

