/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbankkern.impl.migration;

import com.google.inject.Inject;
import com.querydsl.core.types.Expression;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLInsertClause;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.impl.migration.DatabaseUpdater;
import de.planetensuche.datenbankkern.querydsl5.Daten;
import de.planetensuche.datenbankkern.querydsl5.Namen;
import de.planetensuche.datenbankkern.querydsl5.QDaten;
import de.planetensuche.datenbankkern.querydsl5.QNamen;
import de.planetensuche.datenbankkern.querydsl5.QObjekttypen;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;

public final class Version20Migrator
implements DatabaseUpdater {
    private static final ILogging LOGGER = LoggingFactory.getLoggerForClass(Version20Migrator.class);
    private final IDatenbankverbinder datenbankverbinder;

    @Inject
    public Version20Migrator(IDatenbankverbinder iDatenbankverbinder) {
        this.datenbankverbinder = iDatenbankverbinder;
    }

    @Override
    public void update() throws SQLException {
        LOGGER.debug("starting DB migration to Version " + this.updateToVersion());
        QDaten qDaten = QDaten.daten;
        QNamen qNamen = QNamen.namen1;
        QObjekttypen qObjekttypen = QObjekttypen.objekttypen;
        Daten daten = new Daten();
        daten.setEntfernung(1051.155);
        daten.setExzentritaet(0.938316);
        daten.setUmlaufszeit(1.24479774E7);
        daten.setDurchmesser(300.0);
        daten.setAutor("Gerd G\u00fchne");
        daten.setStamp(Timestamp.from(Instant.now()));
        daten.setObjektid((Integer)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qObjekttypen.id).from((Expression<?>)qObjekttypen)).where(qObjekttypen.typ.eq("Kleinplanet"))).fetchFirst());
        Integer n = ((SQLInsertClause)this.datenbankverbinder.getNewSqlInsertClause(qDaten).populate(daten)).executeWithKey(qDaten.id);
        Namen namen = new Namen();
        namen.setNamen("2015 TG387");
        namen.setDatenid(n);
        ((SQLInsertClause)this.datenbankverbinder.getNewSqlInsertClause(qNamen).populate(namen)).execute();
        namen = new Namen();
        namen.setNamen("Goblin");
        namen.setDatenid(n);
        ((SQLInsertClause)this.datenbankverbinder.getNewSqlInsertClause(qNamen).populate(namen)).execute();
    }

    @Override
    public int updateToVersion() {
        return 20;
    }
}

