/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbankkern.impl.migration;

import com.google.inject.Inject;
import com.querydsl.sql.dml.SQLInsertClause;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.api.repos.EntdeckerTyp;
import de.planetensuche.datenbankkern.api.repos.EntdeckerWeltraumteleskope;
import de.planetensuche.datenbankkern.impl.migration.DatabaseUpdater;
import de.planetensuche.datenbankkern.querydsl5.Entdecker;
import de.planetensuche.datenbankkern.querydsl5.QEntdecker;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.sql.SQLException;

public final class Version23Migrator
implements DatabaseUpdater {
    private static final ILogging LOGGER = LoggingFactory.getLoggerForClass(Version23Migrator.class);
    private final IDatenbankverbinder datenbankverbinder;

    @Inject
    public Version23Migrator(IDatenbankverbinder iDatenbankverbinder) {
        this.datenbankverbinder = iDatenbankverbinder;
    }

    @Override
    public void update() throws SQLException {
        LOGGER.debug("starting DB migration to Version " + this.updateToVersion());
        QEntdecker qEntdecker = QEntdecker.entdecker;
        Entdecker entdecker = new Entdecker();
        entdecker.setFachgebiet("space telescope to find exoplanets by transit method");
        entdecker.setNachname("TESS Project");
        entdecker.setVorname("");
        entdecker.setTyp(EntdeckerTyp.PROJECT.getType());
        ((SQLInsertClause)this.datenbankverbinder.getNewSqlInsertClause(qEntdecker).populate(entdecker)).execute();
        entdecker = new Entdecker();
        entdecker.setFachgebiet("space telescope to find exoplanets by transit method");
        entdecker.setNachname(EntdeckerWeltraumteleskope.TESS.getNameInDatabase());
        entdecker.setVorname("");
        entdecker.setTyp(EntdeckerTyp.SPACE_TELESCOPE.getType());
        ((SQLInsertClause)this.datenbankverbinder.getNewSqlInsertClause(qEntdecker).populate(entdecker)).execute();
    }

    @Override
    public int updateToVersion() {
        return 23;
    }
}

