/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbankkern.impl.migration;

import com.google.inject.Inject;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.ProjectableSQLQuery;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLUpdateClause;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.impl.migration.DatabaseUpdater;
import de.planetensuche.datenbankkern.querydsl5.Namen;
import de.planetensuche.datenbankkern.querydsl5.QNamen;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.sql.SQLException;
import java.util.List;

public final class Version26Migrator
implements DatabaseUpdater {
    private static final ILogging LOGGER = LoggingFactory.getLoggerForClass(Version26Migrator.class);
    private final IDatenbankverbinder datenbankverbinder;

    @Inject
    public Version26Migrator(IDatenbankverbinder iDatenbankverbinder) {
        this.datenbankverbinder = iDatenbankverbinder;
    }

    @Override
    public void update() throws SQLException {
        LOGGER.debug("starting DB migration to Version " + this.updateToVersion());
        QNamen qNamen = QNamen.namen1;
        List list = ((SQLQuery)((SQLQuery)((ProjectableSQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().query()).select((Expression)qNamen)).from((Expression<?>)qNamen)).where(qNamen.namen.startsWith("TOI "))).fetch();
        if (list != null) {
            for (Namen namen : list) {
                String string = namen.getNamen().replace("TOI ", "TOI-");
                ((SQLUpdateClause)((SQLUpdateClause)this.datenbankverbinder.getNewSqlUpdateClause(qNamen).set((Path)qNamen.namen, string)).where((Predicate)qNamen.id.eq(namen.getId()))).execute();
                LOGGER.debug("change name " + namen.getNamen() + " to " + string);
            }
        }
    }

    @Override
    public int updateToVersion() {
        return 26;
    }
}

