/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbankkern.impl.migration;

import com.google.inject.Inject;
import com.querydsl.sql.dml.SQLInsertClause;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.api.repos.EntdeckerProjekte;
import de.planetensuche.datenbankkern.api.repos.EntdeckerTyp;
import de.planetensuche.datenbankkern.impl.migration.DatabaseUpdater;
import de.planetensuche.datenbankkern.querydsl5.Entdecker;
import de.planetensuche.datenbankkern.querydsl5.QEntdecker;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.sql.SQLException;

public final class Version27Migrator
implements DatabaseUpdater {
    private static final ILogging LOGGER = LoggingFactory.getLoggerForClass(Version27Migrator.class);
    private final IDatenbankverbinder datenbankverbinder;

    @Inject
    public Version27Migrator(IDatenbankverbinder iDatenbankverbinder) {
        this.datenbankverbinder = iDatenbankverbinder;
    }

    @Override
    public void update() throws SQLException {
        LOGGER.debug("starting DB migration to Version " + this.updateToVersion());
        QEntdecker qEntdecker = QEntdecker.entdecker;
        Entdecker entdecker = new Entdecker();
        entdecker.setFachgebiet("find interessting exoplanets for detailed study");
        entdecker.setNachname(EntdeckerProjekte.DMPP.getNameInDatabase());
        entdecker.setVorname("");
        entdecker.setTyp(EntdeckerTyp.PROJECT.getType());
        ((SQLInsertClause)this.datenbankverbinder.getNewSqlInsertClause(qEntdecker).populate(entdecker)).execute();
    }

    @Override
    public int updateToVersion() {
        return 27;
    }
}

