/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbankkern.impl.migration;

import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLDeleteClause;
import com.querydsl.sql.dml.SQLInsertClause;
import com.querydsl.sql.dml.SQLUpdateClause;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.impl.migration.DatabaseUpdater;
import de.planetensuche.datenbankkern.querydsl5.Daten;
import de.planetensuche.datenbankkern.querydsl5.Namen;
import de.planetensuche.datenbankkern.querydsl5.QDaten;
import de.planetensuche.datenbankkern.querydsl5.QNamen;
import de.planetensuche.datenbankkern.querydsl5.QObjekttypen;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Collection;

public final class Version28Migrator
implements DatabaseUpdater {
    private static final ILogging LOGGER = LoggingFactory.getLoggerForClass(Version28Migrator.class);
    private final IDatenbankverbinder datenbankverbinder;

    public Version28Migrator(IDatenbankverbinder iDatenbankverbinder) {
        this.datenbankverbinder = iDatenbankverbinder;
    }

    @Override
    public void update() throws SQLException {
        LOGGER.debug("starting DB migration to Version " + this.updateToVersion());
        QNamen qNamen = QNamen.namen1;
        long l = ((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qNamen.count()).from((Expression<?>)qNamen)).fetchCount();
        if (l < 10000L) {
            return;
        }
        ((SQLDeleteClause)this.datenbankverbinder.getNewSqlDeleteClause(qNamen).where((Predicate)qNamen.namen.eq("SAO 146107"))).execute();
        ((SQLDeleteClause)this.datenbankverbinder.getNewSqlDeleteClause(qNamen).where((Predicate)qNamen.namen.eq("HD 213051/2"))).execute();
        ((SQLDeleteClause)this.datenbankverbinder.getNewSqlDeleteClause(qNamen).where((Predicate)qNamen.namen.eq("HIP 110960"))).execute();
        ((SQLDeleteClause)this.datenbankverbinder.getNewSqlDeleteClause(qNamen).where((Predicate)qNamen.namen.eq("PPM 181465"))).execute();
        ((SQLUpdateClause)((SQLUpdateClause)this.datenbankverbinder.getNewSqlUpdateClause(qNamen).set((Path)qNamen.namen, "WDS J22288-0001A")).where((Predicate)qNamen.namen.eq("WDS J22288-0001"))).execute();
        Integer n = this.createStarABComponent(Arrays.asList("HIP 110960", "PPM 181465", "SAO 146107", "WDS J22288-0001AB", "2MASS J22284987-0001124"));
        this.setParentComponent(n, "Zeta01 Aquarii");
        this.setParentComponent(n, "Zeta02 Aquarii");
        ((SQLDeleteClause)this.datenbankverbinder.getNewSqlDeleteClause(qNamen).where((Predicate)qNamen.namen.eq("PPM 86047"))).execute();
        ((SQLDeleteClause)this.datenbankverbinder.getNewSqlDeleteClause(qNamen).where((Predicate)qNamen.namen.eq("FK5 793"))).execute();
        ((SQLUpdateClause)((SQLUpdateClause)this.datenbankverbinder.getNewSqlUpdateClause(qNamen).set((Path)qNamen.namen, "WDS J21069+3845A")).where((Predicate)qNamen.namen.eq("WDS J21069+3845"))).execute();
        Namen namen = new Namen();
        namen.setDatenid((Integer)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qNamen.datenid).from((Expression<?>)qNamen)).where(qNamen.namen.eq("61 Cygni B"))).fetchOne());
        namen.setNamen("WDS J21069+3845B");
        ((SQLInsertClause)this.datenbankverbinder.getNewSqlInsertClause(qNamen).populate(namen)).execute();
        Integer n2 = this.createStarABComponent(Arrays.asList("61 Cygni", "ADS 14636 AB", "FK5 793", "PPM 86047", "WDS J21069+3845AB"));
        this.setParentComponent(n2, "61 Cygni A");
        this.setParentComponent(n2, "61 Cygni B");
        ((SQLDeleteClause)this.datenbankverbinder.getNewSqlDeleteClause(qNamen).where((Predicate)qNamen.namen.eq("GJ 876 A"))).execute();
        ((SQLDeleteClause)this.datenbankverbinder.getNewSqlDeleteClause(qNamen).where((Predicate)qNamen.namen.eq("VVO 325"))).execute();
        ((SQLDeleteClause)this.datenbankverbinder.getNewSqlDeleteClause(qNamen).where((Predicate)qNamen.namen.eq("WD 2341+322"))).execute();
        ((SQLDeleteClause)this.datenbankverbinder.getNewSqlDeleteClause(qNamen).where((Predicate)qNamen.namen.eq("WDS J18571+3253"))).execute();
        ((SQLDeleteClause)this.datenbankverbinder.getNewSqlDeleteClause(qNamen).where((Predicate)qNamen.namen.eq("WDS J18570+3254AB"))).execute();
        ((SQLDeleteClause)this.datenbankverbinder.getNewSqlDeleteClause(qNamen).where((Predicate)qNamen.namen.eq("WDS J18570+3253AB"))).execute();
        ((SQLDeleteClause)this.datenbankverbinder.getNewSqlDeleteClause(qNamen).where((Predicate)qNamen.namen.eq("GCRV 8909"))).execute();
        ((SQLDeleteClause)this.datenbankverbinder.getNewSqlDeleteClause(qNamen).where((Predicate)qNamen.namen.eq("HD 137107/8"))).execute();
        ((SQLDeleteClause)this.datenbankverbinder.getNewSqlDeleteClause(qNamen).where((Predicate)qNamen.namen.eq("HIP 75312"))).execute();
        ((SQLUpdateClause)((SQLUpdateClause)this.datenbankverbinder.getNewSqlUpdateClause(qNamen).set((Path)qNamen.namen, "WDS J15232+3017A")).where((Predicate)qNamen.namen.eq("WDS J15232+3017"))).execute();
        Integer n3 = this.createStarABComponent(Arrays.asList("2 Coronae Borealis", "Eta Coronae Borealis", "ADS 9617 AB", "GCRV 8909", "HIP 75312", "WDS J15232+3017AB"));
        this.setParentComponent(n3, "2 Coronae Borealis A");
        this.setParentComponent(n3, "2 Coronae Borealis B");
        ((SQLDeleteClause)this.datenbankverbinder.getNewSqlDeleteClause(qNamen).where((Predicate)qNamen.namen.eq("CD-25 10549"))).execute();
        ((SQLDeleteClause)this.datenbankverbinder.getNewSqlDeleteClause(qNamen).where((Predicate)qNamen.namen.eq("CPD-23 501"))).execute();
        ((SQLDeleteClause)this.datenbankverbinder.getNewSqlDeleteClause(qNamen).where((Predicate)qNamen.namen.eq("XZ 54014"))).execute();
    }

    private void setParentComponent(Integer n, String string) throws SQLException {
        QDaten qDaten = QDaten.daten;
        QNamen qNamen = QNamen.namen1;
        Integer n2 = (Integer)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qNamen.datenid).from((Expression<?>)qNamen)).where(qNamen.namen.eq(string))).fetchOne();
        ((SQLUpdateClause)this.datenbankverbinder.getNewSqlUpdateClause(qDaten).set((Path)qDaten.zugehoerigkeit, n)).where((Predicate)qDaten.id.eq(n2));
    }

    private Integer createStarABComponent(Collection<String> collection) throws SQLException {
        QObjekttypen qObjekttypen = QObjekttypen.objekttypen;
        Integer n = (Integer)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qObjekttypen.id).from((Expression<?>)qObjekttypen)).where(qObjekttypen.typ.eq("Doppelstern physisch"))).fetchFirst();
        QDaten qDaten = QDaten.daten;
        Daten daten = new Daten();
        daten.setObjektid(n);
        daten.setAutor("Gerd G\u00fchne");
        daten.setStamp(new Timestamp(System.currentTimeMillis()));
        Integer n2 = ((SQLInsertClause)this.datenbankverbinder.getNewSqlInsertClause(qDaten).populate(daten)).executeWithKey(qDaten.id);
        QNamen qNamen = QNamen.namen1;
        for (String string : collection) {
            Namen namen = new Namen();
            namen.setDatenid(n2);
            namen.setNamen(string);
            ((SQLInsertClause)this.datenbankverbinder.getNewSqlInsertClause(qNamen).populate(namen)).execute();
        }
        return n2;
    }

    @Override
    public int updateToVersion() {
        return 28;
    }
}

