/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbankkern.impl.migration;

import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLDeleteClause;
import com.querydsl.sql.dml.SQLInsertClause;
import com.querydsl.sql.dml.SQLUpdateClause;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.impl.migration.DatabaseUpdater;
import de.planetensuche.datenbankkern.querydsl5.Daten;
import de.planetensuche.datenbankkern.querydsl5.Namen;
import de.planetensuche.datenbankkern.querydsl5.QDaten;
import de.planetensuche.datenbankkern.querydsl5.QNamen;
import de.planetensuche.datenbankkern.querydsl5.QObjekttypen;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Collection;

public final class Version29Migrator
implements DatabaseUpdater {
    private static final ILogging LOGGER = LoggingFactory.getLoggerForClass(Version29Migrator.class);
    private final IDatenbankverbinder datenbankverbinder;

    public Version29Migrator(IDatenbankverbinder iDatenbankverbinder) {
        this.datenbankverbinder = iDatenbankverbinder;
    }

    @Override
    public void update() throws SQLException {
        LOGGER.debug("starting DB migration to Version " + this.updateToVersion());
        QNamen qNamen = QNamen.namen1;
        long l = ((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qNamen.count()).from((Expression<?>)qNamen)).fetchCount();
        if (l < 10000L) {
            return;
        }
        this.addNameToExistingObject("Gl 581 d", "GJ 581 d");
        this.addNameToExistingObject("Zeta01 Aquarii", "WDS J22288-0001B");
        this.addNameToExistingObject("Zeta01 Aquarii", "ADS 15971 AB");
        ((SQLDeleteClause)this.datenbankverbinder.getNewSqlDeleteClause(qNamen).where((Predicate)qNamen.namen.eq("ADS 6335 AD"))).execute();
        ((SQLDeleteClause)this.datenbankverbinder.getNewSqlDeleteClause(qNamen).where((Predicate)qNamen.namen.eq("GJ 222 B"))).execute();
        ((SQLDeleteClause)this.datenbankverbinder.getNewSqlDeleteClause(qNamen).where((Predicate)qNamen.namen.eq("CD-22 1211"))).execute();
        ((SQLDeleteClause)this.datenbankverbinder.getNewSqlDeleteClause(qNamen).where((Predicate)qNamen.namen.eq("LHS 201"))).execute();
        ((SQLDeleteClause)this.datenbankverbinder.getNewSqlDeleteClause(qNamen).where((Predicate)qNamen.namen.eq("CSI+59 736 2"))).execute();
        ((SQLDeleteClause)this.datenbankverbinder.getNewSqlDeleteClause(qNamen).where((Predicate)qNamen.namen.eq("CSI+59 736 3"))).execute();
        ((SQLDeleteClause)this.datenbankverbinder.getNewSqlDeleteClause(qNamen).where((Predicate)qNamen.namen.eq("CSI+59 736 4"))).execute();
        ((SQLDeleteClause)this.datenbankverbinder.getNewSqlDeleteClause(qNamen).where((Predicate)qNamen.namen.eq("CSI+59 736 5"))).execute();
        ((SQLDeleteClause)this.datenbankverbinder.getNewSqlDeleteClause(qNamen).where((Predicate)qNamen.namen.eq("PPM 766138"))).execute();
        ((SQLDeleteClause)this.datenbankverbinder.getNewSqlDeleteClause(qNamen).where((Predicate)qNamen.namen.eq("Ups Andromedae"))).execute();
        ((SQLDeleteClause)this.datenbankverbinder.getNewSqlDeleteClause(qNamen).where((Predicate)qNamen.namen.eq("Ups And"))).execute();
        ((SQLDeleteClause)this.datenbankverbinder.getNewSqlDeleteClause(qNamen).where((Predicate)qNamen.namen.eq("HIP 94076"))).execute();
        ((SQLDeleteClause)this.datenbankverbinder.getNewSqlDeleteClause(qNamen).where((Predicate)qNamen.namen.eq("HD 178911"))).execute();
        ((SQLDeleteClause)this.datenbankverbinder.getNewSqlDeleteClause(qNamen).where((Predicate)qNamen.namen.eq("HD 178911B"))).execute();
        this.addNameToExistingObject("HIP 94075", "ADS 12101 B");
        this.addNameToExistingObject("HIP 94075", "STF 2474B");
        this.addNameToExistingObject("HIP 94075", "HD 178911B");
        this.addNameToExistingObject("HIP 94075", "ASCC 608589");
        this.addNameToExistingObject("HIP 94075", "2MASS J19090309+3435590");
        this.createDoubleStar(Arrays.asList("HD 178911A", "ADS 12101 A", "STF 2474A", "ASCC 608592", "BD+34 3439", "GC 26396", "GCRV 11621", "HIP 94076", "HR 7272", "LAL 35998", "LTT 15609", "2MASS J19090438+3436011", "NLTT 47474", "PPM 82386", "SAO 67879", "TYC 2648-2148-1", "WDS J19091+3436A", "Gaia DR2 2044341077844183040"));
        ((SQLDeleteClause)this.datenbankverbinder.getNewSqlDeleteClause(qNamen).where((Predicate)qNamen.namen.eq("CD-22 5691"))).execute();
        ((SQLDeleteClause)this.datenbankverbinder.getNewSqlDeleteClause(qNamen).where((Predicate)qNamen.namen.eq("ADS 6335 AD"))).execute();
        ((SQLDeleteClause)this.datenbankverbinder.getNewSqlDeleteClause(qNamen).where((Predicate)qNamen.namen.eq("CD-63 757"))).execute();
        ((SQLDeleteClause)this.datenbankverbinder.getNewSqlDeleteClause(qNamen).where((Predicate)qNamen.namen.eq("HIP 79098 A"))).execute();
        ((SQLDeleteClause)this.datenbankverbinder.getNewSqlDeleteClause(qNamen).where((Predicate)qNamen.namen.eq("GJ 229"))).execute();
        this.addNameToExistingObject("GJ 229 A", "8pc 173.19A");
        this.addNameToExistingObject("GJ 229 A", "WDS J06106-2152A");
        this.addNameToExistingObject("GJ 229 B", "8pc 173.19B");
        this.addNameToExistingObject("GJ 229 B", "WDS J06106-2152B");
        Integer n = this.createDoubleStar(Arrays.asList("GJ 229", "GJ 229 AB", "WDS J06106-2152AB", "8pc 173.19AB"));
        this.setParentComponent(n, "GJ 229 A");
        this.setParentComponent(n, "GJ 229 B");
        ((SQLDeleteClause)this.datenbankverbinder.getNewSqlDeleteClause(qNamen).where((Predicate)qNamen.namen.eq("PG 2341+323"))).execute();
        this.addNameToExistingObject("ASCC 646131", "PG 2341+323");
        ((SQLDeleteClause)this.datenbankverbinder.getNewSqlDeleteClause(qNamen).where((Predicate)qNamen.namen.eq("KIC 4862625 A"))).execute();
        this.addNameToExistingObject("KIC 4862625", "PH 1");
        n = this.createDoubleStar(Arrays.asList("NN Serpentis AB"));
        this.setParentComponent(n, "NN Serpentis A");
        this.setParentComponent(n, "NN Serpentis B");
        this.setParentComponent(n, "NN Serpentis (ab) c");
        this.setParentComponent(n, "NN Serpentis (ab) d");
        ((SQLUpdateClause)((SQLUpdateClause)this.datenbankverbinder.getNewSqlUpdateClause(qNamen).set((Path)qNamen.namen, "NN Serpentis AB c")).where((Predicate)qNamen.namen.eq("NN Serpentis (ab) c"))).execute();
        ((SQLUpdateClause)((SQLUpdateClause)this.datenbankverbinder.getNewSqlUpdateClause(qNamen).set((Path)qNamen.namen, "NN Serpentis AB d")).where((Predicate)qNamen.namen.eq("NN Serpentis (ab) d"))).execute();
        ((SQLUpdateClause)((SQLUpdateClause)this.datenbankverbinder.getNewSqlUpdateClause(qNamen).set((Path)qNamen.namen, "2MASS J21402931+1625183 A")).where((Predicate)qNamen.namen.eq("2MASS J21402931+1625183A"))).execute();
        ((SQLUpdateClause)((SQLUpdateClause)this.datenbankverbinder.getNewSqlUpdateClause(qNamen).set((Path)qNamen.namen, "2MASS J21402931+1625183 A b")).where((Predicate)qNamen.namen.eq("2MASS J21402931+1625183A b"))).execute();
        ((SQLUpdateClause)((SQLUpdateClause)this.datenbankverbinder.getNewSqlUpdateClause(qNamen).set((Path)qNamen.namen, "WASP-87 A")).where((Predicate)qNamen.namen.eq("WASP-87A"))).execute();
        ((SQLUpdateClause)((SQLUpdateClause)this.datenbankverbinder.getNewSqlUpdateClause(qNamen).set((Path)qNamen.namen, "WASP-87 A b")).where((Predicate)qNamen.namen.eq("WASP-87A b"))).execute();
    }

    private void addNameToExistingObject(String string, String string2) throws SQLException {
        QNamen qNamen = QNamen.namen1;
        Namen namen = new Namen();
        namen.setDatenid((Integer)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qNamen.datenid).from((Expression<?>)qNamen)).where(qNamen.namen.eq(string))).fetchOne());
        namen.setNamen(string2);
        ((SQLInsertClause)this.datenbankverbinder.getNewSqlInsertClause(qNamen).populate(namen)).execute();
    }

    private void setParentComponent(Integer n, String string) throws SQLException {
        QDaten qDaten = QDaten.daten;
        QNamen qNamen = QNamen.namen1;
        Integer n2 = (Integer)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qNamen.datenid).from((Expression<?>)qNamen)).where(qNamen.namen.eq(string))).fetchOne();
        ((SQLUpdateClause)this.datenbankverbinder.getNewSqlUpdateClause(qDaten).set((Path)qDaten.zugehoerigkeit, n)).where((Predicate)qDaten.id.eq(n2));
    }

    private Integer createDoubleStar(Collection<String> collection) throws SQLException {
        QObjekttypen qObjekttypen = QObjekttypen.objekttypen;
        Integer n = (Integer)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qObjekttypen.id).from((Expression<?>)qObjekttypen)).where(qObjekttypen.typ.eq("Doppelstern physisch"))).fetchFirst();
        QDaten qDaten = QDaten.daten;
        Daten daten = new Daten();
        daten.setObjektid(n);
        daten.setAutor("Gerd G\u00fchne");
        daten.setStamp(new Timestamp(System.currentTimeMillis()));
        Integer n2 = ((SQLInsertClause)this.datenbankverbinder.getNewSqlInsertClause(qDaten).populate(daten)).executeWithKey(qDaten.id);
        QNamen qNamen = QNamen.namen1;
        for (String string : collection) {
            Namen namen = new Namen();
            namen.setDatenid(n2);
            namen.setNamen(string);
            ((SQLInsertClause)this.datenbankverbinder.getNewSqlInsertClause(qNamen).populate(namen)).execute();
        }
        return n2;
    }

    @Override
    public int updateToVersion() {
        return 29;
    }
}

