/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbankkern.impl.migration;

import com.google.inject.Inject;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLDeleteClause;
import com.querydsl.sql.dml.SQLUpdateClause;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.impl.migration.DatabaseUpdater;
import de.planetensuche.datenbankkern.querydsl5.QObjektalter;
import de.planetensuche.datenbankkern.querydsl5.QSternbilder;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.sql.SQLException;
import java.util.List;

public final class Version2Migrator
implements DatabaseUpdater {
    private static final ILogging LOGGER = LoggingFactory.getLoggerForClass(Version2Migrator.class);
    private final IDatenbankverbinder datenbankverbinder;

    @Inject
    public Version2Migrator(IDatenbankverbinder iDatenbankverbinder) {
        this.datenbankverbinder = iDatenbankverbinder;
    }

    @Override
    public int updateToVersion() {
        return 2;
    }

    @Override
    public void update() throws SQLException {
        LOGGER.info("update Datenbank von Version 1 auf 2...");
        QSternbilder qSternbilder = QSternbilder.sternbilder;
        ((SQLUpdateClause)((SQLUpdateClause)this.datenbankverbinder.getNewSqlUpdateClause(qSternbilder).where((Predicate)qSternbilder.dtbezeichnung.eq("unbekannt").and(qSternbilder.latabk.eq("")))).set((Path)qSternbilder.latabk, "unb")).execute();
        QObjektalter qObjektalter = QObjektalter.objektalter;
        List list = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qObjektalter).from((Expression<?>)qObjektalter)).where(qObjektalter.datenid.eq(2625))).fetch();
        if (list.size() > 1) {
            LOGGER.info("loeschte doppelte datenid 2625...");
            ((SQLDeleteClause)this.datenbankverbinder.getNewSqlDeleteClause(qObjektalter).where((Predicate)qObjektalter.datenid.eq(2625))).execute();
        }
        List list2 = ((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qObjektalter.datenid).from((Expression<?>)qObjektalter)).groupBy((Expression<?>)qObjektalter.datenid)).having(qObjektalter.datenid.count().gt(1))).fetch();
        for (Integer n : list2) {
            LOGGER.info("loeschte doppelte datenid " + n + "...");
            ((SQLDeleteClause)this.datenbankverbinder.getNewSqlDeleteClause(qObjektalter).where((Predicate)qObjektalter.datenid.eq(n))).execute();
        }
        this.datenbankverbinder.query("ALTER TABLE objektalter ADD UNIQUE (datenid);");
    }
}

