/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbankkern.impl.migration;

import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLDeleteClause;
import com.querydsl.sql.dml.SQLInsertClause;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.impl.migration.DatabaseUpdater;
import de.planetensuche.datenbankkern.querydsl5.Namen;
import de.planetensuche.datenbankkern.querydsl5.QDaten;
import de.planetensuche.datenbankkern.querydsl5.QNamen;
import de.planetensuche.datenbankkern.querydsl5.QZt;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.sql.SQLException;
import java.util.Objects;

public final class Version30Migrator
implements DatabaseUpdater {
    private static final ILogging LOGGER = LoggingFactory.getLoggerForClass(Version30Migrator.class);
    private final IDatenbankverbinder datenbankverbinder;

    public Version30Migrator(IDatenbankverbinder iDatenbankverbinder) {
        this.datenbankverbinder = iDatenbankverbinder;
    }

    @Override
    public void update() throws SQLException {
        Integer n;
        LOGGER.debug("starting DB migration to Version " + this.updateToVersion());
        QNamen qNamen = QNamen.namen1;
        QDaten qDaten = QDaten.daten;
        QZt qZt = QZt.zt;
        long l = ((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qNamen.count()).from((Expression<?>)qNamen)).fetchCount();
        if (l < 1L) {
            return;
        }
        Integer n2 = (Integer)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qNamen.datenid).from((Expression<?>)qNamen)).where(qNamen.namen.eq("KOI-1257 b"))).fetchOne();
        if (!Objects.equals(n2, n = (Integer)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qNamen.datenid).from((Expression<?>)qNamen)).where(qNamen.namen.eq("KOI-1257.01"))).fetchOne())) {
            ((SQLDeleteClause)this.datenbankverbinder.getNewSqlDeleteClause(qZt).where((Predicate)qZt.datenid.eq(n2))).execute();
            ((SQLDeleteClause)this.datenbankverbinder.getNewSqlDeleteClause(qNamen).where((Predicate)qNamen.datenid.eq(n2))).execute();
            ((SQLDeleteClause)this.datenbankverbinder.getNewSqlDeleteClause(qDaten).where((Predicate)qDaten.id.eq(n2))).execute();
            this.addNameToExistingObject("KOI-1257.01", "KOI-1257 b");
        }
    }

    private void addNameToExistingObject(String string, String string2) throws SQLException {
        QNamen qNamen = QNamen.namen1;
        Namen namen = new Namen();
        namen.setDatenid((Integer)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qNamen.datenid).from((Expression<?>)qNamen)).where(qNamen.namen.eq(string))).fetchOne());
        namen.setNamen(string2);
        ((SQLInsertClause)this.datenbankverbinder.getNewSqlInsertClause(qNamen).populate(namen)).execute();
    }

    @Override
    public int updateToVersion() {
        return 30;
    }
}

