/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbankkern.impl.migration;

import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLDeleteClause;
import com.querydsl.sql.dml.SQLInsertClause;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.impl.migration.DatabaseUpdater;
import de.planetensuche.datenbankkern.querydsl5.Namen;
import de.planetensuche.datenbankkern.querydsl5.QDaten;
import de.planetensuche.datenbankkern.querydsl5.QNamen;
import de.planetensuche.datenbankkern.querydsl5.QZt;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.sql.SQLException;
import java.util.List;

public final class Version31Migrator
implements DatabaseUpdater {
    private static final ILogging LOGGER = LoggingFactory.getLoggerForClass(Version31Migrator.class);
    private final IDatenbankverbinder datenbankverbinder;

    public Version31Migrator(IDatenbankverbinder iDatenbankverbinder) {
        this.datenbankverbinder = iDatenbankverbinder;
    }

    @Override
    public void update() throws SQLException {
        List list;
        LOGGER.debug("starting DB migration to Version " + this.updateToVersion());
        QNamen qNamen = QNamen.namen1;
        QDaten qDaten = QDaten.daten;
        QZt qZt = QZt.zt;
        long l = ((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qNamen.count()).from((Expression<?>)qNamen)).fetchCount();
        if (l < 1L) {
            return;
        }
        Integer n = (Integer)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qNamen.datenid).from((Expression<?>)qNamen)).where(qNamen.namen.eq("KOI-1599 b"))).fetchOne();
        Integer n2 = (Integer)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qNamen.datenid).from((Expression<?>)qNamen)).where(qNamen.namen.eq("KOI-1599.02"))).fetchOne();
        if (n != null && n2 != null && !n.equals(n2)) {
            this.deletePsObject(qZt, n, qNamen, qDaten);
            this.addNameToExistingObject("KOI-1599.02", "KOI-1599 b");
        }
        n = (Integer)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qNamen.datenid).from((Expression<?>)qNamen)).where(qNamen.namen.eq("KOI-1599 c"))).fetchOne();
        n2 = (Integer)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qNamen.datenid).from((Expression<?>)qNamen)).where(qNamen.namen.eq("KOI-1599.01"))).fetchOne();
        if (n != null && n2 != null && !n.equals(n2)) {
            this.deletePsObject(qZt, n, qNamen, qDaten);
            this.addNameToExistingObject("KOI-1599.01", "KOI-1599 c");
        }
        if (!(list = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qNamen).from((Expression<?>)qNamen)).where(qNamen.namen.like("KOI-%."))).fetch()).isEmpty()) {
            for (Namen namen : list) {
                LOGGER.debug("remove invalid koi name '" + namen.getNamen() + "'");
                ((SQLDeleteClause)this.datenbankverbinder.getNewSqlDeleteClause(qNamen).where((Predicate)qNamen.id.eq(namen.getId()))).execute();
            }
        }
    }

    private void deletePsObject(QZt qZt, Integer n, QNamen qNamen, QDaten qDaten) throws SQLException {
        ((SQLDeleteClause)this.datenbankverbinder.getNewSqlDeleteClause(qZt).where((Predicate)qZt.datenid.eq(n))).execute();
        ((SQLDeleteClause)this.datenbankverbinder.getNewSqlDeleteClause(qNamen).where((Predicate)qNamen.datenid.eq(n))).execute();
        ((SQLDeleteClause)this.datenbankverbinder.getNewSqlDeleteClause(qDaten).where((Predicate)qDaten.id.eq(n))).execute();
    }

    private void addNameToExistingObject(String string, String string2) throws SQLException {
        QNamen qNamen = QNamen.namen1;
        Namen namen = new Namen();
        namen.setDatenid((Integer)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qNamen.datenid).from((Expression<?>)qNamen)).where(qNamen.namen.eq(string))).fetchOne());
        namen.setNamen(string2);
        ((SQLInsertClause)this.datenbankverbinder.getNewSqlInsertClause(qNamen).populate(namen)).execute();
    }

    @Override
    public int updateToVersion() {
        return 31;
    }
}

