/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbankkern.impl.migration;

import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLDeleteClause;
import com.querydsl.sql.dml.SQLUpdateClause;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.impl.migration.DatabaseUpdater;
import de.planetensuche.datenbankkern.querydsl5.Namen;
import de.planetensuche.datenbankkern.querydsl5.QNamen;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.sql.SQLException;
import java.util.List;

public final class Version33Migrator
implements DatabaseUpdater {
    private static final ILogging LOGGER = LoggingFactory.getLoggerForClass(Version33Migrator.class);
    private final IDatenbankverbinder datenbankverbinder;

    public Version33Migrator(IDatenbankverbinder iDatenbankverbinder) {
        this.datenbankverbinder = iDatenbankverbinder;
    }

    @Override
    public void update() throws SQLException {
        LOGGER.debug("starting DB migration to Version " + this.updateToVersion());
        QNamen qNamen = QNamen.namen1;
        List list = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qNamen).from((Expression<?>)qNamen)).where(qNamen.namen.startsWith("CPD"))).fetch();
        for (Namen namen : list) {
            String string = namen.getNamen();
            int n = string.indexOf(" ");
            if (n >= 1) continue;
            String string2 = string.substring(0, 6) + " " + string.substring(6);
            LOGGER.debug("found wrong catalog entry '" + string + "'; change to '" + string2 + "'");
            Namen namen2 = (Namen)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qNamen).from((Expression<?>)qNamen)).where(qNamen.namen.eq(string2))).fetchOne();
            if (namen2 == null) {
                ((SQLUpdateClause)((SQLUpdateClause)this.datenbankverbinder.getNewSqlUpdateClause(qNamen).set((Path)qNamen.namen, string2)).where((Predicate)qNamen.id.eq(namen.getId()))).execute();
                continue;
            }
            if (namen.getDatenid().equals(namen2.getDatenid())) {
                ((SQLDeleteClause)this.datenbankverbinder.getNewSqlDeleteClause(qNamen).where((Predicate)qNamen.id.eq(namen.getId()))).execute();
                continue;
            }
            LOGGER.warn("fixed name " + string2 + " already exists and used by another object!");
        }
    }

    @Override
    public int updateToVersion() {
        return 33;
    }
}

