/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbankkern.impl.migration;

import com.querydsl.core.types.Expression;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLInsertClause;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.impl.migration.DatabaseUpdater;
import de.planetensuche.datenbankkern.querydsl5.Daten;
import de.planetensuche.datenbankkern.querydsl5.Namen;
import de.planetensuche.datenbankkern.querydsl5.QDaten;
import de.planetensuche.datenbankkern.querydsl5.QNamen;
import de.planetensuche.datenbankkern.querydsl5.QObjekttypen;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;

public final class Version34Migrator
implements DatabaseUpdater {
    private static final ILogging LOGGER = LoggingFactory.getLoggerForClass(Version34Migrator.class);
    private final IDatenbankverbinder datenbankverbinder;

    public Version34Migrator(IDatenbankverbinder iDatenbankverbinder) {
        this.datenbankverbinder = iDatenbankverbinder;
    }

    @Override
    public void update() throws SQLException {
        LOGGER.debug("starting DB migration to Version " + this.updateToVersion());
        QObjekttypen qObjekttypen = QObjekttypen.objekttypen;
        int n = (Integer)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qObjekttypen.id).from((Expression<?>)qObjekttypen)).where(qObjekttypen.typ.eq("Asteroid"))).fetchFirst();
        Daten daten = new Daten();
        daten.setEntfernung(1.001);
        daten.setExzentritaet(0.104);
        daten.setDurchmesser(0.07);
        daten.setUmlaufszeit(365.875);
        daten.setGeschwindigkeit(29.69);
        daten.setEntdeckungsdatum("27.04.2016");
        daten.setAutor("Gerd G\u00fchne");
        daten.setStamp(Timestamp.from(Instant.now()));
        daten.setObjektid(n);
        this.insertAsteroid(daten, Arrays.asList("2016 HO3", "(469219) Kamooalewa"));
        daten = new Daten();
        daten.setEntfernung(81.418);
        daten.setExzentritaet(0.536);
        daten.setDurchmesser(500.0);
        daten.setUmlaufszeit(268275.0);
        daten.setGeschwindigkeit(0.33);
        daten.setEntdeckungsdatum("10.11.2018");
        daten.setAutor("Gerd G\u00fchne");
        daten.setStamp(Timestamp.from(Instant.now()));
        daten.setObjektid(n);
        this.insertAsteroid(daten, Arrays.asList("2018 VG18", "Farout"));
        daten = new Daten();
        daten.setEntfernung(1932.0);
        daten.setExzentritaet(0.98);
        daten.setUmlaufszeit(3.101405E7);
        daten.setEntdeckungsdatum("26.03.2014");
        daten.setAutor("Gerd G\u00fchne");
        daten.setStamp(Timestamp.from(Instant.now()));
        daten.setObjektid(n);
        this.insertAsteroid(daten, Arrays.asList("2014 FE72"));
    }

    private void insertAsteroid(Daten daten, List<String> list) throws SQLException {
        QDaten qDaten = QDaten.daten;
        QNamen qNamen = QNamen.namen1;
        Integer n = ((SQLInsertClause)this.datenbankverbinder.getNewSqlInsertClause(qDaten).populate(daten)).executeWithKey(qDaten.id);
        for (String string : list) {
            Namen namen = new Namen();
            namen.setNamen(string);
            namen.setDatenid(n);
            ((SQLInsertClause)this.datenbankverbinder.getNewSqlInsertClause(qNamen).populate(namen)).execute();
        }
    }

    @Override
    public int updateToVersion() {
        return 34;
    }
}

