/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbankkern.impl.migration;

import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLDeleteClause;
import com.querydsl.sql.dml.SQLUpdateClause;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.impl.migration.DatabaseUpdater;
import de.planetensuche.datenbankkern.querydsl5.Namen;
import de.planetensuche.datenbankkern.querydsl5.QNamen;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.sql.SQLException;
import java.util.List;

public final class Version35Migrator
implements DatabaseUpdater {
    private static final ILogging LOGGER = LoggingFactory.getLoggerForClass(Version35Migrator.class);
    private final IDatenbankverbinder datenbankverbinder;

    public Version35Migrator(IDatenbankverbinder iDatenbankverbinder) {
        this.datenbankverbinder = iDatenbankverbinder;
    }

    @Override
    public void update() throws SQLException {
        LOGGER.debug("starting DB migration to Version " + this.updateToVersion());
        QNamen qNamen = QNamen.namen1;
        List list = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qNamen).from((Expression<?>)qNamen)).where(qNamen.namen.like("KOI-%"))).fetch();
        for (Namen namen : list) {
            if (!namen.getNamen().endsWith(".")) continue;
            long l = ((SQLDeleteClause)this.datenbankverbinder.getNewSqlDeleteClause(qNamen).where((Predicate)qNamen.id.eq(namen.getId()))).execute();
            LOGGER.debug(l + " rows with wrong koi names deleted");
        }
        long l = ((SQLDeleteClause)this.datenbankverbinder.getNewSqlDeleteClause(qNamen).where((Predicate)qNamen.namen.like("WDS J%0"))).execute();
        l += ((SQLDeleteClause)this.datenbankverbinder.getNewSqlDeleteClause(qNamen).where((Predicate)qNamen.namen.like("WDS J%1"))).execute();
        l += ((SQLDeleteClause)this.datenbankverbinder.getNewSqlDeleteClause(qNamen).where((Predicate)qNamen.namen.like("WDS J%2"))).execute();
        l += ((SQLDeleteClause)this.datenbankverbinder.getNewSqlDeleteClause(qNamen).where((Predicate)qNamen.namen.like("WDS J%3"))).execute();
        l += ((SQLDeleteClause)this.datenbankverbinder.getNewSqlDeleteClause(qNamen).where((Predicate)qNamen.namen.like("WDS J%4"))).execute();
        l += ((SQLDeleteClause)this.datenbankverbinder.getNewSqlDeleteClause(qNamen).where((Predicate)qNamen.namen.like("WDS J%5"))).execute();
        l += ((SQLDeleteClause)this.datenbankverbinder.getNewSqlDeleteClause(qNamen).where((Predicate)qNamen.namen.like("WDS J%6"))).execute();
        l += ((SQLDeleteClause)this.datenbankverbinder.getNewSqlDeleteClause(qNamen).where((Predicate)qNamen.namen.like("WDS J%7"))).execute();
        l += ((SQLDeleteClause)this.datenbankverbinder.getNewSqlDeleteClause(qNamen).where((Predicate)qNamen.namen.like("WDS J%8"))).execute();
        LOGGER.debug((l += ((SQLDeleteClause)this.datenbankverbinder.getNewSqlDeleteClause(qNamen).where((Predicate)qNamen.namen.like("WDS J%9"))).execute()) + " rows with wrong wds names deleted");
        l = ((SQLDeleteClause)this.datenbankverbinder.getNewSqlDeleteClause(qNamen).where((Predicate)qNamen.namen.like("HD %/%"))).execute();
        LOGGER.debug(l + " rows with wrong hd names deleted");
        l = ((SQLDeleteClause)this.datenbankverbinder.getNewSqlDeleteClause(qNamen).where((Predicate)qNamen.namen.like("Kepler %"))).execute();
        LOGGER.debug(l + " rows with wrong kepler names deleted");
        List list2 = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qNamen).from((Expression<?>)qNamen)).where(qNamen.namen.like("KIC % A"))).fetch();
        for (Namen namen : list2) {
            String string = namen.getNamen().replace(" A", "A");
            long l2 = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qNamen.count()).from((Expression<?>)qNamen)).where(qNamen.namen.eq(string))).fetchCount();
            if (l2 == 0L) {
                ((SQLUpdateClause)((SQLUpdateClause)this.datenbankverbinder.getNewSqlUpdateClause(qNamen).set((Path)qNamen.namen, string)).where((Predicate)qNamen.id.eq(namen.getId()))).execute();
                continue;
            }
            ((SQLDeleteClause)this.datenbankverbinder.getNewSqlDeleteClause(qNamen).where((Predicate)qNamen.id.eq(namen.getId()))).execute();
        }
        LOGGER.debug(l + " rows with wrong kic names renamed/deleted");
    }

    @Override
    public int updateToVersion() {
        return 35;
    }
}

