/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbankkern.impl.migration;

import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLDeleteClause;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.impl.migration.DatabaseUpdater;
import de.planetensuche.datenbankkern.querydsl5.Namen;
import de.planetensuche.datenbankkern.querydsl5.QDaten;
import de.planetensuche.datenbankkern.querydsl5.QNamen;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;

public final class Version37Migrator
implements DatabaseUpdater {
    private static final ILogging LOGGER = LoggingFactory.getLoggerForClass(Version37Migrator.class);
    private final IDatenbankverbinder datenbankverbinder;

    public Version37Migrator(IDatenbankverbinder iDatenbankverbinder) {
        this.datenbankverbinder = iDatenbankverbinder;
    }

    @Override
    public void update() throws SQLException {
        LOGGER.debug("starting DB migration to Version " + this.updateToVersion());
        QNamen qNamen = QNamen.namen1;
        List<String> list = Arrays.asList("LHS 5299b", "CD-37 6571B", "WD 1544-377", "HIP 101955 A");
        for (String object2 : list) {
            ((SQLDeleteClause)this.datenbankverbinder.getNewSqlDeleteClause(qNamen).where((Predicate)qNamen.namen.eq(object2))).execute();
        }
        QDaten qDaten = QDaten.daten;
        Namen namen = (Namen)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qNamen).from((Expression<?>)qNamen)).where(qNamen.namen.eq("GJ 795 Ab"))).fetchOne();
        if (namen != null) {
            ((SQLDeleteClause)this.datenbankverbinder.getNewSqlDeleteClause(qNamen).where((Predicate)qNamen.id.eq(namen.getId()))).execute();
            ((SQLDeleteClause)this.datenbankverbinder.getNewSqlDeleteClause(qDaten).where((Predicate)qDaten.id.eq(namen.getDatenid()))).execute();
        }
    }

    @Override
    public int updateToVersion() {
        return 37;
    }
}

