/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbankkern.impl.migration;

import com.querydsl.core.types.Expression;
import com.querydsl.sql.SQLQuery;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.impl.migration.DatabaseUpdater;
import de.planetensuche.datenbankkern.impl.migration.MigrationHelper;
import de.planetensuche.datenbankkern.impl.migration.Version45Migrator;
import de.planetensuche.datenbankkern.querydsl5.QDaten;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.sql.SQLException;
import java.util.Arrays;

public final class Version39Migrator
implements DatabaseUpdater {
    private static final ILogging LOGGER = LoggingFactory.getLoggerForClass(Version39Migrator.class);
    private final IDatenbankverbinder datenbankverbinder;
    private final MigrationHelper helper;

    public Version39Migrator(IDatenbankverbinder iDatenbankverbinder) {
        this.datenbankverbinder = iDatenbankverbinder;
        this.helper = new MigrationHelper(iDatenbankverbinder);
    }

    @Override
    public void update() throws SQLException {
        LOGGER.debug("starting DB migration to Version " + this.updateToVersion());
        Version45Migrator version45Migrator = new Version45Migrator(this.datenbankverbinder);
        version45Migrator.update();
        QDaten qDaten = QDaten.daten;
        long l = ((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qDaten.count()).from((Expression<?>)qDaten)).fetchCount();
        if (l < 20000L) {
            return;
        }
        this.helper.deleteNamen(Arrays.asList("CPD-59 328", "CD-56 328B"));
        this.helper.addNamen("HR 486", "p Eridani A");
        this.helper.deleteNamen(Arrays.asList("CD-56 328A", "NLTT 5589", "GC 2030", "HIP 7751", "SAO 232490"));
        this.helper.renameName("p Eridani", "p Eridani B");
        this.helper.addNamen("HR 486", "NLTT 5589");
        this.helper.renameName("Gamma2 Arietis", "Gamma02 Arietis");
        this.helper.renameName("Gamma1 Arietis", "Gamma01 Arietis");
        this.helper.deleteName("HD 18926");
        this.helper.deleteNamen(Arrays.asList("HD 24071J", "HIP 17797"));
        this.helper.deletePlanetensucheObjects(Arrays.asList("CD-38 1297"));
        this.helper.deleteName("HIP 18255");
        this.helper.deleteNamen(Arrays.asList("HD 42126", "HD 42127", "SAO 40924", "SAO 40925", "HR 2175", "HR 2176", "HIP 29388"));
        try {
            this.helper.deleteName("HIP 36850 A");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.helper.deletePlanetensucheObjects(Arrays.asList("HIP 36850 A"));
        }
        this.helper.deleteNamen(Arrays.asList("HIP 40167 A", "HD 68255/7"));
        this.helper.deleteName("HD 71150");
        this.helper.deleteNamen(Arrays.asList("ADS 7093 A", "ADS 7093 B", "BD-07 2661A", "BD-07 2261B"));
        this.helper.deleteName("HIP 46657");
        this.helper.renameName("CD-31 7355", "CD-31 7355A");
        this.helper.deleteName("HD 83809");
        this.helper.renameName("BD+10 2044", "BD+10 2044A");
        this.helper.deleteNamen(Arrays.asList("GC 15537", "HIP 55203"));
        this.helper.deleteNamen(Arrays.asList("CD-28 8928A", "CD-28 8928B", "ADS 8202 A", "ADS 8202 B", "HIP 56280 A"));
        this.helper.deleteNamen(Arrays.asList("HIP 61941 A", "HIP 61941"));
        this.helper.deletePlanetensucheObjects(Arrays.asList("38 Virginis b"));
        this.helper.deletePlanetensucheObjects(Arrays.asList("38 Virginis"));
        this.helper.deleteNamen(Arrays.asList("HIP 71795", "30 Bootis", "BD+14 2770", "GC 19777", "HD 129246J", "Zeta Bootis"));
        this.helper.deleteNamen(Arrays.asList("HIP 75312", "2 Coronae Borealis", "Eta Coronae Borealis", "GCRV 8909"));
        this.helper.renameName("HIP 75312 A", "HIP 75312");
        this.helper.deleteName("HIP 76276");
        try {
            this.helper.deleteName("HIP 83608 A");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.helper.deletePlanetensucheObjects(Arrays.asList("HIP 83608 A"));
        }
        this.helper.deleteNamen(Arrays.asList("HIP 84405 B", "HIP 84405"));
        this.helper.deleteName("HIP 85112");
        this.helper.deleteName("HIP 88267");
        this.helper.deletePlanetensucheObjects(Arrays.asList("HD 164764/5"));
        this.helper.deletePlanetensucheObjects(Arrays.asList("5 Lyrae C"));
        this.helper.renameName("BD+39 3510", "BD+39 3510C");
        this.helper.renameName("5 Lyrae D", "5 Lyrae B");
        this.helper.renameName("5 Lyrae", "5 Lyrae A");
        this.helper.renameName("Epsilon2 Lyrae D", "Epsilon02 Lyrae B");
        this.helper.renameName("Epsilon2 Lyrae", "Epsilon02 Lyrae A");
        this.helper.renameName("HD 173607J", "HD 173607");
        this.helper.renameName("BD+46 2882", "BD+46 2882A");
        this.helper.deleteName("GCRV 7265 E");
        this.helper.renameName("3 Capricorni", "4 Capricorni");
        this.helper.deleteName("CD-22 5384");
        this.helper.deleteNamen(Arrays.asList("ADS 14592 B", "ADS 14592 A", "BD-06 5664B", "BD-06 5664A"));
        this.helper.deleteName("HIP 110778");
        this.helper.deleteName("ADS 15971 AB");
        try {
            this.helper.deleteName("HIP 110960 A");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.helper.deletePlanetensucheObjects(Arrays.asList("HIP 110960 A"));
        }
    }

    @Override
    public int updateToVersion() {
        return 39;
    }
}

