/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbankkern.impl.migration;

import com.google.inject.Inject;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLDeleteClause;
import com.querydsl.sql.dml.SQLUpdateClause;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.impl.migration.DatabaseUpdater;
import de.planetensuche.datenbankkern.querydsl5.Bilder;
import de.planetensuche.datenbankkern.querydsl5.QBilder;
import de.planetensuche.datenbankkern.querydsl5.QZt;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public final class Version3Migrator
implements DatabaseUpdater {
    private static final ILogging LOGGER = LoggingFactory.getLoggerForClass(Version3Migrator.class);
    private final IDatenbankverbinder datenbankverbinder;

    @Inject
    public Version3Migrator(IDatenbankverbinder iDatenbankverbinder) {
        this.datenbankverbinder = iDatenbankverbinder;
    }

    @Override
    public int updateToVersion() {
        return 3;
    }

    @Override
    public void update() throws SQLException {
        LOGGER.info("update Datenbank von Version 2 auf 3...");
        QBilder qBilder = QBilder.bilder;
        QZt qZt = QZt.zt;
        HashMap<String, Bilder> hashMap = new HashMap<String, Bilder>();
        ArrayList<Bilder> arrayList = new ArrayList<Bilder>();
        List list = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qBilder).from((Expression<?>)qBilder)).orderBy((OrderSpecifier<?>)qBilder.id.asc())).fetch();
        for (Bilder bilder : list) {
            Bilder bilder2 = (Bilder)hashMap.get(bilder.getBild());
            if (bilder2 == null) {
                hashMap.put(bilder.getBild(), bilder);
                continue;
            }
            ((SQLUpdateClause)((SQLUpdateClause)this.datenbankverbinder.getNewSqlUpdateClause(qZt).set((Path)qZt.bildid, bilder2.getId())).where((Predicate)qZt.bildid.eq(bilder.getId()))).execute();
            arrayList.add(bilder);
        }
        for (Bilder bilder : arrayList) {
            ((SQLDeleteClause)this.datenbankverbinder.getNewSqlDeleteClause(qBilder).where((Predicate)qBilder.id.eq(bilder.getId()))).execute();
        }
    }
}

