/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbankkern.impl.migration;

import com.querydsl.core.types.Expression;
import com.querydsl.sql.SQLQuery;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.impl.migration.DatabaseUpdater;
import de.planetensuche.datenbankkern.impl.migration.MigrationHelper;
import de.planetensuche.datenbankkern.querydsl5.QDaten;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.sql.SQLException;
import java.util.Arrays;

public final class Version46Migrator
implements DatabaseUpdater {
    private static final ILogging LOGGER = LoggingFactory.getLoggerForClass(Version46Migrator.class);
    private final IDatenbankverbinder datenbankverbinder;
    private final MigrationHelper helper;

    public Version46Migrator(IDatenbankverbinder iDatenbankverbinder) {
        this.datenbankverbinder = iDatenbankverbinder;
        this.helper = new MigrationHelper(iDatenbankverbinder);
    }

    @Override
    public void update() throws SQLException {
        LOGGER.debug("starting DB migration to Version " + this.updateToVersion());
        QDaten qDaten = QDaten.daten;
        long l = ((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qDaten.count()).from((Expression<?>)qDaten)).fetchCount();
        if (l < 20000L) {
            return;
        }
        this.helper.deleteNamen(Arrays.asList("ADS 683 A", "ADS 683 B", "BD+26 131A", "BD+26 131B"));
        this.helper.addNamen("HD 4757", "BD+26 131B");
        this.helper.addNamen("HD 4757", "ADS 683 B");
        this.helper.addNamen("HD 4758", "BD+26 131A");
        this.helper.addNamen("HD 4758", "ADS 683 A");
        this.helper.addNamen("Delta Orionis C", "Delta02 Orionis");
        this.helper.addNamen("Delta Orionis A", "Delta01 Orionis");
        this.helper.renameName("Alpha1 Geminorum", "Alpha01 Geminorum");
        this.helper.addNamen("HR 3310", "HD 71150");
        this.helper.deleteName("Y Velorum");
        this.helper.addNamen("HR 4134", "Y Velorum");
        this.helper.addNamen("CPD-67 2064B", "Beta Muscae B");
        this.helper.addNamen("CPD-67 2064B", "WDS J12463-6806B");
        this.helper.addNamen("HD 110879", "CPD-67 2064");
        this.helper.addNamen("HD 110879", "WDS J12463-6806AB");
        this.helper.deleteName("HIP 99675");
        this.helper.addNamen("HR 7735", "HIP 99675");
        this.helper.addNamen("HIP 110960", "ADS 15971 AB");
    }

    @Override
    public int updateToVersion() {
        return 46;
    }
}

