/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbankkern.impl.migration;

import com.querydsl.core.types.Expression;
import com.querydsl.sql.SQLQuery;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.impl.migration.DatabaseUpdater;
import de.planetensuche.datenbankkern.impl.migration.MigrationHelper;
import de.planetensuche.datenbankkern.querydsl5.QDaten;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.sql.SQLException;
import java.util.Arrays;

public final class Version47Migrator
implements DatabaseUpdater {
    private static final ILogging LOGGER = LoggingFactory.getLoggerForClass(Version47Migrator.class);
    private final IDatenbankverbinder datenbankverbinder;
    private final MigrationHelper helper;

    public Version47Migrator(IDatenbankverbinder iDatenbankverbinder) {
        this.datenbankverbinder = iDatenbankverbinder;
        this.helper = new MigrationHelper(iDatenbankverbinder);
    }

    @Override
    public void update() throws SQLException {
        LOGGER.debug("starting DB migration to Version " + this.updateToVersion());
        QDaten qDaten = QDaten.daten;
        long l = ((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qDaten.count()).from((Expression<?>)qDaten)).fetchCount();
        if (l < 20000L) {
            return;
        }
        this.helper.deleteName("12 Muscae");
        this.helper.deleteName("CD-22 1122");
        this.helper.deleteNamen(Arrays.asList("HD 33857", "HIP 24268"));
        this.helper.deleteName("CD-41 1727C");
        this.helper.deleteName("WDS J03183-0056AB");
        this.helper.deleteName("CPD-48 5");
        this.helper.deleteNamen(Arrays.asList("ADS 433 C", "ADS 440 C", "ADS 433 A", "ADS 440 A"));
        this.helper.renameName("DM+66 34", "BD+66 34");
        this.helper.deleteName("BD+07 9s");
        this.helper.deleteName("HD 531");
        this.helper.deleteName("Zkh 350");
        this.helper.addNamen("GJ 896 B", "Zkh 350");
        this.helper.deleteName("BD+19 5116A");
        this.helper.renameName("CCDM J23319+1956A", "CCDM J23319+1956AB");
    }

    @Override
    public int updateToVersion() {
        return 47;
    }
}

