/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbankkern.impl.migration;

import com.querydsl.core.types.Expression;
import com.querydsl.sql.SQLQuery;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.impl.migration.DatabaseUpdater;
import de.planetensuche.datenbankkern.impl.migration.MigrationHelper;
import de.planetensuche.datenbankkern.querydsl5.QDaten;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.sql.SQLException;
import java.util.Arrays;

public final class Version49Migrator
implements DatabaseUpdater {
    private static final ILogging LOGGER = LoggingFactory.getLoggerForClass(Version49Migrator.class);
    private final IDatenbankverbinder datenbankverbinder;
    private final MigrationHelper helper;

    public Version49Migrator(IDatenbankverbinder iDatenbankverbinder) {
        this.datenbankverbinder = iDatenbankverbinder;
        this.helper = new MigrationHelper(iDatenbankverbinder);
    }

    @Override
    public void update() throws SQLException {
        LOGGER.debug("starting DB migration to Version " + this.updateToVersion());
        QDaten qDaten = QDaten.daten;
        long l = ((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qDaten.count()).from((Expression<?>)qDaten)).fetchCount();
        if (l < 20000L) {
            return;
        }
        this.helper.deleteNamen(Arrays.asList("CPD-63 50C", "CPD-63 50B"));
        this.helper.deleteNamen(Arrays.asList("ADS 824 A", "ADS 824 B", "HIP 4675", "BD+43 193A", "BD+43 193B"));
        this.helper.addNamen("HD 5788", "ADS 824 B");
        this.helper.addNamen("HD 5788", "BD+43 193B");
        this.helper.addNamen("HD 5789", "ADS 824 A");
        this.helper.addNamen("HD 5789", "BD+43 193A");
        this.helper.addNamen("HD 5789", "HIP 4675");
        this.helper.deleteNamen(Arrays.asList("18 Persei A", "18 Persei B", "BD+52 641A", "BD+52 641B", "Tau Persei A", "Tau Persei B"));
        this.helper.addNamen("18 Persei", "WDS J02543+5246A");
        this.helper.deleteName("CD-22 515");
        this.helper.deleteName("HD 25639");
        this.helper.deleteName("HD 25638");
        this.helper.deleteName("BD+42 990B");
        this.helper.deleteNamen(Arrays.asList("HD 37269AB", "BD+30 963A", "BD+30 963B"));
        this.helper.deleteName("BD+20 1171a");
        this.helper.deleteNamen(Arrays.asList("HIP 31156", "HD 46136 B"));
        this.helper.addNamen("HIP 31158", "WDS J06323+1747A");
        this.helper.deleteNamen(Arrays.asList("BD-22 1576", "CD-22 1576"));
        this.helper.deleteName("CD-44 3040");
        this.helper.renameName("CD-44 3045A", "CD-44 3045");
        this.helper.deleteNamen(Arrays.asList("19 Lyncis A", "19 Lyncis B", "ADS 6012 A", "BD+55 1192A", "BD+55 1192B", "BD+55 1192", "ADS 6012 B"));
        this.helper.addNamen("HIP 35783", "19 Lyncis B");
        this.helper.addNamen("HIP 35783", "ADS 6012 B");
        this.helper.addNamen("HIP 35783", "BD+55 1192B");
        this.helper.addNamen("HIP 35785", "19 Lyncis A");
        this.helper.addNamen("HIP 35785", "ADS 6012 A");
        this.helper.addNamen("HIP 35785", "BD+55 1192");
        this.helper.deleteName("X Puppis");
        this.helper.deleteNamen(Arrays.asList("HD 81029A", "HIP 46028B"));
        this.helper.deleteName("Y Velorum");
        this.helper.deleteName("HIP 46657");
        this.helper.addNamen("Zeta01 Antliae", "HIP 46657");
        this.helper.deleteName("A Hydrae");
        this.helper.deleteName("HD 89694");
        this.helper.addNamen("HIP 50636", "WDS J10206-2338B ");
        this.helper.deleteName("PG 1314+293");
        this.helper.deleteName("HD 126531A");
        this.helper.deleteName("CPD-26 5583");
        this.helper.deleteName("38 Ophiuchi");
        this.helper.deleteName("CD-22 4585");
        this.helper.renameName("HD 336187", "HD 336196");
        this.helper.deleteNamen(Arrays.asList("CD-37 1286", "CD-37 6168", "CPD-37 3838"));
        this.helper.deleteName("BD+33 3223A");
        this.helper.deleteName("HD 349726");
        this.helper.deleteName("CD-45 1317");
        this.helper.deleteName("HD 183913");
        this.helper.deleteNamen(Arrays.asList("47 Aquilae A", "47 Aquilae B", "BD+11 3955A", "BD+11 3955B", "Chi Aquilae A", "Chi Aquilae B", "HD 186204"));
        this.helper.deleteNamen(Arrays.asList("47 Cygni A", "47 Cygni B", "BD+34 4079A", "BD+34 4079B"));
        this.helper.deleteName("CD-30 1848");
        this.helper.deleteName("HD 205811A");
        this.helper.deleteName("HIP 107156");
        this.helper.deleteNamen(Arrays.asList("ADS 15275 A"));
        this.helper.addNamen("BD+28 4171", "WDS J21441+2845D");
        this.helper.addNamen("ADS 15270 C", "WDS J21441+2845C");
        this.helper.renameName("WDS J21441+2844A", "WDS J21441+2845A");
        this.helper.renameName("WDS J21441+2844B", "WDS J21441+2845B");
        this.helper.deleteNamen(Arrays.asList("HD 214167", "HIP 111546", "HD 214168", "HIP 111544", "BD+38 4808"));
        this.helper.addNamen("BD+38 4808B", "HD 214168");
        this.helper.addNamen("BD+38 4808B", "HIP 111544");
        this.helper.addNamen("BD+38 4808A", "HD 214167");
        this.helper.addNamen("BD+38 4808A", "HIP 111546");
        this.helper.deleteName("BD+31 4181A");
        this.helper.deleteName("BD+47 3059A");
        this.helper.deleteName("BD+24 547A");
    }

    @Override
    public int updateToVersion() {
        return 49;
    }
}

