/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbankkern.impl.migration;

import com.google.inject.Inject;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLDeleteClause;
import com.querydsl.sql.dml.SQLUpdateClause;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.impl.migration.DatabaseUpdater;
import de.planetensuche.datenbankkern.impl.migration.MigrationHelper;
import de.planetensuche.datenbankkern.querydsl5.QDaten;
import de.planetensuche.datenbankkern.querydsl5.QNamen;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.sql.SQLException;
import java.sql.SQLSyntaxErrorException;
import java.util.List;

public final class Version4Migrator
implements DatabaseUpdater {
    private static final ILogging LOGGER = LoggingFactory.getLoggerForClass(Version4Migrator.class);
    private final IDatenbankverbinder datenbankverbinder;
    private final MigrationHelper migrationHelper;

    @Inject
    public Version4Migrator(IDatenbankverbinder iDatenbankverbinder) {
        this.datenbankverbinder = iDatenbankverbinder;
        this.migrationHelper = new MigrationHelper(this.datenbankverbinder);
    }

    @Override
    public int updateToVersion() {
        return 4;
    }

    @Override
    public void update() throws SQLException {
        LOGGER.info("update Datenbank von Version 3 auf 4...");
        QDaten qDaten = QDaten.daten;
        try {
            this.datenbankverbinder.query("ALTER TABLE daten ADD EntdeckungBestaetigt BOOLEAN;");
            ((SQLUpdateClause)this.datenbankverbinder.getNewSqlUpdateClause(qDaten).set((Path)qDaten.entdeckungbestaetigt, (Object)true)).execute();
        }
        catch (SQLSyntaxErrorException sQLSyntaxErrorException) {
            LOGGER.debug("Spalte EntdeckungBestaetigt bereits vorhanden", sQLSyntaxErrorException);
        }
        List list = ((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qDaten.id).from((Expression<?>)qDaten)).where(qDaten.autor.eq("Jean Schneider").or(qDaten.autor.eq("NASA")))).orderBy((OrderSpecifier<?>)qDaten.id.desc())).fetch();
        QNamen qNamen = QNamen.namen1;
        for (Integer n : list) {
            List list2 = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qNamen.namen).from((Expression<?>)qNamen)).where(qNamen.datenid.eq(n))).fetch();
            LOGGER.debug("l\u00f6sche " + String.valueOf(list2));
            this.migrationHelper.deletePlanetensucheObject(n);
        }
        ((SQLDeleteClause)this.datenbankverbinder.getNewSqlDeleteClause(qNamen).where((Predicate)qNamen.namen.eq("KOI-13.01"))).execute();
    }
}

