/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbankkern.impl.migration;

import com.google.inject.Inject;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLUpdateClause;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.impl.migration.DatabaseUpdater;
import de.planetensuche.datenbankkern.impl.migration.MigrationHelper;
import de.planetensuche.datenbankkern.querydsl5.Daten;
import de.planetensuche.datenbankkern.querydsl5.QDaten;
import de.planetensuche.datenbankkern.querydsl5.QNamen;
import de.planetensuche.datenbankkern.querydsl5.QObjekttypen;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.sql.SQLException;
import java.util.ArrayList;

public final class Version5Migrator
implements DatabaseUpdater {
    private static final ILogging LOGGER = LoggingFactory.getLoggerForClass(Version5Migrator.class);
    private final IDatenbankverbinder datenbankverbinder;
    private final MigrationHelper migrationHelper;

    @Inject
    public Version5Migrator(IDatenbankverbinder iDatenbankverbinder) {
        this.datenbankverbinder = iDatenbankverbinder;
        this.migrationHelper = new MigrationHelper(this.datenbankverbinder);
    }

    @Override
    public int updateToVersion() {
        return 5;
    }

    @Override
    public void update() throws SQLException {
        Daten daten;
        LOGGER.info("update Datenbank von Version 4 auf 5...");
        QNamen qNamen = QNamen.namen1;
        QDaten qDaten = QDaten.daten;
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("HD 41248 b");
        arrayList.add("HD 41248 c");
        arrayList.add("HD 219449A b");
        arrayList.add("HD 219449 b");
        arrayList.add("WASP-9 b");
        arrayList.add("HD 191760 b");
        arrayList.add("HD 191760 c");
        arrayList.add("HD 149382 b");
        arrayList.add("HIP 13044 b");
        this.migrationHelper.deletePlanetensucheObjects(arrayList);
        Integer n = (Integer)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qNamen.datenid).from((Expression<?>)qNamen)).where(qNamen.namen.eq("KOI-872"))).fetchFirst();
        Integer n2 = (Integer)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qNamen.datenid).from((Expression<?>)qNamen)).where(qNamen.namen.eq("Kepler-46 c"))).fetchFirst();
        if (n == null || n2 == null) {
            LOGGER.warn("sternId " + n + " f\u00fcr KOI-872 oder planetId " + n2 + " f\u00fcr Kepler-46 c ist null");
        } else {
            ((SQLUpdateClause)((SQLUpdateClause)this.datenbankverbinder.getNewSqlUpdateClause(qDaten).set((Path)qDaten.zugehoerigkeit, n)).where((Predicate)qDaten.id.eq(n2))).execute();
        }
        arrayList.clear();
        arrayList.add("Kepler-40");
        arrayList.add("Kepler-41");
        arrayList.add("FU Tauri A b");
        arrayList.add("Kepler-44");
        arrayList.add("Kepler-43");
        arrayList.add("Kepler-45");
        arrayList.add("Kepler-46");
        arrayList.add("KOI-872 c");
        arrayList.add("KOI-152");
        arrayList.add("KOI-202");
        arrayList.add("KOI-500");
        arrayList.add("Qatar-1");
        arrayList.add("KOI-730");
        arrayList.add("KOI-200");
        this.migrationHelper.deletePlanetensucheObjects(arrayList);
        this.migrationHelper.addNamen("KOI-428", "Kepler-40");
        this.migrationHelper.addNamen("KOI-428 b", "Kepler-40 b");
        this.migrationHelper.addNamen("KOI-428 b", "KOI-428.01");
        this.migrationHelper.addNamen("KOI-428 b", "KIC 10418224 b");
        this.migrationHelper.addNamen("KOI-196", "Kepler-41");
        this.migrationHelper.addNamen("KOI-196 b", "Kepler-41 b");
        this.migrationHelper.addNamen("KOI-196 b", "KIC 9410930 b");
        this.migrationHelper.addNamen("KOI-196 b", "KOI-196.01");
        this.migrationHelper.addNamen("FU Tauri b", "FU Tauri A b");
        this.migrationHelper.addNamen("KOI-204", "Kepler-44");
        this.migrationHelper.addNamen("KOI-204 b", "Kepler-44 b");
        this.migrationHelper.addNamen("KOI-204 b", "KIC 9305831 b");
        this.migrationHelper.addNamen("KOI-204 b", "KOI-204.01");
        this.migrationHelper.addNamen("KOI-135", "Kepler-43");
        this.migrationHelper.addNamen("KOI-135 b", "Kepler-43 b");
        this.migrationHelper.addNamen("KOI-135 b", "KIC 9818381 b");
        this.migrationHelper.addNamen("KOI-135 b", "KOI-135.01");
        this.migrationHelper.addNamen("KOI-254", "Kepler-45");
        this.migrationHelper.addNamen("KOI-254 b", "Kepler-45 b");
        this.migrationHelper.addNamen("KOI-254 b", "KIC 5794240 b");
        this.migrationHelper.addNamen("KOI-254 b", "KOI-254.01");
        this.migrationHelper.addNamen("KOI-872", "Kepler-46");
        this.migrationHelper.addNamen("KOI-872 b", "Kepler-46 b");
        this.migrationHelper.addNamen("KOI-872 b", "KIC 7109675 b");
        this.migrationHelper.addNamen("KOI-872 b", "KOI-872.01");
        this.migrationHelper.addNamen("Kepler-79", "KOI-152");
        this.migrationHelper.addNamen("Kepler-79", "USNO-B1.0 1343-00382298");
        this.migrationHelper.addNamen("Kepler-79", "KIC 8394721");
        this.migrationHelper.addNamen("Kepler-79", "2MASS J20020411+4422536");
        this.migrationHelper.addNamen("Kepler-412", "KOI-202");
        this.migrationHelper.addNamen("Kepler-412", "KIC 7877496");
        this.migrationHelper.addNamen("Kepler-412", "2MASS J19042647+4340514");
        this.migrationHelper.addNamen("Kepler-80", "KOI-500");
        this.migrationHelper.addNamen("Kepler-223", "KOI-730");
        this.migrationHelper.addNamen("Kepler-74", "KOI-200");
        this.migrationHelper.setzeAufUnbestaetigt("HD 188753 A b");
        this.migrationHelper.setzeAufUnbestaetigt("GD 66 b");
        this.migrationHelper.setzeAufUnbestaetigt("TW Hydrae b");
        this.migrationHelper.setzeAufUnbestaetigt("HD 111031 b");
        this.migrationHelper.setzeAufUnbestaetigt("QS Virginis b");
        this.migrationHelper.setzeAufUnbestaetigt("MOA-2008-BLG-401 b");
        this.migrationHelper.setzeAufUnbestaetigt("HIP 11952 b");
        this.migrationHelper.setzeAufUnbestaetigt("HIP 11952 c");
        this.migrationHelper.setzeAufUnbestaetigt("KIC 8852719 b");
        this.migrationHelper.setzeAufUnbestaetigt("NSVS 1425(AB) b");
        this.migrationHelper.setzeAufUnbestaetigt("NSVS 1425(AB) c");
        QObjekttypen qObjekttypen = QObjekttypen.objekttypen;
        Integer n3 = (Integer)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qObjekttypen.id).from((Expression<?>)qObjekttypen)).where(qObjekttypen.typ.eq("Brauner Zwerg"))).fetchFirst();
        try {
            daten = this.migrationHelper.readPlanetensucheObject("HD 16760 b");
            if (daten != null) {
                daten.setMasse(280.0);
                daten.setObjektid(n3);
                this.migrationHelper.updatePlanetensucheObjekt(daten);
            }
        }
        catch (IllegalArgumentException | SQLException exception) {
            LOGGER.error("Fehler beim Aktualisieren von HD 16760 b", exception);
        }
        try {
            daten = this.migrationHelper.readPlanetensucheObject("HD 5388 b");
            if (daten != null) {
                daten.setMasse(69.0);
                daten.setObjektid(n3);
                this.migrationHelper.updatePlanetensucheObjekt(daten);
            }
        }
        catch (IllegalArgumentException | SQLException exception) {
            LOGGER.error("Fehler beim Aktualisieren von HD 5388 b", exception);
        }
        try {
            ((SQLUpdateClause)((SQLUpdateClause)this.datenbankverbinder.getNewSqlUpdateClause(qNamen).set((Path)qNamen.namen, "Qatar-1")).where((Predicate)qNamen.namen.eq("Quatar-1"))).execute();
            ((SQLUpdateClause)((SQLUpdateClause)this.datenbankverbinder.getNewSqlUpdateClause(qNamen).set((Path)qNamen.namen, "Qatar-1 b")).where((Predicate)qNamen.namen.eq("Quatar-1 b"))).execute();
        }
        catch (IllegalArgumentException | SQLException exception) {
            LOGGER.error("Fehler beim Aktualisieren von Qatar-1 und Qatar-1 b", exception);
        }
        try {
            ((SQLUpdateClause)((SQLUpdateClause)this.datenbankverbinder.getNewSqlUpdateClause(qNamen).set((Path)qNamen.namen, "BD+28 103")).where((Predicate)qNamen.namen.eq("BD+28 103:FK5 19"))).execute();
            this.migrationHelper.addNamen("BD+28 103", "FK5 19");
        }
        catch (IllegalArgumentException | SQLException exception) {
            LOGGER.error("Fehler beim Aktualisieren von 30 And", exception);
        }
        this.migrationHelper.addNamen("XO-2", "XO-2B");
        this.migrationHelper.addNamen("XO-2", "XO-2N");
        this.migrationHelper.addNamen("XO-2 b", "XO-2N b");
        this.migrationHelper.addNamen("XO-2 b", "XO-2B b");
    }
}

