/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbankkern.impl.migration;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import de.planetensuche.core.Check;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.impl.migration.DatabaseUpdater;
import de.planetensuche.datenbankkern.impl.migration.MigrationHelper;
import de.planetensuche.datenbankkern.querydsl5.Daten;
import de.planetensuche.datenbankkern.querydsl5.QDaten;
import de.planetensuche.datenbankkern.querydsl5.QNamen;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.sql.SQLException;
import java.util.List;

public final class Version61Migrator
implements DatabaseUpdater {
    private static final ILogging LOGGER = LoggingFactory.getLoggerForClass(Version61Migrator.class);
    private final IDatenbankverbinder datenbankverbinder;
    private final MigrationHelper helper;

    public Version61Migrator(IDatenbankverbinder iDatenbankverbinder) {
        this.datenbankverbinder = iDatenbankverbinder;
        this.helper = new MigrationHelper(iDatenbankverbinder);
    }

    @Override
    public void update() throws SQLException {
        LOGGER.debug("starting DB migration to Version " + this.updateToVersion());
        QDaten qDaten = QDaten.daten;
        QNamen qNamen = QNamen.namen1;
        List list = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qDaten.id).from((Expression<?>)qDaten)).leftJoin((EntityPath)qNamen)).on((Predicate)qDaten.id.eq(qNamen.datenid))).where(qNamen.datenid.isNull())).fetch();
        LOGGER.warn("insgesamt " + list.size() + " objekte ohne namen zum l\u00f6schen gefunden");
        for (Integer n : list) {
            LOGGER.warn("keine Namen f\u00fcr datenid " + n + " gefunden; objekt wird gel\u00f6scht");
            List list2 = ((SQLQuery)this.datenbankverbinder.getQueryFactory().selectFrom((RelationalPath)qDaten).where(qDaten.zugehoerigkeit.eq(n))).fetch();
            try {
                if (Check.isFilled(list2)) {
                    LOGGER.warn("datenid " + n + " hat noch " + list2.size() + " Kindobjekte; Kinder werden auch gel\u00f6scht...");
                    for (Daten daten : list2) {
                        this.helper.deletePlanetensucheObject(daten.getId());
                    }
                }
                this.helper.deletePlanetensucheObject(n);
            }
            catch (RuntimeException runtimeException) {
                LOGGER.warn("Objekt ohne Namen konnte nicht gel\u00f6scht werden, (parent) datenId = " + n);
            }
        }
    }

    @Override
    public int updateToVersion() {
        return 61;
    }
}

