/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbankkern.impl.migration;

import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLUpdateClause;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.impl.migration.DatabaseUpdater;
import de.planetensuche.datenbankkern.querydsl5.QDaten;
import de.planetensuche.datenbankkern.querydsl5.QNamen;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.sql.SQLSyntaxErrorException;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.FileUtils;

public final class Version62Migrator
implements DatabaseUpdater {
    private static final ILogging LOGGER = LoggingFactory.getLoggerForClass(Version62Migrator.class);
    private final IDatenbankverbinder datenbankverbinder;

    public Version62Migrator(IDatenbankverbinder iDatenbankverbinder) {
        this.datenbankverbinder = iDatenbankverbinder;
    }

    @Override
    public void update() throws SQLException {
        LOGGER.debug("starting DB migration to Version " + this.updateToVersion());
        try {
            this.datenbankverbinder.query("SELECT * FROM namen WHERE isEigenname IS true;");
            return;
        }
        catch (SQLSyntaxErrorException sQLSyntaxErrorException) {
            this.datenbankverbinder.query("ALTER TABLE namen ADD COLUMN isEigenname BOOLEAN DEFAULT false NOT NULL;");
            QDaten qDaten = QDaten.daten;
            long l = ((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qDaten.id.count()).from((Expression<?>)qDaten)).fetchCount();
            if (l < 20000L) {
                return;
            }
            QNamen qNamen = QNamen.namen1;
            for (String string : Arrays.asList("namen.txt", "namen2.txt", "namen3.txt", "namen4.txt")) {
                try {
                    List<String> list = FileUtils.readLines(new File("temp" + File.separator + string), StandardCharsets.UTF_8);
                    ((SQLUpdateClause)((SQLUpdateClause)this.datenbankverbinder.getNewSqlUpdateClause(qNamen).set((Path)qNamen.iseigenname, (Object)true)).where((Predicate)qNamen.namen.in(list))).execute();
                    LOGGER.info("Datei " + string + " erfolgreich verarbeitet.");
                }
                catch (IOException | RuntimeException exception) {
                    LOGGER.error("Fehler beim Verarbeiten der " + string + " Datei", exception);
                }
            }
            return;
        }
    }

    @Override
    public int updateToVersion() {
        return 62;
    }
}

